/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AEVerifierException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.update.UpdateManagerVerificationListener;
import org.gudy.azureus2.pluginsimpl.local.update.UpdatableComponentImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateCheckInstanceImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateInstallerImpl;

public class UpdateManagerImpl
implements UpdateManager {
    private static UpdateManagerImpl singleton;
    private AzureusCore azureus_core;
    private List<UpdateCheckInstanceImpl> checkers = new ArrayList<UpdateCheckInstanceImpl>();
    private List<UpdatableComponentImpl> components = new ArrayList<UpdatableComponentImpl>();
    private List listeners = new ArrayList();
    private List verification_listeners = new ArrayList();
    private List<UpdateInstaller> installers = new ArrayList<UpdateInstaller>();
    protected AEMonitor this_mon = new AEMonitor("UpdateManager");

    public static UpdateManager getSingleton(AzureusCore azureusCore) {
        if (singleton == null) {
            singleton = new UpdateManagerImpl(azureusCore);
        }
        return singleton;
    }

    protected UpdateManagerImpl(AzureusCore azureusCore) {
        this.azureus_core = azureusCore;
        UpdateInstallerImpl.checkForFailedInstalls(this);
        try {
            PlatformManagerFactory.getPlatformManager();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected AzureusCore getCore() {
        return this.azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUpdatableComponent(UpdatableComponent updatableComponent, boolean bl) {
        try {
            this.this_mon.enter();
            this.components.add(new UpdatableComponentImpl(updatableComponent, bl));
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstance[] getCheckInstances() {
        try {
            this.this_mon.enter();
            UpdateCheckInstance[] updateCheckInstanceArray = this.checkers.toArray(new UpdateCheckInstance[this.checkers.size()]);
            Object var3_2 = null;
            this.this_mon.exit();
            return updateCheckInstanceArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateCheckInstance createUpdateCheckInstance() {
        return this.createUpdateCheckInstance(2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstance createUpdateCheckInstance(int n, String string) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] updatableComponentImplArray = new UpdatableComponentImpl[this.components.size()];
            this.components.toArray(updatableComponentImplArray);
            UpdateCheckInstanceImpl updateCheckInstanceImpl = new UpdateCheckInstanceImpl(this, n, string, updatableComponentImplArray);
            this.checkers.add(updateCheckInstanceImpl);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(updateCheckInstanceImpl);
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl2 = updateCheckInstanceImpl;
            Object var7_7 = null;
            this.this_mon.exit();
            return updateCheckInstanceImpl2;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int n, String string) {
        return this.createEmptyUpdateCheckInstance(n, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCheckInstanceImpl createEmptyUpdateCheckInstance(int n, String string, boolean bl) {
        try {
            this.this_mon.enter();
            UpdatableComponentImpl[] updatableComponentImplArray = new UpdatableComponentImpl[]{};
            UpdateCheckInstanceImpl updateCheckInstanceImpl = new UpdateCheckInstanceImpl(this, n, string, updatableComponentImplArray);
            updateCheckInstanceImpl.setLowNoise(bl);
            this.checkers.add(updateCheckInstanceImpl);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((UpdateManagerListener)this.listeners.get(i)).checkInstanceCreated(updateCheckInstanceImpl);
            }
            UpdateCheckInstanceImpl updateCheckInstanceImpl2 = updateCheckInstanceImpl;
            Object var8_8 = null;
            this.this_mon.exit();
            return updateCheckInstanceImpl2;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UpdateInstaller createInstaller() throws UpdateException {
        UpdateInstallerImpl updateInstallerImpl = new UpdateInstallerImpl(this);
        this.installers.add(updateInstallerImpl);
        return updateInstallerImpl;
    }

    public UpdateInstaller[] getInstallers() {
        UpdateInstaller[] updateInstallerArray = new UpdateInstaller[this.installers.size()];
        this.installers.toArray(updateInstallerArray);
        return updateInstallerArray;
    }

    protected void removeInstaller(UpdateInstaller updateInstaller) {
        this.installers.remove(updateInstaller);
    }

    public String getInstallDir() {
        String string = SystemProperties.getApplicationPath();
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getUserDir() {
        String string = SystemProperties.getUserPath();
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void restart() throws UpdateException {
        this.applyUpdates(true);
    }

    public void applyUpdates(boolean bl) throws UpdateException {
        try {
            if (bl) {
                this.azureus_core.requestRestart();
            } else {
                this.azureus_core.requestStop();
            }
        }
        catch (Throwable throwable) {
            throw new UpdateException("UpdateManager:applyUpdates fails", throwable);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream verifyData(Update var1_1, InputStream var2_2, boolean var3_3) throws UpdateException {
        var4_4 = false;
        var5_5 = false;
        var6_6 /* !! */  = null;
        try {
            try {
                var7_7 = AETemporaryFileHandler.createTempFile();
                FileUtil.copyFile(var2_2, var7_7);
                try {
                    AEVerifier.verifyData(var7_7);
                    var5_5 = true;
                    var8_10 = new FileInputStream(var7_7);
                    ** GOTO lbl40
                }
                catch (AEVerifierException var8_11) {
                    block28: {
                        block27: {
                            block25: {
                                if (var3_3 || var8_11.getFailureType() != 1) break block27;
                                var9_21 = 0;
lbl16:
                                // 2 sources

                                while (var9_21 < this.verification_listeners.size()) {
                                    try {
                                        var4_4 = true;
                                        if (!((UpdateManagerVerificationListener)this.verification_listeners.get(var9_21)).acceptUnVerifiedUpdate(var1_1)) break block25;
                                        var5_5 = true;
                                        var10_23 = new FileInputStream(var7_7);
                                    }
                                    catch (Throwable var10_22) {
                                        Debug.printStackTrace(var10_22);
                                        break block25;
                                    }
                                    var12_13 = null;
                                    if (var4_4 != false) return var10_23;
                                    if (!var5_5) {
                                        if (var6_6 /* !! */  == null) {
                                            var6_6 /* !! */  = new UpdateException("Verification failed");
                                        }
                                        for (var13_16 = 0; var13_16 < this.verification_listeners.size(); ++var13_16) {
                                            try {
                                                ((UpdateManagerVerificationListener)this.verification_listeners.get(var13_16)).verificationFailed(var1_1, var6_6 /* !! */ );
                                                continue;
                                            }
                                            catch (Throwable var14_19) {
                                                Debug.printStackTrace(var14_19);
                                            }
                                        }
                                    }
                                    return var10_23;
                                }
                                break block27;
lbl40:
                                // 1 sources

                                var12_12 = null;
                                if (var4_4 != false) return var8_10;
                                if (!var5_5) {
                                    if (var6_6 /* !! */  == null) {
                                        var6_6 /* !! */  = new UpdateException("Verification failed");
                                    }
                                    break block28;
                                } else {
                                    return var8_10;
                                }
                            }
                            ++var9_21;
                            ** GOTO lbl16
                        }
                        var6_6 /* !! */  = var8_11;
                        throw var8_11;
                    }
                    var13_15 = 0;
                }
            }
            catch (UpdateException var7_8) {
                var6_6 /* !! */  = var7_8;
                throw var7_8;
            }
            catch (Throwable var7_9) {
                var6_6 /* !! */  = var7_9;
                throw new UpdateException("Verification failed", var7_9);
            }
        }
        catch (Throwable var11_24) {
            var12_14 = null;
            if (!var4_4 && !var5_5) {
                if (var6_6 /* !! */  == null) {
                    var6_6 /* !! */  = new UpdateException("Verification failed");
                }
                for (var13_17 = 0; var13_17 < this.verification_listeners.size(); ++var13_17) {
                    ** try [egrp 4[TRYBLOCK] [11 : 226->251)] { 
lbl71:
                    // 1 sources

                    ((UpdateManagerVerificationListener)this.verification_listeners.get(var13_17)).verificationFailed(var1_1, var6_6 /* !! */ );
                    continue;
lbl73:
                    // 1 sources

                    catch (Throwable var14_20) {
                        Debug.printStackTrace(var14_20);
                    }
                }
            }
            throw var11_24;
        }
        while (true) {
            block29: {
                if (var13_15 >= this.verification_listeners.size()) ** continue;
                ** try [egrp 4[TRYBLOCK] [11 : 226->251)] { 
lbl81:
                // 1 sources

                ((UpdateManagerVerificationListener)this.verification_listeners.get(var13_15)).verificationFailed(var1_1, var6_6 /* !! */ );
                break block29;
lbl83:
                // 1 sources

                catch (Throwable var14_18) {
                    Debug.printStackTrace(var14_18);
                }
            }
            ++var13_15;
        }
    }

    public void addVerificationListener(UpdateManagerVerificationListener updateManagerVerificationListener) {
        this.verification_listeners.add(updateManagerVerificationListener);
    }

    public void removeVerificationListener(UpdateManagerVerificationListener updateManagerVerificationListener) {
        this.verification_listeners.add(updateManagerVerificationListener);
    }

    public void addListener(UpdateManagerListener updateManagerListener) {
        this.listeners.add(updateManagerListener);
    }

    public void removeListener(UpdateManagerListener updateManagerListener) {
        this.listeners.remove(updateManagerListener);
    }
}

