/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.utils;

import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownload;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownloadStats;

public class RPShortCuts
extends RPObject
implements ShortCuts {
    protected transient ShortCuts delegate;

    public static RPShortCuts create(ShortCuts shortCuts) {
        RPShortCuts rPShortCuts = (RPShortCuts)RPShortCuts._lookupLocal(shortCuts);
        if (rPShortCuts == null) {
            rPShortCuts = new RPShortCuts(shortCuts);
        }
        return rPShortCuts;
    }

    protected RPShortCuts(ShortCuts shortCuts) {
        super(shortCuts);
    }

    protected void _setDelegate(Object object) {
        this.delegate = (ShortCuts)object;
    }

    public Object _setLocal() throws RPException {
        Object object = this._fixupLocal();
        return object;
    }

    public void _setRemote(RPRequestDispatcher rPRequestDispatcher) {
        super._setRemote(rPRequestDispatcher);
    }

    public RPReply _process(RPRequest rPRequest) {
        String string = rPRequest.getMethod();
        Object[] objectArray = rPRequest.getParams();
        if (string.equals("getDownload[byte[]]")) {
            try {
                return new RPReply(RPDownload.create(this.delegate.getDownload((byte[])objectArray[0])));
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
        }
        if (string.equals("getDownloadStats[byte[]]")) {
            try {
                return new RPReply(RPDownloadStats.create(this.delegate.getDownloadStats((byte[])objectArray[0])));
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
        }
        if (string.equals("restartDownload[byte[]]")) {
            try {
                this.delegate.restartDownload((byte[])objectArray[0]);
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
            return null;
        }
        if (string.equals("stopDownload[byte[]]")) {
            try {
                this.delegate.stopDownload((byte[])objectArray[0]);
            }
            catch (DownloadException downloadException) {
                return new RPReply(downloadException);
            }
            return null;
        }
        if (string.equals("removeDownload[byte[]]")) {
            try {
                this.delegate.removeDownload((byte[])objectArray[0]);
            }
            catch (Throwable throwable) {
                return new RPReply(throwable);
            }
            return null;
        }
        throw new RPException("Unknown method: " + string);
    }

    public Download getDownload(byte[] byArray) throws DownloadException {
        try {
            RPDownload rPDownload = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "getDownload[byte[]]", new Object[]{byArray})).getResponse();
            rPDownload._setRemote(this._dispatcher);
            return rPDownload;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    public DownloadStats getDownloadStats(byte[] byArray) throws DownloadException {
        try {
            RPDownloadStats rPDownloadStats = (RPDownloadStats)this._dispatcher.dispatch(new RPRequest(this, "getDownloadStats[byte[]]", new Object[]{byArray})).getResponse();
            rPDownloadStats._setRemote(this._dispatcher);
            return rPDownloadStats;
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    public void restartDownload(byte[] byArray) throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "restartDownload[byte[]]", new Object[]{byArray})).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    public void stopDownload(byte[] byArray) throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "stopDownload[byte[]]", new Object[]{byArray})).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }

    public void removeDownload(byte[] byArray) throws DownloadException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "removeDownload[byte[]]", new Object[]{byArray})).getResponse();
        }
        catch (RPException rPException) {
            if (rPException.getCause() instanceof DownloadException) {
                throw (DownloadException)rPException.getCause();
            }
            throw rPException;
        }
    }
}

