/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.PluginUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderFactory;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpdatePlugin
implements Plugin {
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.update";
    private static final String PLUGIN_RESOURCE_ID = "ConfigView.section.plugins.update";
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    private PluginInterface plugin_interface;
    private LoggerChannel log;
    private boolean loader_listener_added;
    private String last_id_info = "";

    @Override
    public void initialize(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Plugin Updater");
        this.log = this.plugin_interface.getLogger().getChannel("Plugin Update");
        UIManager uIManager = this.plugin_interface.getUIManager();
        final BasicPluginViewModel basicPluginViewModel = uIManager.createBasicPluginViewModel(PLUGIN_RESOURCE_ID);
        final PluginConfig pluginConfig = this.plugin_interface.getPluginconfig();
        boolean bl = pluginConfig.getPluginBooleanParameter("enable.update", true);
        basicPluginViewModel.setConfigSectionID(PLUGIN_CONFIGSECTION_ID);
        basicPluginViewModel.getStatus().setText(bl ? "Running" : "Optional checks disabled");
        basicPluginViewModel.getActivity().setVisible(false);
        basicPluginViewModel.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int n, String string) {
                basicPluginViewModel.getLogArea().appendText(string + "\n");
            }

            public void messageLogged(String string, Throwable throwable) {
                basicPluginViewModel.getLogArea().appendText(throwable.toString() + "\n");
            }
        });
        BasicPluginConfigModel basicPluginConfigModel = uIManager.createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        basicPluginConfigModel.addBooleanParameter2("enable.update", "Plugin.pluginupdate.enablecheck", true);
        this.plugin_interface.addEventListener(new PluginEventListener(){

            public void handleEvent(PluginEvent pluginEvent) {
                if (pluginEvent.getType() == 7) {
                    PluginUpdatePlugin.this.plugin_interface.removeEventListener(this);
                    PluginUpdatePlugin.this.initComplete(pluginConfig);
                }
            }
        });
    }

    protected void initComplete(final PluginConfig pluginConfig) {
        int n;
        UpdateManager updateManager = this.plugin_interface.getUpdateManager();
        updateManager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance updateCheckInstance) {
                SFPluginDetailsLoaderFactory.getSingleton().reset();
            }
        });
        final PluginManager pluginManager = this.plugin_interface.getPluginManager();
        PluginInterface[] pluginInterfaceArray = pluginManager.getPlugins();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < pluginInterfaceArray.length; ++n) {
            PluginInterface pluginInterface = pluginInterfaceArray[n];
            boolean bl = pluginInterface.getPluginState().isMandatory();
            if (bl) {
                ++n2;
                continue;
            }
            ++n3;
        }
        n = n3;
        final int n4 = n2;
        updateManager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Non-mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return n * 30;
            }

            public void checkForUpdate(UpdateChecker updateChecker) {
                if (PluginUpdatePlugin.this.checkForUpdateSupport(updateChecker, null, false) == 0) {
                    Object object;
                    VersionCheckClient versionCheckClient = VersionCheckClient.getSingleton();
                    String[] stringArray = versionCheckClient.getRecommendedPlugins();
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        object = stringArray[i];
                        if (pluginManager.getPluginInterfaceByID((String)object, false) != null) continue;
                        final String string = "recommended.processed." + (String)object;
                        if (!pluginConfig.getPluginBooleanParameter(string, false)) {
                            try {
                                final PluginInstaller throwable = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                StandardPlugin[] standardPluginArray = throwable.getStandardPlugins();
                                for (int j = 0; j < standardPluginArray.length; ++j) {
                                    final StandardPlugin standardPlugin = standardPluginArray[j];
                                    if (!standardPlugin.getId().equals(object)) continue;
                                    bl = true;
                                    updateChecker.getCheckInstance().addListener(new UpdateCheckInstanceListener(){

                                        public void cancelled(UpdateCheckInstance updateCheckInstance) {
                                        }

                                        public void complete(UpdateCheckInstance updateCheckInstance) {
                                            if (updateCheckInstance.getUpdates().length == 0) {
                                                PluginUpdatePlugin.this.installRecommendedPlugin(throwable, standardPlugin);
                                                pluginConfig.setPluginParameter(string, true);
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (bl) break;
                    }
                    if (!bl) {
                        Set<String> set = versionCheckClient.getAutoInstallPluginIDs();
                        object = new ArrayList();
                        for (String string : set) {
                            if (pluginManager.getPluginInterfaceByID(string, false) != null) continue;
                            object.add(string);
                        }
                        if (object.size() > 0) {
                            new AEThread2("pup:autoinst", (List)object){
                                final /* synthetic */ List val$to_do;
                                {
                                    this.val$to_do = list;
                                    super(string);
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(120000L);
                                    }
                                    catch (Throwable throwable) {
                                        Debug.out(throwable);
                                        return;
                                    }
                                    UpdateManager updateManager = PluginUpdatePlugin.this.plugin_interface.getUpdateManager();
                                    final ArrayList<UpdateCheckInstance> arrayList = new ArrayList<UpdateCheckInstance>();
                                    updateManager.addListener(new UpdateManagerListener(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void checkInstanceCreated(UpdateCheckInstance updateCheckInstance) {
                                            List list = arrayList;
                                            synchronized (list) {
                                                arrayList.add(updateCheckInstance);
                                            }
                                        }
                                    });
                                    UpdateCheckInstance[] updateCheckInstanceArray = updateManager.getCheckInstances();
                                    arrayList.addAll(Arrays.asList(updateCheckInstanceArray));
                                    long l = SystemTime.getMonotonousTime();
                                    while (SystemTime.getMonotonousTime() - l < 300000L) {
                                        try {
                                            Thread.sleep(5000L);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.out(throwable);
                                            return;
                                        }
                                        if (arrayList.size() <= 0) continue;
                                        boolean bl = true;
                                        for (UpdateCheckInstance object : arrayList) {
                                            if (object.isCompleteOrCancelled()) continue;
                                            bl = false;
                                            break;
                                        }
                                        if (!bl) continue;
                                        break;
                                    }
                                    if (updateManager.getInstallers().length > 0) {
                                        return;
                                    }
                                    PluginInstaller pluginInstaller = PluginUpdatePlugin.this.plugin_interface.getPluginManager().getPluginInstaller();
                                    ArrayList arrayList2 = new ArrayList();
                                    for (String string : this.val$to_do) {
                                        try {
                                            StandardPlugin standardPlugin = pluginInstaller.getStandardPlugin(string);
                                            if (standardPlugin != null) {
                                                PluginUpdatePlugin.this.log.log("Auto-installing " + string);
                                                arrayList2.add(standardPlugin);
                                                continue;
                                            }
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + string + "' missing");
                                        }
                                        catch (Throwable throwable) {
                                            PluginUpdatePlugin.this.log.log("Standard plugin '" + string + "' missing", throwable);
                                        }
                                    }
                                    if (arrayList2.size() > 0) {
                                        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                                        hashMap.put(1, 3);
                                        hashMap.put(3, true);
                                        try {
                                            pluginInstaller.install(arrayList2.toArray(new InstallablePlugin[arrayList2.size()]), false, hashMap, new PluginInstallationListener(){

                                                public void completed() {
                                                }

                                                public void cancelled() {
                                                }

                                                public void failed(PluginException pluginException) {
                                                }
                                            });
                                        }
                                        catch (Throwable throwable) {
                                            PluginUpdatePlugin.this.log.log("Auto install failed", throwable);
                                        }
                                    }
                                }
                            }.start();
                        }
                    }
                }
            }
        }, false);
        updateManager.registerUpdatableComponent(new UpdatableComponent(){

            public String getName() {
                return "Mandatory plugins";
            }

            public int getMaximumCheckTime() {
                return n4 * 30;
            }

            public void checkForUpdate(UpdateChecker updateChecker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(updateChecker, null, true);
            }
        }, true);
        updateManager.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance updateCheckInstance) {
                PluginUpdatePlugin.this.log.log(1, "**** Update check starts ****");
            }
        });
    }

    protected void installRecommendedPlugin(PluginInstaller pluginInstaller, StandardPlugin standardPlugin) {
        try {
            pluginInstaller.requestInstall(MessageText.getString("plugin.installer.recommended.plugin"), standardPlugin);
        }
        catch (Throwable throwable) {
            this.log.log(throwable);
        }
    }

    public UpdatableComponent getCustomUpdateableComponent(final String string, final boolean bl) {
        return new UpdatableComponent(){

            public String getName() {
                return "Installation of '" + string + "'";
            }

            public int getMaximumCheckTime() {
                return 30;
            }

            public void checkForUpdate(UpdateChecker updateChecker) {
                PluginUpdatePlugin.this.checkForUpdateSupport(updateChecker, new String[]{string}, bl);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int checkForUpdateSupport(UpdateChecker updateChecker, String[] stringArray, boolean n) {
        int n2;
        block28: {
            n2 = 0;
            if (n != 0 || stringArray != null || this.plugin_interface.getPluginconfig().getPluginBooleanParameter("enable.update", true)) break block28;
            int n3 = n2;
            Object var40_8 = null;
            updateChecker.completed();
            return n3;
        }
        try {
            try {
                Object object;
                Object object2;
                int n4;
                String string;
                String[] stringArray2;
                PluginInterface[] pluginInterfaceArray = this.plugin_interface.getPluginManager().getPlugins();
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                HashMap<Object, String> hashMap = new HashMap<Object, String>();
                for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                    stringArray2 = pluginInterfaceArray[i];
                    if (stringArray2.getPluginState().isDisabled() && !stringArray2.getPluginState().hasFailed()) continue;
                    string = stringArray2.getPluginProperties().getProperty("plugin.mandatory");
                    int n5 = n4 = string != null && string.trim().toLowerCase().equals("true") ? 1 : 0;
                    if (n4 != n) continue;
                    object2 = stringArray2.getPluginID();
                    object = stringArray2.getPluginVersion();
                    String string2 = stringArray2.getPluginName();
                    if (stringArray != null) {
                        boolean bl = false;
                        for (int j = 0; j < stringArray.length; ++j) {
                            if (!stringArray[j].equals(object2)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) continue;
                    }
                    if (object != null) {
                        if (arrayList2.contains(object2)) {
                            String string3 = (String)hashMap.get(object2);
                            if (!string2.equals(object2)) {
                                hashMap.put(object2, string3 + "," + string2);
                            }
                        } else {
                            arrayList2.add(object2);
                            arrayList.add(stringArray2);
                            hashMap.put(object2, string2.equals(object2) ? "" : string2);
                        }
                    }
                    String string4 = stringArray2.getPluginDirectoryName();
                    this.log.log(1, (n != 0 ? "*" : "-") + stringArray2.getPluginName() + ", id = " + (String)object2 + (object == null ? "" : ", version = " + stringArray2.getPluginVersion()) + (string4 == null ? "" : ", loc = " + string4));
                }
                SFPluginDetailsLoader sFPluginDetailsLoader = SFPluginDetailsLoaderFactory.getSingleton();
                if (!this.loader_listener_added) {
                    this.loader_listener_added = true;
                    sFPluginDetailsLoader.addListener(new SFPluginDetailsLoaderListener(){

                        public void log(String string) {
                            PluginUpdatePlugin.this.log.log(1, "[" + string + "]");
                        }
                    });
                }
                stringArray2 = sFPluginDetailsLoader.getPluginIDs();
                string = "";
                for (n4 = 0; n4 < stringArray2.length; ++n4) {
                    object2 = stringArray2[n4];
                    object = sFPluginDetailsLoader.getPluginDetails((String)object2);
                    string = string + (n4 == 0 ? "" : ",") + stringArray2[n4] + "=" + object.getVersion() + "/" + object.getCVSVersion();
                }
                if (!string.equals(this.last_id_info)) {
                    this.last_id_info = string;
                    this.log.log(1, "Downloaded plugin info = " + string);
                }
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    if (updateChecker.getCheckInstance().isCancelled()) {
                        throw new Exception("Update check cancelled");
                    }
                    object2 = (PluginInterface)arrayList.get(n4);
                    object = object2.getPluginID();
                    boolean bl = false;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (!stringArray2[i].equalsIgnoreCase((String)object)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        if (object2.getPluginState().isBuiltIn()) continue;
                        this.log.log(1, "Skipping " + (String)object + " as not listed on web site");
                        continue;
                    }
                    String string5 = (String)hashMap.get(object);
                    this.log.log(1, "Checking " + (String)object);
                    try {
                        Object object3;
                        String string6;
                        String string7;
                        updateChecker.reportProgress("Loading details for " + (String)object + "/" + object2.getPluginName());
                        SFPluginDetails sFPluginDetails = sFPluginDetailsLoader.getPluginDetails((String)object);
                        if (string5.length() == 0) {
                            string5 = sFPluginDetails.getName();
                        }
                        boolean bl2 = this.plugin_interface.getUtilities().isCVSVersion();
                        String string8 = object2.getPluginProperties().getProperty("plugin.version.info");
                        String string9 = object2.getPluginVersion();
                        String string10 = string7 = sFPluginDetails.getVersion();
                        if (bl2 && (string6 = sFPluginDetails.getCVSVersion()).length() > 0) {
                            string7 = string6;
                            string10 = string7.substring(0, string7.length() - 4);
                        }
                        if (string10.length() == 0 || !Character.isDigit(string10.charAt(0))) {
                            this.log.log(1, "Skipping " + (String)object + " as no valid version to check");
                            continue;
                        }
                        int n6 = PluginUtils.comparePluginVersions(string9, string10);
                        this.log.log(1, "    Current: " + string9 + (n6 == 0 && string7.endsWith("_CVS") ? "_CVS" : "") + ", Latest: " + string7 + (string8 == null ? "" : " [" + string8 + "]"));
                        updateChecker.reportProgress("    current=" + string9 + (n6 == 0 && string7.endsWith("_CVS") ? "_CVS" : "") + ", latest=" + string7);
                        if (n6 >= 0 || object2.getPlugin() instanceof UpdatableComponent) continue;
                        String string11 = sFPluginDetails.getDownloadURL();
                        if (bl2 && ((String)(object3 = sFPluginDetails.getCVSVersion())).length() > 0) {
                            string11 = sFPluginDetails.getCVSDownloadURL();
                        }
                        this.log.log(1, "    Description:");
                        object3 = new ArrayList();
                        List list = HTMLUtils.convertHTMLToText("", sFPluginDetails.getDescription());
                        this.logMultiLine("        ", list);
                        object3.addAll(list);
                        this.log.log(1, "    Comment:");
                        List list2 = HTMLUtils.convertHTMLToText("    ", sFPluginDetails.getComment());
                        this.logMultiLine("    ", list2);
                        object3.addAll(list2);
                        String string12 = "A newer version (version " + string7 + ") of plugin '" + (String)object + "' " + (string5.length() == 0 ? "" : "(" + string5 + ") ") + "is available. ";
                        this.log.log(1, "");
                        this.log.log(1, "        " + string12 + "Download from " + string11);
                        ResourceDownloaderFactory resourceDownloaderFactory = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
                        ResourceDownloader resourceDownloader = resourceDownloaderFactory.create(new URL(string11));
                        String string13 = "http://torrent.vuze.com/torrents/";
                        int n7 = string11.lastIndexOf("/");
                        string13 = n7 == -1 ? string13 + string11 : string13 + string11.substring(n7 + 1);
                        string13 = string13 + ".torrent";
                        ResourceDownloader resourceDownloader2 = resourceDownloaderFactory.create(new URL(string13));
                        resourceDownloader2 = resourceDownloaderFactory.getSuffixBasedDownloader(resourceDownloader2);
                        ResourceDownloader resourceDownloader3 = resourceDownloaderFactory.getAlternateDownloader(new ResourceDownloader[]{resourceDownloader2, resourceDownloader});
                        resourceDownloaderFactory.getTimeoutDownloader(resourceDownloaderFactory.getRetryDownloader(resourceDownloader3, 3), 10000).getSize();
                        String[] stringArray3 = new String[object3.size()];
                        object3.toArray(stringArray3);
                        ++n2;
                        boolean bl3 = true;
                        for (int i = 0; i < pluginInterfaceArray.length; ++i) {
                            PluginInterface pluginInterface = pluginInterfaceArray[i];
                            if (!pluginInterface.getPluginID().equals(object)) continue;
                            bl3 &= pluginInterface.getPluginState().isUnloadable();
                        }
                        if (bl3) {
                            updateChecker.reportProgress("Plugin is unloadable");
                        }
                        Update update = this.addUpdate((PluginInterface)object2, updateChecker, (String)object + "/" + string5, stringArray3, string7, resourceDownloader3, string11.toLowerCase().endsWith(".jar"), bl3 ? 1 : 2, true);
                        update.setRelativeURLBase(sFPluginDetails.getRelativeURLBase());
                        update.setDescriptionURL(sFPluginDetails.getInfoURL());
                        continue;
                    }
                    catch (Throwable throwable) {
                        updateChecker.reportProgress("Failed to load details for plugin '" + (String)object + "': " + Debug.getNestedExceptionMessage(throwable));
                        this.log.log("    Plugin check failed", throwable);
                    }
                }
                Object var40_9 = null;
                updateChecker.completed();
            }
            catch (Throwable throwable) {
                if (!"Update check cancelled".equals(throwable.getMessage())) {
                    this.log.log("Failed to load plugin details", throwable);
                }
                updateChecker.reportProgress("Failed to load plugin details: " + Debug.getNestedExceptionMessage(throwable));
                updateChecker.failed();
                Object var40_10 = null;
                updateChecker.completed();
            }
        }
        catch (Throwable throwable) {
            Object var40_11 = null;
            updateChecker.completed();
            throw throwable;
        }
        return n2;
    }

    public Update addUpdate(final PluginInterface pluginInterface, final UpdateChecker updateChecker, String string, String[] stringArray, final String string2, ResourceDownloader resourceDownloader, final boolean bl, final int n, final boolean bl2) {
        final Update update = updateChecker.addUpdate(string, stringArray, string2, resourceDownloader, n);
        update.setUserObject(pluginInterface);
        resourceDownloader.addListener(new ResourceDownloaderAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean completed(final ResourceDownloader resourceDownloader, InputStream inputStream) {
                LoggerChannelListener loggerChannelListener = new LoggerChannelListener(){

                    public void messageLogged(int n, String string) {
                        resourceDownloader.reportActivity(string);
                    }

                    public void messageLogged(String string, Throwable throwable) {
                        resourceDownloader.reportActivity(string);
                    }
                };
                try {
                    PluginUpdatePlugin.this.log.addListener(loggerChannelListener);
                    PluginUpdatePlugin.this.installUpdate(updateChecker, update, pluginInterface, n == 1, bl, string2, inputStream, bl2);
                    boolean bl3 = true;
                    Object var6_5 = null;
                    PluginUpdatePlugin.this.log.removeListener(loggerChannelListener);
                    return bl3;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    PluginUpdatePlugin.this.log.removeListener(loggerChannelListener);
                    throw throwable;
                }
            }

            public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
                Debug.out(resourceDownloader.getName() + " failed", resourceDownloaderException);
                update.complete(false);
            }
        });
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void installUpdate(UpdateChecker updateChecker, Update update, PluginInterface pluginInterface, boolean bl, boolean bl2, String string, InputStream inputStream, boolean bl3) {
        this.log.log(1, "Installing plugin '" + update.getName() + "', version " + string);
        String string2 = string.endsWith("_CVS") ? string.substring(0, string.length() - 4) : string;
        UpdateInstaller updateInstaller = null;
        boolean bl4 = false;
        try {
            try {
                Object object;
                Comparable<File> comparable;
                inputStream = update.verifyData(inputStream, bl3);
                this.log.log("    Data verification stage complete");
                boolean bl5 = false;
                String string3 = pluginInterface.getPluginDirectoryName();
                if (string3 == null || string3.length() == 0) {
                    this.log.log(1, "    This is a built-in plugin, updating core");
                    update.setRestartRequired(2);
                } else {
                    Object object2;
                    Object object3;
                    Object object4;
                    File file;
                    File file2;
                    Object object5;
                    File file3;
                    comparable = new File(string3);
                    object = new File(this.plugin_interface.getUtilities().getAzureusUserDir());
                    File file4 = new File(this.plugin_interface.getUtilities().getAzureusProgramDir());
                    HashMap<String, List<String[]>> hashMap = new HashMap<String, List<String[]>>();
                    boolean bl6 = false;
                    if (Constants.isWindowsVistaOrHigher) {
                        file3 = new File((File)comparable, "_aztest45.dll");
                        boolean bl7 = false;
                        try {
                            if (file3.exists()) {
                                file3.delete();
                            }
                            object5 = new FileOutputStream(file3);
                            ((FileOutputStream)object5).write(32);
                            ((FileOutputStream)object5).close();
                            bl7 = file3.delete();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!bl7) {
                            this.log.log("Can't write directly to the plugin directroy, installing indirectly");
                            bl6 = true;
                        }
                    }
                    if (bl6) {
                        file2 = AETemporaryFileHandler.createTempDir();
                        file3 = new File(file2, "plugin");
                        object5 = new File(file2, "user");
                        file = new File(file2, "prog");
                        file3.mkdirs();
                        ((File)object5).mkdirs();
                        file.mkdirs();
                        updateInstaller = update.getCheckInstance().createInstaller();
                        update.setRestartRequired(2);
                    } else {
                        file3 = comparable;
                        object5 = object;
                        file = file4;
                    }
                    file2 = new File(file3, pluginInterface.getPluginID() + "_" + string2 + (bl2 ? ".jar" : ".zip"));
                    FileUtil.copyFile(inputStream, new FileOutputStream(file2));
                    if (!bl2) {
                        Object object6;
                        Object object7;
                        Object object8;
                        Object object9;
                        object4 = new ZipInputStream(new BufferedInputStream(new FileInputStream(file2)));
                        object3 = null;
                        Object object10 = null;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        try {
                            block28: while (true) {
                                int n;
                                if ((object2 = ((ZipInputStream)object4).getNextEntry()) == null) break;
                                object9 = object2.getName();
                                if (((String)object9).equals("plugin_install.properties")) {
                                    object8 = new ByteArrayOutputStream(32768);
                                    byte[] byArray = new byte[65536];
                                    while (true) {
                                        int n2;
                                        if ((n2 = ((FilterInputStream)object4).read(byArray)) <= 0) {
                                            try {
                                                object7 = new LineNumberReader(new InputStreamReader((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)object8).toByteArray()), "UTF-8"));
                                                while (true) {
                                                    if ((object6 = ((LineNumberReader)object7).readLine()) == null) continue block28;
                                                    String[] stringArray = ((String)object6).split(",");
                                                    if (stringArray.length <= 1) continue;
                                                    ArrayList<String[]> arrayList2 = (ArrayList<String[]>)hashMap.get(stringArray[0]);
                                                    if (arrayList2 == null) {
                                                        arrayList2 = new ArrayList<String[]>();
                                                        hashMap.put(stringArray[0], arrayList2);
                                                    }
                                                    arrayList2.add(stringArray);
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Debug.out(throwable);
                                                continue block28;
                                            }
                                        }
                                        ((ByteArrayOutputStream)object8).write(byArray, 0, n2);
                                    }
                                }
                                if (!((String)object9).equals("azureus.sig") && !((String)object9).endsWith("/")) {
                                    if (object3 == null) {
                                        object3 = object9;
                                    } else {
                                        int n3 = 0;
                                        for (n = 0; n < Math.min(((String)object3).length(), ((String)object9).length()) && ((String)object3).charAt(n) == ((String)object9).charAt(n); ++n3, ++n) {
                                        }
                                        object3 = ((String)object3).substring(0, n3);
                                    }
                                    int n4 = ((String)object9).indexOf("platform/");
                                    if (n4 != -1 && (n = ((String)object9).indexOf("/", n4 += 9)) != -1) {
                                        object7 = ((String)object9).substring(n4, n);
                                        object6 = null;
                                        int n5 = ((String)object7).indexOf("_");
                                        if (n5 != -1) {
                                            object6 = ((String)object7).substring(n5 + 1);
                                            object7 = ((String)object7).substring(0, n5);
                                        }
                                        if (Constants.isWindows && ((String)object7).equalsIgnoreCase("windows") || Constants.isLinux && ((String)object7).equalsIgnoreCase("linux") || Constants.isUnix && ((String)object7).equalsIgnoreCase("unix") || Constants.isFreeBSD && ((String)object7).equalsIgnoreCase("freebsd") || Constants.isSolaris && ((String)object7).equalsIgnoreCase("solaris") || Constants.isOSX && ((String)object7).equalsIgnoreCase("osx")) {
                                            object10 = object7;
                                            if (object6 != null && !arrayList.contains(object6)) {
                                                arrayList.add((String)object6);
                                            }
                                        }
                                    }
                                }
                                object8 = new byte[65536];
                                while ((n = ((FilterInputStream)object4).read((byte[])object8)) > 0) {
                                }
                            }
                            Object var36_54 = null;
                            ((ZipInputStream)object4).close();
                        }
                        catch (Throwable throwable) {
                            Object var36_55 = null;
                            ((ZipInputStream)object4).close();
                            throw throwable;
                        }
                        if (object10 != null) {
                            object2 = new String[arrayList.size()];
                            arrayList.toArray((T[])object2);
                            if (((String[])object2).length == 1) {
                                object10 = object10 + "_" + object2[0];
                                this.log.log(1, "platform is '" + (String)object10 + "'");
                            } else if (((String[])object2).length > 1) {
                                object9 = (String)update.getDecision(0, "Select Platform", "Multiple platform options exist for this plugin, please select required one", object2);
                                if (object9 == null) {
                                    throw new Exception("Valid sub-platform selection not selected");
                                }
                                object10 = (String)object10 + "_" + (String)object9;
                                this.log.log(1, "platform is '" + (String)object10 + "'");
                            }
                        }
                        if (object3 != null) {
                            int n = ((String)object3).lastIndexOf("/");
                            object3 = n == -1 ? "" : ((String)object3).substring(0, n + 1);
                            object4 = new ZipInputStream(new BufferedInputStream(new FileInputStream(file2)));
                            try {
                                block33: while (true) {
                                    Object var52_84;
                                    Object object11;
                                    Object object12;
                                    Object object13;
                                    Object object14;
                                    HashMap<Object, Object> hashMap2;
                                    Object object15;
                                    boolean bl8;
                                    Object object16;
                                    block115: {
                                        if ((object9 = ((ZipInputStream)object4).getNextEntry()) == null) {
                                            Object var54_87 = null;
                                            break;
                                        }
                                        object8 = ((ZipEntry)object9).getName();
                                        OutputStream outputStream = null;
                                        object7 = null;
                                        object6 = null;
                                        object16 = null;
                                        bl8 = false;
                                        try {
                                            if (((String)object8).length() >= ((String)object3).length() && !((String)object8).equals("azureus.sig") && !((String)object8).endsWith("/")) {
                                                boolean bl9 = false;
                                                String string4 = ((ZipEntry)object9).getName().substring(((String)object3).length());
                                                if (object10 != null && string4.indexOf("platform/") != -1) {
                                                    object15 = "platform/" + (String)object10;
                                                    int n6 = string4.indexOf((String)object15);
                                                    if (n6 != -1) {
                                                        string4 = string4.substring(0, n6) + string4.substring(n6 + ((String)object15).length() + 1);
                                                    } else {
                                                        bl9 = true;
                                                    }
                                                }
                                                if (string4.startsWith("shared/lib")) {
                                                    update.setRestartRequired(2);
                                                    bl = false;
                                                    if (pluginInterface.getPluginState().isShared()) {
                                                        hashMap2 = file4;
                                                        object15 = file;
                                                    } else {
                                                        hashMap2 = object;
                                                        object15 = object5;
                                                    }
                                                } else {
                                                    hashMap2 = comparable;
                                                    object15 = file3;
                                                }
                                                object7 = new File((File)((Object)hashMap2), string4);
                                                object16 = object6 = new File((File)object15, string4);
                                                if (((File)object7).exists()) {
                                                    if (string4.indexOf(47) == -1 && (string4.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".properties") || string4.toLowerCase(MessageText.LOCALE_ENGLISH).endsWith(".config"))) {
                                                        bl8 = string4.toLowerCase(MessageText.LOCALE_ENGLISH).equals("plugin.properties");
                                                        object14 = string4;
                                                        string4 = string4 + "_" + string2;
                                                        object16 = new File((File)object15, string4);
                                                        this.log.log(1, "saving new file '" + (String)object14 + "'as '" + string4 + "'");
                                                    } else if (this.isVersioned(string4)) {
                                                        this.log.log(1, "Version '" + string4 + "' already present, skipping");
                                                        bl9 = true;
                                                    } else {
                                                        this.log.log(1, "overwriting '" + string4 + "'");
                                                        object14 = new File(((File)object7).getParentFile(), ((File)object7).getName() + ".bak");
                                                        if (bl6) {
                                                            if (((File)object14).exists()) {
                                                                updateInstaller.addRemoveAction(((File)object14).getAbsolutePath());
                                                            }
                                                            updateInstaller.addMoveAction(((File)object7).getAbsolutePath(), ((File)object14).getAbsolutePath());
                                                        } else {
                                                            if (((File)object14).exists()) {
                                                                ((File)object14).delete();
                                                            }
                                                            if (!((File)object6).renameTo((File)object14)) {
                                                                this.log.log(1, "    failed to backup '" + string4 + "', deferring until restart");
                                                                if (updateInstaller == null) {
                                                                    update.setRestartRequired(2);
                                                                    updateInstaller = update.getCheckInstance().createInstaller();
                                                                }
                                                                object13 = new File(((File)object6).getParentFile(), ((File)object6).getName() + ".tmp");
                                                                ((File)object13).delete();
                                                                updateInstaller.addMoveAction(((File)object13).getAbsolutePath(), ((File)object6).getAbsolutePath());
                                                                object16 = object13;
                                                            }
                                                        }
                                                    }
                                                }
                                                if (!bl9) {
                                                    FileUtil.mkdirs(((File)object16).getParentFile());
                                                    outputStream = new FileOutputStream((File)object16);
                                                }
                                            }
                                            object12 = new byte[65536];
                                            while (true) {
                                                int n7;
                                                if ((n7 = ((FilterInputStream)object4).read((byte[])object12)) <= 0) {
                                                    object11 = null;
                                                    if (outputStream == null) break block115;
                                                    break;
                                                }
                                                if (outputStream == null) continue;
                                                outputStream.write((byte[])object12, 0, n7);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            object11 = null;
                                            if (outputStream == null) throw throwable;
                                            outputStream.close();
                                            throw throwable;
                                        }
                                        outputStream.close();
                                    }
                                    if (bl8) {
                                        Object var50_83;
                                        Object object17;
                                        Object object18;
                                        object12 = new Properties();
                                        Properties properties = new Properties();
                                        object15 = new ArrayList();
                                        hashMap2 = new HashMap<Object, Object>();
                                        object14 = new HashMap();
                                        try {
                                            object13 = new FileInputStream((File)object7);
                                            ((Properties)object12).load((InputStream)object13);
                                            try {
                                                ((FileInputStream)object13).close();
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            object13 = new FileInputStream((File)object16);
                                            properties.load((InputStream)object13);
                                            try {
                                                ((FileInputStream)object13).close();
                                            }
                                            catch (Throwable throwable) {}
                                        }
                                        catch (Throwable throwable) {
                                            Debug.printStackTrace(throwable);
                                        }
                                        properties.put("plugin.version", string2);
                                        object13 = new String[]{"plugin.name", "plugin.names", "plugin.class", "plugin.classes", "plugin.version", "plugin.langfile"};
                                        for (int i = 0; i < ((String[])object13).length; ++i) {
                                            object11 = object13[i];
                                            object18 = ((Properties)object12).getProperty((String)object11);
                                            object17 = properties.getProperty((String)object11);
                                            if (object17 == null) continue;
                                            if (((String)object11).equals("plugin.name")) {
                                                object15.add("plugin.names");
                                            } else if (((String)object11).equals("plugin.names")) {
                                                object15.add("plugin.name");
                                            } else if (((String)object11).equals("plugin.class")) {
                                                object15.add("plugin.classes");
                                            } else if (((String)object11).equals("plugin.classes")) {
                                                object15.add("plugin.class");
                                            }
                                            if (object18 == null) {
                                                object14.put(object11, object17);
                                                continue;
                                            }
                                            if (((String)object17).equals(object18)) continue;
                                            hashMap2.put(object11, object17);
                                        }
                                        Object object19 = bl6 ? object6 : new File(((File)object6).getParentFile(), ((File)object6).getName() + ".tmp");
                                        object11 = null;
                                        object18 = null;
                                        try {
                                            object11 = new LineNumberReader(new FileReader((File)object7));
                                            object18 = new PrintWriter(new FileWriter((File)object19));
                                            for (String string5 : object14.keySet()) {
                                                String string6 = (String)object14.get(string5);
                                                this.log.log("    Inserting property:" + string5 + "=" + string6);
                                                ((PrintWriter)object18).println(string5 + "=" + string6);
                                            }
                                            while (true) {
                                                String string5;
                                                if ((string5 = ((LineNumberReader)object11).readLine()) == null) {
                                                    var50_83 = null;
                                                    break;
                                                }
                                                int n8 = string5.indexOf(61);
                                                if (n8 != -1) {
                                                    String string7 = string5.substring(0, n8).trim();
                                                    if (object15.contains(string7)) {
                                                        this.log.log("    Deleting property:" + string7);
                                                        continue;
                                                    }
                                                    String string8 = (String)hashMap2.get(string7);
                                                    if (string8 != null) {
                                                        this.log.log("    Replacing property:" + string7 + " with " + string8);
                                                        ((PrintWriter)object18).println(string7 + "=" + string8);
                                                        continue;
                                                    }
                                                    ((PrintWriter)object18).println(string5);
                                                    continue;
                                                }
                                                ((PrintWriter)object18).println(string5);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            var50_83 = null;
                                            ((BufferedReader)object11).close();
                                            if (object18 == null) throw throwable;
                                            ((PrintWriter)object18).close();
                                            throw throwable;
                                        }
                                        ((BufferedReader)object11).close();
                                        if (object18 != null) {
                                            ((PrintWriter)object18).close();
                                        }
                                        object17 = new File(((File)object7).getParentFile(), ((File)object7).getName() + ".bak");
                                        if (bl6) {
                                            if (((File)object17).exists()) {
                                                updateInstaller.addRemoveAction(((File)object17).getAbsolutePath());
                                            }
                                            updateInstaller.addMoveAction(((File)object7).getAbsolutePath(), ((File)object17).getAbsolutePath());
                                            continue;
                                        }
                                        if (((File)object17).exists()) {
                                            ((File)object17).delete();
                                        }
                                        if (!((File)object6).renameTo((File)object17)) {
                                            throw new IOException("Failed to rename '" + ((File)object6).toString() + "' to '" + ((File)object17).toString() + "'");
                                        }
                                        if (!((File)object19).renameTo((File)object6)) {
                                            ((File)object17).renameTo((File)object6);
                                            throw new IOException("Failed to rename '" + ((File)object19).toString() + "' to '" + ((File)object6).toString() + "'");
                                        }
                                        ((File)object17).delete();
                                        continue;
                                    }
                                    if (object16 == null || !((File)object16).getName().equalsIgnoreCase("update.txt")) continue;
                                    bl5 = true;
                                    object12 = null;
                                    try {
                                        try {
                                            object12 = new LineNumberReader(new FileReader((File)object16));
                                            while (true) {
                                                String string9;
                                                if ((string9 = ((LineNumberReader)object12).readLine()) == null) {
                                                    var52_84 = null;
                                                    if (object12 == null) continue block33;
                                                    break;
                                                }
                                                this.log.log(1, string9);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Debug.printStackTrace(throwable);
                                            var52_84 = null;
                                            if (object12 == null) continue;
                                            ((BufferedReader)object12).close();
                                            continue;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var52_84 = null;
                                        if (object12 == null) throw throwable;
                                        ((BufferedReader)object12).close();
                                        throw throwable;
                                    }
                                    ((BufferedReader)object12).close();
                                }
                            }
                            catch (Throwable throwable) {
                                Object var54_88 = null;
                                ((ZipInputStream)object4).close();
                                throw throwable;
                            }
                            ((ZipInputStream)object4).close();
                        }
                    }
                    if (bl) {
                        object4 = pluginInterface.getPluginID();
                        object3 = pluginInterface.getPluginManager().getPlugins();
                        boolean bl10 = true;
                        for (int i = 0; i < ((PluginInterface[])object3).length; ++i) {
                            object2 = object3[i];
                            if (!object2.getPluginID().equals(object4)) continue;
                            bl10 &= object2.getPluginState().isUnloadable();
                        }
                        if (!bl10) {
                            this.log.log("Switching unloadability for " + (String)object4 + " as changed during update");
                            update.setRestartRequired(2);
                            bl = false;
                        }
                    }
                    if (bl6) {
                        this.addInstallationActions(updateInstaller, (Map<String, List<String[]>>)hashMap, "%plugin%", file3, (File)comparable);
                        this.addInstallationActions(updateInstaller, hashMap, "%app%", file, file4);
                        this.addInstallationActions(updateInstaller, hashMap, "%user%", (File)object5, (File)object);
                    } else {
                        this.applyInstallProperties((Map<String, List<String[]>>)hashMap, "%plugin%", (File)comparable);
                        this.applyInstallProperties(hashMap, "%app%", file4);
                        this.applyInstallProperties(hashMap, "%user%", (File)object);
                        if (bl) {
                            this.log.log("Plugin initialising, please wait... ");
                            pluginInterface.getPluginState().reload();
                            this.log.log("... initialisation complete.");
                        }
                    }
                }
                comparable = (Boolean)update.getCheckInstance().getProperty(3);
                if (bl5 || comparable == null || !((Boolean)comparable).booleanValue()) {
                    object = "Version " + string + " of plugin '" + update.getName() + "' " + "installed successfully";
                    if (bl5) {
                        object = (String)object + " - See update log for details";
                    }
                    this.log.logAlertRepeatable(bl5 ? 2 : 1, (String)object);
                }
                try {
                    object = pluginInterface.getPluginID();
                    PluginInitializer.fireEvent(updateChecker.getCheckInstance().getType() == 1 ? 10 : 11, object);
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
                bl4 = true;
            }
            catch (Throwable throwable) {
                String string10 = "Version " + string + " of plugin '" + update.getName() + "' " + "failed to install - " + throwable.getMessage();
                this.log.logAlertRepeatable(3, string10);
                Object var56_91 = null;
                update.complete(bl4);
                return;
            }
            Object var56_90 = null;
            update.complete(bl4);
            return;
        }
        catch (Throwable throwable) {
            Object var56_92 = null;
            update.complete(bl4);
            throw throwable;
        }
    }

    protected void addInstallationActions(UpdateInstaller updateInstaller, Map<String, List<String[]>> map, String string, File file, File file2) throws UpdateException {
        block5: {
            block4: {
                if (!file.isDirectory()) break block4;
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block5;
                for (int i = 0; i < fileArray.length; ++i) {
                    this.addInstallationActions(updateInstaller, map, string + "/" + fileArray[i].getName(), fileArray[i], new File(file2, fileArray[i].getName()));
                }
                break block5;
            }
            updateInstaller.addMoveAction(file.getAbsolutePath(), file2.getAbsolutePath());
            List<String[]> list = map.get(string);
            if (list != null) {
                for (String[] stringArray : list) {
                    String string2 = stringArray[1];
                    if (string2.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.log.log("Applying " + string2 + " " + stringArray[2] + " to " + file2);
                        updateInstaller.addChangeRightsAction(stringArray[2], file2.getAbsolutePath());
                        continue;
                    }
                    if (!string2.equals("rm")) continue;
                    this.log.log("Deleting " + file2);
                    updateInstaller.addRemoveAction(file2.getAbsolutePath());
                }
            }
        }
    }

    protected void applyInstallProperties(Map<String, List<String[]>> map, String string, File file) {
        block6: {
            block5: {
                if (!file.isDirectory()) break block5;
                File[] fileArray = file.listFiles();
                if (fileArray == null) break block6;
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    String string2 = file2.getName();
                    if (string2.equals(".") || string2.equals("..")) continue;
                    String string3 = string + "/" + string2;
                    boolean bl = false;
                    for (String string4 : map.keySet()) {
                        if (!string4.startsWith(string3)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    this.applyInstallProperties(map, string3, fileArray[i]);
                }
                break block6;
            }
            List<String[]> list = map.get(string);
            if (list != null) {
                for (String[] stringArray : list) {
                    String string5 = stringArray[1];
                    if (string5.equals("chmod")) {
                        if (Constants.isWindows) continue;
                        this.runCommand(new String[]{"chmod", stringArray[2], file.getAbsolutePath().replaceAll(" ", "\\ ")});
                        continue;
                    }
                    if (!string5.equals("rm")) continue;
                    this.log.log("Deleting " + file);
                    file.delete();
                }
            }
        }
    }

    private void runCommand(String[] stringArray) {
        try {
            stringArray[0] = this.findCommand(stringArray[0]);
            String string = "";
            for (String string2 : stringArray) {
                string = string + " " + string2;
            }
            this.log.log("Executing" + string);
            Runtime.getRuntime().exec(stringArray).waitFor();
        }
        catch (Throwable throwable) {
            this.log.log("Failed to execute command", throwable);
        }
    }

    private String findCommand(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"/bin", "/usr/bin"}) {
            File file = new File(string2, string);
            if (!file.exists() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    protected boolean isVersioned(String string) {
        int n = string.lastIndexOf(95);
        if (n == -1 || string.endsWith("_")) {
            return false;
        }
        String string2 = string.substring(n + 1);
        if ((n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(0, n);
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '.' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    protected void logMultiLine(String string, List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.log.log(1, string + (String)list.get(i));
        }
    }
}

