/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.update.sf.impl2;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.html.HTMLChunk;
import org.gudy.azureus2.core3.html.HTMLPage;
import org.gudy.azureus2.core3.html.HTMLPageFactory;
import org.gudy.azureus2.core3.html.HTMLTable;
import org.gudy.azureus2.core3.html.HTMLTableCell;
import org.gudy.azureus2.core3.html.HTMLTableRow;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetails;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsException;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoader;
import org.gudy.azureus2.pluginsimpl.update.sf.SFPluginDetailsLoaderListener;
import org.gudy.azureus2.pluginsimpl.update.sf.impl2.SFPluginDetailsImpl;

public class SFPluginDetailsLoaderImpl
implements SFPluginDetailsLoader,
ResourceDownloaderListener {
    private static final LogIDs LOGID;
    private static final String site_prefix_default = "http://azureus.sourceforge.net/";
    private static String site_prefix;
    private static String base_url_params;
    private static String page_url;
    private static SFPluginDetailsLoaderImpl singleton;
    private static AEMonitor class_mon;
    private static final int RELOAD_MIN_TIME = 3600000;
    protected boolean plugin_ids_loaded;
    protected long plugin_ids_loaded_at;
    protected List plugin_ids;
    protected Map plugin_map;
    protected List listeners = new ArrayList();
    protected ResourceDownloaderFactory rd_factory = ResourceDownloaderFactoryImpl.getSingleton();
    protected AEMonitor this_mon = new AEMonitor("SFPluginDetailsLoader");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SFPluginDetailsLoader getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new SFPluginDetailsLoaderImpl();
            }
            SFPluginDetailsLoaderImpl sFPluginDetailsLoaderImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return sFPluginDetailsLoaderImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected SFPluginDetailsLoaderImpl() {
        this.reset();
    }

    protected String getRelativeURLBase() {
        return site_prefix;
    }

    protected void loadPluginList() throws SFPluginDetailsException {
        try {
            ResourceDownloader resourceDownloader = this.rd_factory.create(new URL(page_url));
            resourceDownloader = this.rd_factory.getRetryDownloader(resourceDownloader, 5);
            resourceDownloader.addListener(this);
            Properties properties = new Properties();
            InputStream inputStream = resourceDownloader.download();
            properties.load(inputStream);
            inputStream.close();
            for (String string : properties.keySet()) {
                String string2 = (String)properties.get(string);
                int n = 0;
                ArrayList<String> arrayList = new ArrayList<String>();
                while (n < string2.length()) {
                    int n2 = string2.indexOf(59, n);
                    if (n2 == -1) {
                        arrayList.add(string2.substring(n).trim());
                        break;
                    }
                    arrayList.add(string2.substring(n, n2).trim());
                    n = n2 + 1;
                }
                if (arrayList.size() < 3) {
                    Logger.log(new LogEvent(LOGID, 3, "SF loadPluginList failed for plugin '" + string + "'.  Details array is " + arrayList.size() + " (3 min)"));
                    continue;
                }
                String string3 = (String)arrayList.get(0);
                String string4 = (String)arrayList.get(1);
                String string5 = (String)arrayList.get(2);
                String string6 = "";
                if (arrayList.size() > 3) {
                    string6 = (String)arrayList.get(3);
                }
                this.plugin_ids.add(string);
                this.plugin_map.put(string.toLowerCase(MessageText.LOCALE_ENGLISH), new SFPluginDetailsImpl(this, string, string3, string4, string5, string6));
            }
            this.plugin_ids_loaded = true;
            this.plugin_ids_loaded_at = SystemTime.getCurrentTime();
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new SFPluginDetailsException("Plugin list load failed", throwable);
        }
    }

    protected void loadPluginDetails(SFPluginDetailsImpl sFPluginDetailsImpl) throws SFPluginDetailsException {
        try {
            ResourceDownloader resourceDownloader = this.rd_factory.create(new URL(site_prefix + "plugin_details.php?plugin=" + sFPluginDetailsImpl.getId() + "&" + base_url_params));
            resourceDownloader = this.rd_factory.getRetryDownloader(resourceDownloader, 5);
            resourceDownloader.addListener(this);
            HTMLPage hTMLPage = HTMLPageFactory.loadPage(resourceDownloader.download(), "UTF-8");
            if (!this.processPluginPage(sFPluginDetailsImpl, hTMLPage)) {
                throw new SFPluginDetailsException("Plugin details load fails for '" + sFPluginDetailsImpl.getId() + "': data not found");
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            throw new SFPluginDetailsException("Plugin details load fails", throwable);
        }
    }

    protected boolean processPluginPage(SFPluginDetailsImpl sFPluginDetailsImpl, HTMLPage hTMLPage) throws SFPluginDetailsException {
        HTMLTable[] hTMLTableArray = hTMLPage.getTables();
        return this.processPluginPage(sFPluginDetailsImpl, hTMLTableArray);
    }

    protected boolean processPluginPage(SFPluginDetailsImpl sFPluginDetailsImpl, HTMLTable[] hTMLTableArray) throws SFPluginDetailsException {
        for (int i = 0; i < hTMLTableArray.length; ++i) {
            HTMLChunk[] hTMLChunkArray;
            HTMLTable hTMLTable = hTMLTableArray[i];
            HTMLTableRow[] hTMLTableRowArray = hTMLTable.getRows();
            if (hTMLTableRowArray.length == 10 && (hTMLChunkArray = hTMLTableRowArray[0].getCells()).length == 6 && hTMLChunkArray[0].getContent().trim().equals("Name") && hTMLChunkArray[5].getContent().trim().equals("Contact")) {
                HTMLTableCell[] hTMLTableCellArray = hTMLTableRowArray[2].getCells();
                String string = hTMLTableCellArray[4].getContent();
                String[] stringArray = hTMLTableCellArray[2].getLinks();
                String string2 = stringArray.length == 0 ? "<unknown>" : site_prefix + stringArray[0];
                HTMLTableCell[] hTMLTableCellArray2 = hTMLTableRowArray[3].getCells();
                String[] stringArray2 = hTMLTableCellArray2[2].getLinks();
                String string3 = stringArray2.length == 0 ? "<unknown>" : site_prefix + stringArray2[0];
                String string4 = null;
                if (hTMLTableRowArray[9].getCells().length > 1) {
                    string4 = hTMLTableRowArray[9].getCells()[1].getContent();
                }
                sFPluginDetailsImpl.setDetails(string2, string, string3, hTMLTableRowArray[6].getCells()[0].getContent(), hTMLTableRowArray[9].getCells()[0].getContent(), string4);
                return true;
            }
            hTMLChunkArray = hTMLTable.getTables();
            boolean bl = this.processPluginPage(sFPluginDetailsImpl, (HTMLTable[])hTMLChunkArray);
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    protected void dumpTables(String string, HTMLTable[] hTMLTableArray) {
        for (int i = 0; i < hTMLTableArray.length; ++i) {
            HTMLTable hTMLTable = hTMLTableArray[i];
            System.out.println(string + "tab:" + hTMLTable.getContent());
            HTMLTableRow[] hTMLTableRowArray = hTMLTable.getRows();
            for (int j = 0; j < hTMLTableRowArray.length; ++j) {
                HTMLTableRow hTMLTableRow = hTMLTableRowArray[j];
                System.out.println(string + "  row[" + j + "]: " + hTMLTableRowArray[j].getContent());
                HTMLTableCell[] hTMLTableCellArray = hTMLTableRow.getCells();
                for (int k = 0; k < hTMLTableCellArray.length; ++k) {
                    System.out.println(string + "    cell[" + k + "]: " + hTMLTableCellArray[k].getContent());
                }
            }
            this.dumpTables(string + "  ", hTMLTable.getTables());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPluginIDs() throws SFPluginDetailsException {
        try {
            this.this_mon.enter();
            if (!this.plugin_ids_loaded) {
                this.loadPluginList();
            }
            String[] stringArray = new String[this.plugin_ids.size()];
            this.plugin_ids.toArray(stringArray);
            String[] stringArray2 = stringArray;
            Object var4_3 = null;
            this.this_mon.exit();
            return stringArray2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SFPluginDetails getPluginDetails(String string) throws SFPluginDetailsException {
        try {
            this.this_mon.enter();
            this.getPluginIDs();
            SFPluginDetails sFPluginDetails = (SFPluginDetails)this.plugin_map.get(string.toLowerCase(MessageText.LOCALE_ENGLISH));
            if (sFPluginDetails == null) {
                throw new SFPluginDetailsException("Plugin '" + string + "' not found");
            }
            SFPluginDetails sFPluginDetails2 = sFPluginDetails;
            Object var5_4 = null;
            this.this_mon.exit();
            return sFPluginDetails2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public SFPluginDetails[] getPluginDetails() throws SFPluginDetailsException {
        String[] stringArray = this.getPluginIDs();
        SFPluginDetails[] sFPluginDetailsArray = new SFPluginDetails[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            sFPluginDetailsArray[i] = this.getPluginDetails(stringArray[i]);
        }
        return sFPluginDetailsArray;
    }

    public void reportPercentComplete(ResourceDownloader resourceDownloader, int n) {
    }

    public void reportAmountComplete(ResourceDownloader resourceDownloader, long l) {
    }

    public void reportActivity(ResourceDownloader resourceDownloader, String string) {
        this.informListeners(string);
    }

    public boolean completed(ResourceDownloader resourceDownloader, InputStream inputStream) {
        return true;
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.informListeners("Error: " + resourceDownloaderException.getMessage());
    }

    protected void informListeners(String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((SFPluginDetailsLoaderListener)this.listeners.get(i)).log(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.this_mon.enter();
            long l = SystemTime.getCurrentTime();
            if (l < this.plugin_ids_loaded_at) {
                this.plugin_ids_loaded_at = 0L;
            }
            if (l - this.plugin_ids_loaded_at > 3600000L) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SFPluginDetailsLoader: resetting values"));
                }
                this.plugin_ids_loaded = false;
                this.plugin_ids = new ArrayList();
                this.plugin_map = new HashMap();
            } else if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "SFPluginDetailsLoader: not resetting, cache still valid"));
            }
            Object var4_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public void addListener(SFPluginDetailsLoaderListener sFPluginDetailsLoaderListener) {
        this.listeners.add(sFPluginDetailsLoaderListener);
    }

    public void removeListener(SFPluginDetailsLoaderListener sFPluginDetailsLoaderListener) {
        this.listeners.remove(sFPluginDetailsLoaderListener);
    }

    static {
        Object object;
        Class<?> clazz;
        LOGID = LogIDs.CORE;
        try {
            clazz = VersionCheckClient.getSingleton().getVersionCheckInfo("pu");
            object = (byte[])clazz.get("plugin_update_url");
            site_prefix = object == null ? site_prefix_default : new String((byte[])object);
        }
        catch (Throwable throwable) {
            site_prefix = site_prefix_default;
        }
        base_url_params = "version=4.5.0.4&app=" + SystemProperties.getApplicationName();
        try {
            base_url_params = base_url_params + "&os=" + URLEncoder.encode(System.getProperty("os.name"), "UTF-8");
            base_url_params = base_url_params + "&osv=" + URLEncoder.encode(System.getProperty("os.version"), "UTF-8");
            base_url_params = base_url_params + "&arch=" + URLEncoder.encode(System.getProperty("os.arch"), "UTF-8");
            base_url_params = base_url_params + "&ui=" + URLEncoder.encode(COConfigurationManager.getStringParameter("ui"), "UTF-8");
            base_url_params = base_url_params + "&java=" + URLEncoder.encode(System.getProperty("java.version"), "UTF-8");
            try {
                clazz = Class.forName("org.eclipse.swt.SWT");
                object = (String)clazz.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
                base_url_params = base_url_params + "&swt_platform=" + (String)object;
                Integer n = (Integer)clazz.getMethod("getVersion", new Class[0]).invoke(null, new Object[0]);
                base_url_params = base_url_params + "&swt_version=" + n;
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        page_url = site_prefix + "update/pluginlist3.php?type=&" + base_url_params;
        try {
            clazz = PlatformManagerFactory.getPlatformManager();
            if (clazz.hasCapability(PlatformManagerCapabilities.GetVersion)) {
                page_url = page_url + "&pmv=" + clazz.getVersion();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_mon = new AEMonitor("SFPluginDetailsLoader:class");
    }
}

