/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import com.google.inject.Singleton;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.NBThrottle;
import org.limewire.nio.ScheduledFutureTask;
import org.limewire.nio.observer.AcceptChannelObserver;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.IOErrorObserver;
import org.limewire.nio.observer.ReadObserver;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.observer.TransportListener;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.TimeoutController;
import org.limewire.nio.timeout.Timeoutable;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class NIODispatcher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(NIODispatcher.class);
    private static final NIODispatcher INSTANCE = new NIODispatcher();
    private static final long SPIN_AMOUNT = 5000L;
    private static final int MAX_IGNORES = 5;
    private static final long CACHE_CLEAR_INTERVAL = 30000L;
    private final Thread dispatchThread;
    private final Object Q_LOCK = new Object();
    @InspectionPoint(value="nio selector stats")
    private final SelectStats stats = new SelectStats();
    private final TransportListener TRANSPORT_LISTENER = new MyTransportListener();
    private final ScheduledExecutorService EXECUTOR;
    private final Map<Class<? extends SelectableChannel>, Selector> OTHER_SELECTORS = new HashMap<Class<? extends SelectableChannel>, Selector>();
    private final List<Selector> POLLERS = new ArrayList<Selector>();
    private Collection<Runnable> LATER = new LinkedList<Runnable>();
    private final BlockingQueue<ScheduledFutureTask> DELAYED = new DelayQueue<ScheduledFutureTask>();
    private final List<NBThrottle> THROTTLE = new ArrayList<NBThrottle>();
    private final TimeoutController TIMEOUTER = new TimeoutController();
    private final ByteBufferCache BUFFER_CACHE = new ByteBufferCache();
    private Selector primarySelector = null;
    private long iteration = 0L;
    private volatile boolean wokeup = false;
    private long lastCacheClearTime;

    public static final NIODispatcher instance() {
        return INSTANCE;
    }

    private NIODispatcher() {
        boolean bl = false;
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (!bl) {
            this.dispatchThread = ThreadExecutor.newManagedThread((Runnable)this, (String)"NIODispatcher");
            this.dispatchThread.start();
        } else {
            this.dispatchThread = null;
        }
        this.EXECUTOR = new NIOExecutorService(this.dispatchThread);
    }

    public boolean isRunning() {
        return this.dispatchThread != null;
    }

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.dispatchThread;
    }

    public ByteBufferCache getBufferCache() {
        return this.BUFFER_CACHE;
    }

    public int getNumPendingTimeouts() {
        return this.TIMEOUTER.getNumPendingTimeouts();
    }

    public void addThrottle(final NBThrottle nBThrottle) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.THROTTLE.add(nBThrottle);
        } else {
            this.executeLaterAlways(new Runnable(){

                public void run() {
                    NIODispatcher.this.THROTTLE.add(nBThrottle);
                }
            });
        }
    }

    public void register(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver) {
        this.register(selectableChannel, iOErrorObserver, 0, 0);
    }

    public void registerAccept(SelectableChannel selectableChannel, AcceptChannelObserver acceptChannelObserver) {
        this.register(selectableChannel, acceptChannelObserver, 16, 0);
    }

    public void registerConnect(SelectableChannel selectableChannel, ConnectObserver connectObserver, int n) {
        this.register(selectableChannel, connectObserver, 8, n);
    }

    public void registerRead(SelectableChannel selectableChannel, ReadObserver readObserver) {
        this.register(selectableChannel, readObserver, 1, 0);
    }

    public void registerWrite(SelectableChannel selectableChannel, WriteObserver writeObserver) {
        this.register(selectableChannel, writeObserver, 4, 0);
    }

    public void registerReadWrite(SelectableChannel selectableChannel, ReadWriteObserver readWriteObserver) {
        this.register(selectableChannel, readWriteObserver, 5, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver, int n, int n2) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.registerImpl(this.getSelectorFor(selectableChannel), selectableChannel, n, iOErrorObserver, n2);
        } else {
            Object object = this.Q_LOCK;
            synchronized (object) {
                this.LATER.add(new RegisterOp(selectableChannel, iOErrorObserver, n, n2));
            }
            this.wakeup();
        }
    }

    public void interestWrite(SelectableChannel selectableChannel, boolean bl) {
        this.interest(selectableChannel, 4, bl);
    }

    public void interestRead(SelectableChannel selectableChannel, boolean bl) {
        this.interest(selectableChannel, 1, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interest(SelectableChannel selectableChannel, int n, boolean bl) {
        block9: {
            try {
                int n2;
                Selector selector = this.getSelectorFor(selectableChannel);
                SelectionKey selectionKey = selectableChannel.keyFor(selector);
                if (selectionKey == null || !selectionKey.isValid()) break block9;
                Object object = selectionKey.attachment();
                synchronized (object) {
                    if ((n & 1) == 1) {
                        ((Attachment)selectionKey.attachment()).changeReadStatus(bl);
                    }
                    n2 = selectionKey.interestOps();
                    if (bl) {
                        selectionKey.interestOps(n2 | n);
                    } else {
                        selectionKey.interestOps(n2 & ~n);
                    }
                }
                if (bl && (n2 & n) != n) {
                    this.wakeup();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
    }

    private Selector getSelectorFor(SelectableChannel selectableChannel) {
        Selector selector = this.OTHER_SELECTORS.get(selectableChannel.getClass());
        if (selector == null) {
            return this.primarySelector;
        }
        return selector;
    }

    public void shutdown(Shutdownable shutdownable) {
        shutdownable.shutdown();
    }

    public void registerSelector(final Selector selector, final Class<? extends SelectableChannel> clazz) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.add(selector);
            this.OTHER_SELECTORS.put(clazz, selector);
        } else {
            this.executeLaterAlways(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.add(selector);
                    NIODispatcher.this.OTHER_SELECTORS.put(clazz, selector);
                }
            });
        }
    }

    public void removeSelector(final Selector selector) {
        if (Thread.currentThread() == this.dispatchThread) {
            this.POLLERS.remove(selector);
            this.OTHER_SELECTORS.remove(selector);
        } else {
            this.executeLaterAlways(new Runnable(){

                public void run() {
                    NIODispatcher.this.POLLERS.remove(selector);
                    NIODispatcher.this.OTHER_SELECTORS.remove(selector);
                }
            });
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.EXECUTOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeLaterAlways(Runnable runnable) {
        Object object = this.Q_LOCK;
        synchronized (object) {
            this.LATER.add(runnable);
        }
        this.wakeup();
    }

    public IOErrorObserver attachment(Object object) {
        return ((Attachment)object).attachment;
    }

    private void cancel(SelectionKey selectionKey, Shutdownable shutdownable) {
        selectionKey.cancel();
        if (shutdownable != null) {
            shutdownable.shutdown();
        }
    }

    private void processAccept(long l, SelectionKey selectionKey, AcceptChannelObserver acceptChannelObserver, Attachment attachment) throws IOException {
        ServerSocketChannel serverSocketChannel;
        SocketChannel socketChannel;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling accept: " + acceptChannelObserver));
        }
        if ((socketChannel = (serverSocketChannel = (ServerSocketChannel)selectionKey.channel()).accept()) == null) {
            return;
        }
        if (socketChannel.isOpen()) {
            socketChannel.configureBlocking(false);
            acceptChannelObserver.handleAcceptChannel(socketChannel);
        } else {
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                LOG.error((Object)"SocketChannel.close()", (Throwable)iOException);
            }
        }
    }

    private void processConnect(long l, SelectionKey selectionKey, ConnectObserver connectObserver, Attachment attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling connect: " + connectObserver));
        }
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        attachment.clearTimeout();
        boolean bl = socketChannel.finishConnect();
        if (bl) {
            selectionKey.interestOps(0);
            connectObserver.handleConnect(socketChannel.socket());
        } else {
            this.cancel(selectionKey, connectObserver);
        }
    }

    private void processRead(long l, ReadObserver readObserver, Attachment attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling read: " + readObserver));
        }
        attachment.updateReadTimeout(l);
        readObserver.handleRead();
    }

    private void processWrite(long l, WriteObserver writeObserver, Attachment attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Handling write: " + writeObserver));
        }
        writeObserver.handleWrite();
    }

    private void registerImpl(Selector selector, SelectableChannel selectableChannel, int n, IOErrorObserver iOErrorObserver, int n2) {
        try {
            Attachment attachment;
            SelectionKey selectionKey = selectableChannel.keyFor(selector);
            if (selectionKey != null) {
                attachment = (Attachment)selectionKey.attachment();
                attachment.discard();
            }
            attachment = new Attachment(iOErrorObserver);
            SelectionKey selectionKey2 = selectableChannel.register(selector, n, attachment);
            attachment.setKey(selectionKey2);
            if (n2 != 0) {
                attachment.addTimeout(System.currentTimeMillis(), n2);
            } else if ((n & 1) != 0) {
                attachment.changeReadStatus(true);
            }
        }
        catch (IOException iOException) {
            iOErrorObserver.handleIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPendingTasks() {
        Collection<Runnable> collection;
        long l = System.currentTimeMillis();
        Iterator<Object> iterator = this.Q_LOCK;
        synchronized (iterator) {
            collection = this.LATER;
            this.LATER = new LinkedList<Runnable>();
        }
        this.DELAYED.drainTo(collection);
        if (l > this.lastCacheClearTime + 30000L) {
            this.BUFFER_CACHE.clearCache();
            this.lastCacheClearTime = l;
        }
        if (!collection.isEmpty()) {
            for (Runnable object : collection) {
                try {
                    object.run();
                }
                catch (Throwable throwable) {
                    LOG.error((Object)throwable);
                    ErrorService.error((Throwable)throwable);
                }
            }
        }
        l = System.currentTimeMillis();
        for (NBThrottle nBThrottle : this.THROTTLE) {
            nBThrottle.tick(l);
        }
    }

    private Collection<SelectionKey> pollOtherSelectors() {
        Set<SelectionKey> set = null;
        boolean bl = false;
        for (int i = 0; i < this.POLLERS.size(); ++i) {
            Set<SelectionKey> set2;
            Selector selector = this.POLLERS.get(i);
            int n = 0;
            try {
                n = selector.selectNow();
            }
            catch (IOException iOException) {
                LOG.error((Object)"Error performing secondary select", (Throwable)iOException);
            }
            if (n == 0 || (set2 = selector.selectedKeys()).isEmpty()) continue;
            if (set == null) {
                set = set2;
                continue;
            }
            if (!bl) {
                bl = true;
                set = new HashSet<SelectionKey>(set);
                set.addAll(set2);
                continue;
            }
            set.addAll(set2);
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    private void readyThrottles(Collection<SelectionKey> collection) {
        for (int i = 0; i < this.THROTTLE.size(); ++i) {
            this.THROTTLE.get(i).selectableKeys(collection);
        }
    }

    void wakeup() {
        if (!this.wokeup && Thread.currentThread() != this.dispatchThread) {
            this.wokeup = true;
            this.primarySelector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() throws ProcessingException, SpinningException {
        boolean bl = false;
        long l = -1L;
        int n = 0;
        int n2 = 0;
        while (true) {
            Set<SelectionKey> set;
            long l2;
            this.runPendingTasks();
            Collection<SelectionKey> collection = this.pollOtherSelectors();
            boolean bl2 = !collection.isEmpty();
            try {
                if (!bl2 && bl) {
                    l = System.currentTimeMillis();
                }
                if (!bl2) {
                    long l3 = this.nextSelectTimeout();
                    if (l3 == 0L) {
                        bl2 = true;
                    } else {
                        l2 = System.nanoTime();
                        try {
                            if (Thread.interrupted()) {
                                LOG.warn((Object)"interrupted?");
                            }
                            this.primarySelector.select(Math.min(l3, Integer.MAX_VALUE));
                        }
                        finally {
                            this.stats.updateSelectTime(System.nanoTime() - l2);
                        }
                    }
                }
                if (bl2) {
                    this.stats.countSelectNow();
                    this.primarySelector.selectNow();
                }
            }
            catch (NullPointerException nullPointerException) {
                LOG.warn((Object)"npe", (Throwable)nullPointerException);
                continue;
            }
            catch (CancelledKeyException cancelledKeyException) {
                LOG.warn((Object)"cancelled", (Throwable)cancelledKeyException);
                continue;
            }
            catch (IOException iOException) {
                throw new ProcessingException(iOException);
            }
            Set<SelectionKey> set2 = this.primarySelector.selectedKeys();
            if (!bl2 && !this.wokeup) {
                if (set2.isEmpty()) {
                    long l4 = System.currentTimeMillis();
                    if (l == -1L) {
                        LOG.trace((Object)"No keys selected, starting spin check.");
                        bl = true;
                    } else if (l + 30L >= l4) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Spinning detected, current spins: " + n + " startSelect " + l + " now " + l4 + " keys " + this.primarySelector.keys()));
                        }
                        if ((long)n++ > 5000L) {
                            throw new SpinningException();
                        }
                    } else {
                        bl = false;
                        l = -1L;
                        n = 0;
                        n2 = 0;
                    }
                    this.TIMEOUTER.processTimeouts(l4);
                    continue;
                }
                if (bl && ++n2 > 5) {
                    bl = false;
                    n = 0;
                    l = -1L;
                    n2 = 0;
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Selected keys: (" + set2.size() + "), polled: (" + collection.size() + "). wokeup " + this.wokeup + " immediate " + bl2));
            }
            if (!collection.isEmpty()) {
                set = new HashSet<SelectionKey>(set2.size() + collection.size());
                set.addAll(set2);
                set.addAll(collection);
            } else {
                set = set2;
            }
            this.readyThrottles(set);
            l2 = System.currentTimeMillis();
            for (SelectionKey selectionKey : set) {
                this.process(l2, selectionKey, selectionKey.attachment(), 65535);
            }
            set2.clear();
            ++this.iteration;
            this.TIMEOUTER.processTimeouts(l2);
            this.wokeup = false;
        }
    }

    private long nextSelectTimeout() {
        long l = Long.MAX_VALUE;
        for (NBThrottle nBThrottle : this.THROTTLE) {
            l = Math.min(l, nBThrottle.nextTickTime());
        }
        long l2 = System.currentTimeMillis();
        if ((l -= l2) <= 0L) {
            return 0L;
        }
        long l3 = this.TIMEOUTER.getNextExpireTime();
        if (l3 > -1L) {
            l = Math.min(l, l3 - l2);
        }
        if (l <= 0L) {
            return 0L;
        }
        Delayed delayed = (Delayed)this.DELAYED.peek();
        if (delayed != null) {
            l = Math.min(l, delayed.getDelay(TimeUnit.MILLISECONDS));
        }
        return Math.max(0L, l);
    }

    boolean isReadReadyThisIteration(SelectableChannel selectableChannel) {
        Attachment attachment;
        SelectionKey selectionKey = selectableChannel.keyFor(this.getSelectorFor(selectableChannel));
        Object object = selectionKey.attachment();
        if (object instanceof Attachment && (attachment = (Attachment)selectionKey.attachment()).lastMod == this.iteration + 1L && selectionKey.isValid()) {
            try {
                return (selectionKey.readyOps() & ~attachment.handled & 1) != 0;
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
        }
        return false;
    }

    void process(long l, SelectionKey selectionKey, Object object, int n) {
        Attachment attachment = (Attachment)object;
        IOErrorObserver iOErrorObserver = attachment.attachment;
        if (attachment.lastMod <= this.iteration) {
            attachment.handled = 0;
        }
        attachment.lastMod = this.iteration + 1L;
        if (selectionKey.isValid()) {
            try {
                try {
                    int n2 = ~attachment.handled;
                    int n3 = selectionKey.readyOps();
                    if ((n & n3 & n2 & 0x10) != 0) {
                        attachment.handled |= 16;
                        this.processAccept(l, selectionKey, (AcceptChannelObserver)iOErrorObserver, attachment);
                    } else if ((n & n3 & n2 & 8) != 0) {
                        attachment.handled |= 8;
                        this.processConnect(l, selectionKey, (ConnectObserver)iOErrorObserver, attachment);
                    } else {
                        if ((n & n3 & n2 & 1) != 0) {
                            attachment.handled |= 1;
                            this.processRead(l, (ReadObserver)iOErrorObserver, attachment);
                        }
                        if ((n & n3 & n2 & 4) != 0) {
                            attachment.handled |= 4;
                            this.processWrite(l, (WriteObserver)iOErrorObserver, attachment);
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    LOG.warn((Object)"Ignoring cancelled key", (Throwable)cancelledKeyException);
                }
                catch (IOException iOException) {
                    LOG.warn((Object)"IOX processing", (Throwable)iOException);
                    try {
                        selectionKey.cancel();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    iOErrorObserver.handleIOException(iOException);
                }
            }
            catch (Throwable throwable) {
                ErrorService.error((Throwable)throwable, (String)"Unhandled exception while dispatching");
                this.safeCancel(selectionKey, iOErrorObserver);
            }
        } else {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("SelectionKey cancelled for: " + iOErrorObserver));
            }
            this.safeCancel(selectionKey, iOErrorObserver);
        }
    }

    private void safeCancel(SelectionKey selectionKey, Shutdownable shutdownable) {
        try {
            this.cancel(selectionKey, shutdownable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void swapSelector() {
        Selector selector = this.primarySelector;
        Set<Object> set = Collections.emptySet();
        try {
            if (selector != null) {
                set = selector.keys();
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            LOG.warn((Object)"error getting keys", (Throwable)closedSelectorException);
        }
        try {
            this.primarySelector = Selector.open();
        }
        catch (IOException iOException) {
            LOG.error((Object)"Can't make a new selector!!!", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        for (SelectionKey selectionKey : set) {
            try {
                SelectableChannel selectableChannel = selectionKey.channel();
                Attachment attachment = (Attachment)selectionKey.attachment();
                int n = selectionKey.interestOps();
                try {
                    SelectionKey selectionKey2 = selectableChannel.register(this.primarySelector, n, attachment);
                    attachment.setKey(selectionKey2);
                }
                catch (IOException iOException) {
                    attachment.attachment.handleIOException(iOException);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                LOG.warn((Object)"key cancelled while swapping", (Throwable)cancelledKeyException);
            }
        }
        try {
            if (selector != null) {
                selector.close();
            }
        }
        catch (IOException iOException) {
            LOG.warn((Object)"error closing old selector", (Throwable)iOException);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.primarySelector == null) {
                        this.primarySelector = Selector.open();
                    }
                    this.process();
                }
            }
            catch (SpinningException spinningException) {
                LOG.warn((Object)"selector is spinning!", (Throwable)spinningException);
                this.swapSelector();
                continue;
            }
            catch (ProcessingException processingException) {
                LOG.warn((Object)"unknown exception while selecting", (Throwable)processingException);
                this.swapSelector();
                continue;
            }
            catch (IOException iOException) {
                LOG.error((Object)"Unable to create a new Selector!!!", (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
            catch (Throwable throwable) {
                LOG.error((Object)"Error in Selector!", throwable);
                ErrorService.error((Throwable)throwable);
                this.swapSelector();
                continue;
            }
            break;
        }
    }

    public TransportListener getTransportListener() {
        return this.TRANSPORT_LISTENER;
    }

    public long[] getSelectStats() {
        return this.stats.getStats();
    }

    public static class SelectStats
    implements Inspectable {
        private long numSelects;
        private long numImmediateSelects;
        private long avgSelectTime;

        public synchronized long[] getStats() {
            return new long[]{this.numSelects, this.numImmediateSelects, this.avgSelectTime};
        }

        synchronized void updateSelectTime(long l) {
            long l2 = this.avgSelectTime;
            long l3 = this.numSelects;
            l2 = Math.max(0L, l2 * Math.max(1L, l3));
            ++l3;
            l3 = Math.max(1L, l3);
            l2 = Math.max(0L, l2 + l) / l3;
            this.numSelects = l3;
            this.avgSelectTime = l2;
        }

        synchronized void countSelectNow() {
            this.numImmediateSelects = Math.max(0L, this.numImmediateSelects + 1L);
        }

        public Object inspect() {
            long[] lArray = this.getStats();
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            hashMap.put("ver", 1);
            hashMap.put("num", lArray[0]);
            hashMap.put("numIm", lArray[1]);
            hashMap.put("avg", lArray[2]);
            return hashMap;
        }
    }

    private class MyTransportListener
    implements TransportListener {
        private MyTransportListener() {
        }

        public void eventPending() {
            NIODispatcher.this.wakeup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NIOExecutorService
    extends AbstractExecutorService
    implements ScheduledExecutorService {
        private final Thread nioThread;

        private NIOExecutorService(Thread thread) {
            this.nioThread = thread;
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            Thread.sleep(timeUnit.toMillis(l));
            return false;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable runnable) {
            if (Thread.currentThread() == this.nioThread) {
                runnable.run();
            } else {
                NIODispatcher.instance().executeLaterAlways(runnable);
            }
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
            ScheduledFutureTask<Object> scheduledFutureTask = new ScheduledFutureTask<Object>(runnable, null, timeUnit.toNanos(l));
            NIODispatcher.instance().DELAYED.add(scheduledFutureTask);
            NIODispatcher.instance().wakeup();
            return scheduledFutureTask;
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
            ScheduledFutureTask<V> scheduledFutureTask = new ScheduledFutureTask<V>(callable, timeUnit.toNanos(l));
            NIODispatcher.instance().DELAYED.add(scheduledFutureTask);
            NIODispatcher.instance().wakeup();
            return scheduledFutureTask;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ProcessingException
    extends Exception {
        public ProcessingException() {
        }

        public ProcessingException(Throwable throwable) {
            super(throwable);
        }
    }

    private static class SpinningException
    extends Exception {
    }

    private class RegisterOp
    implements Runnable {
        private final SelectableChannel channel;
        private final IOErrorObserver handler;
        private final int op;
        private final int timeout;

        RegisterOp(SelectableChannel selectableChannel, IOErrorObserver iOErrorObserver, int n, int n2) {
            this.channel = selectableChannel;
            this.handler = iOErrorObserver;
            this.op = n;
            this.timeout = n2;
        }

        public void run() {
            NIODispatcher.this.registerImpl(NIODispatcher.this.getSelectorFor(this.channel), this.channel, this.op, this.handler, this.timeout);
        }
    }

    class Attachment
    implements Timeoutable {
        private final IOErrorObserver attachment;
        private long lastMod;
        private int handled;
        private SelectionKey key;
        private boolean timeoutActive = false;
        private long storedTimeoutLength = Long.MAX_VALUE;
        private long storedExpireTime = Long.MAX_VALUE;
        private volatile boolean discarded;

        Attachment(IOErrorObserver iOErrorObserver) {
            this.attachment = iOErrorObserver;
        }

        public String toString() {
            return "Attachment for: " + this.attachment;
        }

        void discard() {
            this.discarded = true;
        }

        synchronized void clearTimeout() {
            this.timeoutActive = false;
        }

        synchronized void updateReadTimeout(long l) {
            if (!this.discarded && this.attachment instanceof ReadTimeout) {
                long l2 = ((ReadTimeout)((Object)this.attachment)).getReadTimeout();
                if (l2 != 0L) {
                    long l3 = l + l2;
                    if (l3 < this.storedExpireTime || this.storedExpireTime == -1L || this.storedExpireTime < l) {
                        this.addTimeout(l, l2);
                    } else {
                        this.storedExpireTime = l3;
                        this.storedTimeoutLength = l2;
                        this.timeoutActive = true;
                    }
                } else {
                    this.clearTimeout();
                }
            }
        }

        synchronized void changeReadStatus(boolean bl) {
            if (!this.discarded) {
                if (bl) {
                    this.updateReadTimeout(System.currentTimeMillis());
                } else {
                    this.clearTimeout();
                }
            }
        }

        synchronized void addTimeout(long l, long l2) {
            if (!this.discarded) {
                this.timeoutActive = true;
                this.storedTimeoutLength = l2;
                this.storedExpireTime = l + l2;
                NIODispatcher.this.TIMEOUTER.addTimeout(this, l, l2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyTimeout(long l, long l2, long l3) {
            if (!this.discarded) {
                boolean bl = false;
                long l4 = 0L;
                Attachment attachment = this;
                synchronized (attachment) {
                    if (this.timeoutActive) {
                        if (l2 == this.storedExpireTime) {
                            bl = true;
                            this.timeoutActive = false;
                            l4 = this.storedTimeoutLength;
                            this.storedExpireTime = -1L;
                        } else if (l2 < this.storedExpireTime) {
                            NIODispatcher.this.TIMEOUTER.addTimeout(this, l, this.storedExpireTime - l);
                        } else {
                            this.storedExpireTime = -1L;
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)("Ignoring extra timeout for: " + this.attachment));
                            }
                        }
                    } else {
                        this.storedExpireTime = -1L;
                        this.storedTimeoutLength = -1L;
                    }
                }
                if (bl) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Closing due to read timeout: " + this.attachment));
                    }
                    NIODispatcher.this.cancel(this.key, this.attachment);
                    this.attachment.handleIOException(new SocketTimeoutException("operation timed out (" + l4 + ")"));
                }
            }
        }

        public void setKey(SelectionKey selectionKey) {
            this.key = selectionKey;
        }
    }
}

