/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.limewire.collection.Buffer;
import org.limewire.collection.RandomAccessMap;
import org.limewire.collection.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeArrayHashMap<K, V>
extends HashMap<K, V>
implements RandomAccessMap<K, V> {
    private Buffer<Map.Entry<K, V>> buf;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Set<K> keySet = null;
    private volatile transient Collection<V> values = null;

    public FixedSizeArrayHashMap(int n) {
        this.buf = new Buffer(n);
    }

    public FixedSizeArrayHashMap(int n, Map<? extends K, ? extends V> map) {
        this.buf = new Buffer(n);
        this.putAll(map);
    }

    public FixedSizeArrayHashMap(Map<? extends K, ? extends V> map) {
        this(map.size(), map);
    }

    public FixedSizeArrayHashMap(int n, int n2, float f) {
        super(n2, f);
        this.buf = new Buffer(n);
    }

    public FixedSizeArrayHashMap(int n, int n2) {
        super(n2);
        this.buf = new Buffer(n);
    }

    @Override
    public Object clone() {
        FixedSizeArrayHashMap fixedSizeArrayHashMap = (FixedSizeArrayHashMap)super.clone();
        fixedSizeArrayHashMap.buf = this.buf.clone();
        return fixedSizeArrayHashMap;
    }

    @Override
    public void clear() {
        this.buf.clear();
        super.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V getValueAt(int n) {
        return this.buf.get(n).getValue();
    }

    @Override
    public K getKeyAt(int n) {
        return this.buf.get(n).getKey();
    }

    @Override
    public Map.Entry<K, V> getEntryAt(int n) {
        return this.buf.get(n);
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            throw new IllegalArgumentException("null key/value not supported!");
        }
        V v2 = super.put(k, v);
        if (v2 == null) {
            Map.Entry entry = this.buf.add(new FixedEntry<K, V>(k, v));
            if (entry != null) {
                Object v3 = super.remove(entry.getKey());
                assert (v3 == entry.getValue());
            }
        } else {
            FixedEntry<K, V> fixedEntry = new FixedEntry<K, V>(k, v);
            boolean bl = this.buf.remove(fixedEntry);
            assert (bl);
            FixedEntry<K, V> fixedEntry2 = this.buf.add(fixedEntry);
            assert (fixedEntry2 == null);
        }
        return v2;
    }

    @Override
    public V remove(Object object) {
        Object v = super.remove(object);
        if (v != null) {
            boolean bl = this.buf.remove(new FixedEntry(object, v));
            assert (bl);
        }
        return v;
    }

    protected Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new ArrayHashMapEntryIterator();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = FixedSizeArrayHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return FixedSizeArrayHashMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return FixedSizeArrayHashMap.this.containsKey(object);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = FixedSizeArrayHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return FixedSizeArrayHashMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return FixedSizeArrayHashMap.this.containsValue(object);
                }
            };
        }
        return this.values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return FixedSizeArrayHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            return FixedSizeArrayHashMap.this.containsKey(k) && FixedSizeArrayHashMap.this.get(k).equals(v);
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return FixedSizeArrayHashMap.this.size();
        }

        @Override
        public void clear() {
            FixedSizeArrayHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayHashMapEntryIterator
    extends UnmodifiableIterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> iter;
        private Map.Entry<K, V> current;

        private ArrayHashMapEntryIterator() {
            this.iter = FixedSizeArrayHashMap.this.buf.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iter.next();
            return this.current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixedEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        FixedEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            FixedEntry fixedEntry = (FixedEntry)object;
            return this.key.equals(fixedEntry.key) && this.value.equals(fixedEntry.value);
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

