/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeExpiringSet<T>
implements Set<T>,
Collection<T> {
    private static final long MAX_EXPIRE_TIME = 9223372036854L;
    private static final int DEFAULT_SIZE = 50;
    private static final long DEFAULT_EXPIRE_TIME = -1295421440L;
    private final int _maxSize;
    private final long _expireTime;
    private Map<T, Long> _map;

    public FixedSizeExpiringSet() {
        this(50);
    }

    public FixedSizeExpiringSet(int n) {
        this(n, -1295421440L);
    }

    public FixedSizeExpiringSet(int n, long l) {
        this._maxSize = n;
        l = Math.min(9223372036854L, l);
        this._expireTime = l * 1000L * 1000L;
        this._map = new HashMap<T, Long>();
    }

    @Override
    public int size() {
        this.expire(false);
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        Long l = this._map.get(object);
        if (l == null) {
            return false;
        }
        if (l < System.nanoTime()) {
            this._map.remove(object);
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        this.expire(false);
        return this._map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        this.expire(false);
        return this._map.keySet().toArray();
    }

    @Override
    public <B> B[] toArray(B[] BArray) {
        this.expire(false);
        return this._map.keySet().toArray(BArray);
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            return false;
        }
        this.expire(this.size() >= this._maxSize);
        if (this._map.containsKey(t)) {
            return false;
        }
        this._map.put(t, System.nanoTime() + this._expireTime);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this._map.remove(object) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this._map.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < this._maxSize && iterator.hasNext(); ++i) {
            this.add(iterator.next());
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        HashMap<T, Long> hashMap = new HashMap<T, Long>();
        boolean bl = false;
        for (T t : this._map.keySet()) {
            if (collection.contains(t)) {
                hashMap.put(t, this._map.get(t));
                continue;
            }
            bl = true;
        }
        if (bl) {
            this._map = hashMap;
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    private void expire(boolean bl) {
        if (this._map.size() == 0) {
            return;
        }
        long l = System.nanoTime();
        long l2 = Long.MAX_VALUE;
        Object var6_4 = null;
        HashSet<T> hashSet = new HashSet<T>();
        for (T t : this._map.keySet()) {
            long l3 = this._map.get(t);
            if (l3 < l) {
                hashSet.add(t);
                bl = false;
                continue;
            }
            if (!bl || l3 >= l2) continue;
            l2 = l3;
            var6_4 = t;
        }
        if (hashSet.size() > 0) {
            this.removeAll(hashSet);
        }
        if (bl) {
            this.remove(var6_4);
        }
    }
}

