/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForgetfulHashMap<K, V>
extends HashMap<K, V> {
    private Object[] queue;
    private int next;
    private int n;

    public ForgetfulHashMap(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[n];
        this.next = 0;
        this.n = n;
    }

    @Override
    public V put(K k, V v) {
        V v2 = super.put(k, v);
        if (this.queue[this.next] != null) {
            super.remove(this.queue[this.next]);
        }
        this.queue[this.next] = k;
        ++this.next;
        if (this.next >= this.n) {
            this.next = 0;
        }
        return v2;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }
}

