/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public abstract class AbstractLyrics3v2FieldFrameBody
extends AbstractTagFrameBody {
    public AbstractLyrics3v2FieldFrameBody() {
    }

    public AbstractLyrics3v2FieldFrameBody(AbstractLyrics3v2FieldFrameBody copyObject) {
        super(copyObject);
    }

    protected int readHeader(RandomAccessFile file) throws InvalidTagException, IOException {
        byte[] buffer = new byte[5];
        file.read(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        return size;
    }

    protected void writeHeader(RandomAccessFile file, int size) throws IOException {
        int offset = 0;
        byte[] buffer = new byte[5];
        String str = Integer.toString(this.getSize());
        int i = 0;
        while (i < 5 - str.length()) {
            buffer[i] = 48;
            ++i;
        }
        offset += 5 - str.length();
        i = 0;
        while (i < str.length()) {
            buffer[i + offset] = (byte)str.charAt(i);
            ++i;
        }
        file.write(buffer);
    }

    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        int size = this.getSize();
        byte[] buffer = new byte[size];
        byteBuffer.get(buffer);
        int offset = 0;
        Iterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            if (offset > size - 1) {
                throw new InvalidTagException("Invalid size for Frame Body");
            }
            AbstractDataType object = (AbstractDataType)iterator.next();
            object.readByteArray(buffer, offset);
            offset += object.getSize();
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        Iterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            byte[] buffer = object.writeByteArray();
            file.write(buffer);
        }
    }
}

