/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyAUT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAL;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAR;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyETT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyIMG;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyIND;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyINF;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyUnsupported;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;

public class Lyrics3v2Field
extends AbstractTagFrame {
    public Lyrics3v2Field() {
    }

    public Lyrics3v2Field(Lyrics3v2Field copyObject) {
        super(copyObject);
    }

    public Lyrics3v2Field(AbstractLyrics3v2FieldFrameBody body) {
        this.frameBody = body;
    }

    public Lyrics3v2Field(AbstractID3v2Frame frame) throws TagException {
        String frameIdentifier = frame.getIdentifier();
        if (frameIdentifier.startsWith("USLT")) {
            this.frameBody = new FieldFrameBodyLYR("");
            ((FieldFrameBodyLYR)this.frameBody).addLyric((FrameBodyUSLT)frame.getBody());
        } else if (frameIdentifier.startsWith("SYLT")) {
            this.frameBody = new FieldFrameBodyLYR("");
            ((FieldFrameBodyLYR)this.frameBody).addLyric((FrameBodySYLT)frame.getBody());
        } else if (frameIdentifier.startsWith("COMM")) {
            String text = new String(((FrameBodyCOMM)frame.getBody()).getText());
            this.frameBody = new FieldFrameBodyINF(text);
        } else if (frameIdentifier.equals("TCOM")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            this.frameBody = new FieldFrameBodyAUT("");
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyAUT(textFrame.getText());
            }
        } else if (frameIdentifier.equals("TALB")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyEAL(textFrame.getText());
            }
        } else if (frameIdentifier.equals("TPE1")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyEAR(textFrame.getText());
            }
        } else if (frameIdentifier.equals("TIT2")) {
            AbstractFrameBodyTextInfo textFrame = (AbstractFrameBodyTextInfo)frame.getBody();
            if (textFrame != null && textFrame.getText().length() > 0) {
                this.frameBody = new FieldFrameBodyETT(textFrame.getText());
            }
        } else {
            throw new TagException("Cannot create Lyrics3v2 field from given ID3v2 frame");
        }
    }

    public Lyrics3v2Field(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    public String getIdentifier() {
        if (this.frameBody == null) {
            return "";
        }
        return this.frameBody.getIdentifier();
    }

    public int getSize() {
        return this.frameBody.getSize() + 5 + this.getIdentifier().length();
    }

    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte b;
        byte[] buffer = new byte[6];
        while ((b = byteBuffer.get()) == 0) {
        }
        byteBuffer.position(byteBuffer.position() - 1);
        byteBuffer.get(buffer, 0, 3);
        String identifier = new String(buffer, 0, 3);
        if (!Lyrics3v2Fields.isLyrics3v2FieldIdentifier(identifier)) {
            throw new InvalidTagException(String.valueOf(identifier) + " is not a valid ID3v2.4 frame");
        }
        this.frameBody = this.readBody(identifier, byteBuffer);
    }

    public String toString() {
        if (this.frameBody == null) {
            return "";
        }
        return this.frameBody.toString();
    }

    public void write(RandomAccessFile file) throws IOException {
        if (((AbstractLyrics3v2FieldFrameBody)this.frameBody).getSize() > 0 || TagOptionSingleton.getInstance().isLyrics3SaveEmptyField()) {
            byte[] buffer = new byte[3];
            String str = this.getIdentifier();
            int i = 0;
            while (i < str.length()) {
                buffer[i] = (byte)str.charAt(i);
                ++i;
            }
            file.write(buffer, 0, str.length());
        }
    }

    private AbstractLyrics3v2FieldFrameBody readBody(String identifier, ByteBuffer byteBuffer) throws InvalidTagException {
        AbstractLyrics3v2FieldFrameBody newBody = null;
        newBody = identifier.equals("AUT") ? new FieldFrameBodyAUT(byteBuffer) : (identifier.equals("EAL") ? new FieldFrameBodyEAL(byteBuffer) : (identifier.equals("EAR") ? new FieldFrameBodyEAR(byteBuffer) : (identifier.equals("ETT") ? new FieldFrameBodyETT(byteBuffer) : (identifier.equals("IMG") ? new FieldFrameBodyIMG(byteBuffer) : (identifier.equals("IND") ? new FieldFrameBodyIND(byteBuffer) : (identifier.equals("INF") ? new FieldFrameBodyINF(byteBuffer) : (identifier.equals("LYR") ? new FieldFrameBodyLYR(byteBuffer) : new FieldFrameBodyUnsupported(byteBuffer))))))));
        return newBody;
    }
}

