/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jaudiotagger.audio.generic.AbstractTagCreator;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class VorbisCommentCreator
extends AbstractTagCreator {
    public ByteBuffer convert(Tag tag, int padding) throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String vendorString = ((VorbisCommentTag)tag).getVendor();
            int vendorLength = Utils.getUTF8Bytes(vendorString).length;
            baos.write(Utils.getSizeLittleEndian(vendorLength));
            baos.write(Utils.getUTF8Bytes(vendorString));
            int listLength = tag.getFieldCount() - 1;
            baos.write(Utils.getSizeLittleEndian(listLength));
            Iterator it = tag.getFields();
            while (it.hasNext()) {
                TagField frame = (TagField)it.next();
                if (frame.getId().equals(VorbisCommentFieldKey.VENDOR.name()) || frame.isEmpty()) continue;
                baos.write(frame.getRawContent());
            }
            ByteBuffer buf = ByteBuffer.wrap(baos.toByteArray());
            buf.rewind();
            return buf;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

