/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.concurrent.AsyncValueFuture;
import org.limewire.concurrent.RunnableAsyncFuture;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncFutureTask<V>
extends AsyncValueFuture<V>
implements RunnableAsyncFuture<V> {
    private static Callable<Object> NOP = new Callable<Object>(){

        @Override
        public Object call() {
            throw new UnsupportedOperationException("Override doRun()");
        }
    };
    private final AtomicReference<Interruptible> thread = new AtomicReference<Interruptible>(Interruptible.INIT);
    private final Callable<V> callable;

    public AsyncFutureTask() {
        this(NOP);
    }

    public AsyncFutureTask(Runnable runnable, V v) {
        this(Executors.callable(runnable, v));
    }

    public AsyncFutureTask(Callable<V> callable) {
        this.callable = Objects.nonNull(callable, "callable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (this.preRun()) {
            try {
                this.doRun();
            }
            catch (Throwable throwable) {
                this.uncaughtException(throwable);
            }
            finally {
                this.postRun();
            }
        }
    }

    private boolean preRun() {
        return this.thread.compareAndSet(Interruptible.INIT, new CurrentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRun() {
        AtomicReference<Interruptible> atomicReference = this.thread;
        synchronized (atomicReference) {
            this.thread.set(Interruptible.DONE);
        }
    }

    protected void doRun() throws Exception {
        V v = this.callable.call();
        this.setValue(v);
    }

    protected void uncaughtException(Throwable throwable) {
        this.setException(throwable);
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            ExceptionUtils.reportOrReturn(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = super.cancel(bl);
        if (bl2 && bl) {
            AtomicReference<Interruptible> atomicReference = this.thread;
            synchronized (atomicReference) {
                this.thread.getAndSet(Interruptible.DONE).interrupt();
            }
        }
        return bl2;
    }

    private static class CurrentThread
    implements Interruptible {
        private final Thread currentThread = Thread.currentThread();

        private CurrentThread() {
        }

        public void interrupt() {
            this.currentThread.interrupt();
        }
    }

    private static interface Interruptible {
        public static final Interruptible INIT = new Interruptible(){

            public void interrupt() {
            }
        };
        public static final Interruptible DONE = new Interruptible(){

            public void interrupt() {
            }
        };

        public void interrupt();
    }
}

