/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.AsyncFuture;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.listener.EventListener;
import org.limewire.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncValueFuture<V>
implements AsyncFuture<V> {
    private final List<EventListener<FutureEvent<V>>> listeners = new ArrayList<EventListener<FutureEvent<V>>>();
    private final OnewayExchanger<V, ExecutionException> exchanger = new OnewayExchanger(this, true);

    public AsyncValueFuture() {
    }

    public AsyncValueFuture(V v) {
        this.setValue(v);
    }

    public AsyncValueFuture(Throwable throwable) {
        this.setException(throwable);
    }

    @Override
    public boolean setValue(V v) {
        boolean bl = this.exchanger.setValue(v);
        if (bl) {
            this.complete();
        }
        return bl;
    }

    @Override
    public boolean setException(Throwable throwable) {
        boolean bl = this.exchanger.setException(AsyncValueFuture.wrap(throwable));
        if (bl) {
            this.complete();
        }
        return bl;
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = this.exchanger.cancel();
        if (bl2) {
            this.complete();
        }
        return bl2;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.checkIfEventThread();
        return this.exchanger.get();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkIfEventThread();
        return this.exchanger.get(l, timeUnit);
    }

    @Override
    public boolean isCancelled() {
        return this.exchanger.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.exchanger.isDone();
    }

    @Override
    public boolean isCompletedAbnormally() {
        return this.exchanger.throwsException();
    }

    private void complete() {
        this.fireOperationComplete();
        this.done();
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFutureListener(EventListener<FutureEvent<V>> eventListener) {
        Objects.nonNull(eventListener, "listener");
        boolean bl = false;
        AsyncValueFuture asyncValueFuture = this;
        synchronized (asyncValueFuture) {
            bl = this.isDone();
            if (!bl) {
                this.listeners.add(eventListener);
            }
        }
        if (bl) {
            this.fireOperationComplete(eventListener);
        }
    }

    protected boolean isEventThread() {
        return false;
    }

    private void checkIfEventThread() {
        if (!this.isDone() && this.isEventThread()) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOperationComplete() {
        FutureEvent futureEvent = null;
        EventListener[] eventListenerArray = null;
        AsyncValueFuture asyncValueFuture = this;
        synchronized (asyncValueFuture) {
            if (!this.listeners.isEmpty()) {
                futureEvent = FutureEvent.createEvent(this);
                eventListenerArray = this.listeners.toArray(new EventListener[0]);
            }
        }
        if (eventListenerArray != null) {
            this.fireOperationComplete(eventListenerArray, futureEvent);
        }
    }

    private void fireOperationComplete(EventListener<FutureEvent<V>> eventListener) {
        FutureEvent futureEvent = FutureEvent.createEvent(this);
        this.fireOperationComplete(new EventListener[]{eventListener}, futureEvent);
    }

    protected void fireOperationComplete(EventListener<FutureEvent<V>>[] eventListenerArray, FutureEvent<V> futureEvent) {
        for (EventListener<FutureEvent<V>> eventListener : eventListenerArray) {
            eventListener.handleEvent(futureEvent);
        }
    }

    private static ExecutionException wrap(Throwable throwable) {
        if (throwable instanceof ExecutionException) {
            return (ExecutionException)throwable;
        }
        return new ExecutionException(throwable);
    }
}

