/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFuture<T>
implements ListeningFuture<T> {
    private final T t;
    private final ExecutionException exception;
    private final EventListenerList.EventListenerListContext context = new EventListenerList.EventListenerListContext();

    public SimpleFuture(T t) {
        this.t = t;
        this.exception = null;
    }

    public SimpleFuture(Throwable throwable) {
        this.t = null;
        this.exception = new ExecutionException(throwable);
    }

    public SimpleFuture(ExecutionException executionException) {
        this.t = null;
        this.exception = executionException;
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public T get() throws ExecutionException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.t;
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws ExecutionException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.t;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public void addFutureListener(EventListener<FutureEvent<T>> eventListener) {
        EventListenerList.dispatch(eventListener, FutureEvent.createEvent(this), this.context);
    }
}

