/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BEncoder {
    public static final byte I;
    public static final byte D;
    public static final byte L;
    public static final byte E;
    public static final byte TRUE;
    public static final byte FALSE;
    public static final byte COLON;
    private static final String ASCII = "ISO-8859-1";
    private final boolean fail;
    private final boolean bool;
    private final String encoding;
    private final OutputStream output;

    private BEncoder(OutputStream outputStream, boolean bl, boolean bl2, String string) {
        this.fail = bl;
        this.encoding = string;
        this.output = outputStream;
        this.bool = bl2;
    }

    public static BEncoder getEncoder(OutputStream outputStream) {
        return new BEncoder(outputStream, false, true, ASCII);
    }

    public static BEncoder getEncoder(OutputStream outputStream, boolean bl, boolean bl2, String string) {
        return new BEncoder(outputStream, bl, bl2, string);
    }

    public void encodeByteArray(byte[] byArray) throws IOException {
        String string = String.valueOf(byArray.length);
        this.output.write(string.getBytes(ASCII));
        this.output.write(COLON);
        this.output.write(byArray);
    }

    public void encodeInt(Number number) throws IOException {
        String string = String.valueOf(number.longValue());
        this.output.write(I);
        this.output.write(string.getBytes(ASCII));
        this.output.write(E);
    }

    public void encodeList(Iterable<?> iterable) throws IOException {
        this.output.write(L);
        for (Object obj : iterable) {
            this.encode(obj);
        }
        this.output.write(E);
    }

    public void encodeDict(Map<?, ?> map) throws IOException {
        TreeMap treeMap = new TreeMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            treeMap.put(entry.getKey().toString(), entry.getValue());
        }
        this.output.write(D);
        for (Map.Entry<Object, Object> entry : treeMap.entrySet()) {
            if (BEncoder.isValidType(entry.getKey()) && BEncoder.isValidType(entry.getValue())) {
                this.encodeByteArray(((String)entry.getKey()).getBytes(this.encoding));
                this.encode(entry.getValue());
                continue;
            }
            if (!this.fail) continue;
            throw new IllegalArgumentException();
        }
        this.output.write(E);
    }

    private void encode(Object object) throws IOException {
        if (object instanceof Map) {
            this.encodeDict((Map)object);
        } else if (object instanceof Iterable) {
            this.encodeList((Iterable)object);
        } else if (object instanceof Number) {
            this.encodeInt((Number)object);
        } else if (object instanceof String) {
            this.encodeByteArray(((String)object).getBytes(this.encoding));
        } else if (object instanceof byte[]) {
            this.encodeByteArray((byte[])object);
        } else if (object instanceof Boolean) {
            this.encodeBoolean((Boolean)object);
        } else if (this.fail) {
            throw new IllegalArgumentException();
        }
    }

    public void encodeBoolean(boolean bl) throws IOException {
        if (this.bool) {
            this.output.write(bl ? TRUE : FALSE);
        } else {
            this.encodeInt(bl ? 1 : 0);
        }
    }

    private static boolean isValidType(Object object) {
        return object instanceof Map || object instanceof List || object instanceof Number || object instanceof String || object instanceof byte[] || object instanceof Boolean;
    }

    static {
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        try {
            by = "i".getBytes(ASCII)[0];
            by2 = "d".getBytes(ASCII)[0];
            by3 = "l".getBytes(ASCII)[0];
            by4 = "e".getBytes(ASCII)[0];
            by5 = ":".getBytes(ASCII)[0];
            by6 = "t".getBytes(ASCII)[0];
            by7 = "f".getBytes(ASCII)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        COLON = by5;
        I = by;
        D = by2;
        L = by3;
        E = by4;
        TRUE = by6;
        FALSE = by7;
    }
}

