/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import java.security.AccessController;
import java.security.PrivilegedAction;

class JREVersion {
    private static Boolean jre141;
    private static Boolean jre140;
    private static Boolean jre13;
    private static Boolean jre12;

    JREVersion() {
    }

    static boolean isJRE141() {
        if (jre141 == null) {
            Class cls = JREVersion.loadClass("java.awt.SequencedEvent");
            jre141 = cls == null ? Boolean.FALSE : JREVersion.hasGetFirst(cls);
        }
        return jre141;
    }

    static boolean isJRE140() {
        if (jre140 == null) {
            Class cls = JREVersion.loadClass("java.awt.SequencedEvent");
            jre140 = cls == null ? Boolean.FALSE : (JREVersion.hasGetFirst(cls) != false ? Boolean.FALSE : Boolean.TRUE);
        }
        return jre140;
    }

    static boolean isJRE13() {
        if (jre13 == null) {
            jre13 = JREVersion.loadClass("java.lang.reflect.Proxy") == null ? Boolean.FALSE : Boolean.TRUE;
        }
        return jre13;
    }

    static boolean isJRE12() {
        if (jre12 == null) {
            jre12 = JREVersion.loadClass("java.util.Collection") == null ? Boolean.FALSE : Boolean.TRUE;
        }
        return jre12;
    }

    private static Class loadClass(String className) {
        try {
            return Class.forName(className, false, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Boolean hasGetFirst(final Class cls) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    cls.getDeclaredMethod("getFirst", null);
                    return Boolean.TRUE;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        });
    }
}

