/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.http.DispatchedIOReactor;
import org.limewire.http.HttpChannel;
import org.limewire.http.HttpIOSession;
import org.limewire.io.IOUtils;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.ThrottleWriter;

public class HttpIOReactor
implements DispatchedIOReactor {
    public static final String IO_SESSION_KEY = "org.limewire.iosession";
    private static final Log LOG = LogFactory.getLog(HttpIOReactor.class);
    private final HttpParams params;
    protected volatile IOEventDispatch eventDispatch = null;
    private static final String NHTTP_CONN = "NHTTP_CONN";

    public HttpIOReactor(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException();
        }
        this.params = httpParams;
    }

    public void execute(IOEventDispatch iOEventDispatch) throws IOException {
        if (!(iOEventDispatch instanceof DefaultServerIOEventDispatch)) {
            throw new IllegalArgumentException("Event dispatch must be of type DefaultServerIOEventDispatch");
        }
        this.eventDispatch = iOEventDispatch;
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)this.params));
        int n = HttpConnectionParams.getLinger((HttpParams)this.params);
        if (n >= 0) {
            socket.setSoLinger(n > 0, n);
        }
    }

    protected NHttpConnection connectSocket(AbstractNBSocket abstractNBSocket, Object object, String string) {
        try {
            HttpIOSession httpIOSession = new HttpIOSession(abstractNBSocket);
            httpIOSession.setAttribute("http.session.attachment", object);
            httpIOSession.setSocketTimeout(HttpConnectionParams.getSoTimeout((HttpParams)this.params));
            HttpChannel httpChannel = new HttpChannel(httpIOSession, this.eventDispatch, string);
            httpIOSession.setHttpChannel(httpChannel);
            ThrottleWriter throttleWriter = new ThrottleWriter(null);
            httpIOSession.setThrottleChannel(throttleWriter);
            httpChannel.setWriteChannel((InterestWritableByteChannel)throttleWriter);
            this.eventDispatch.connected((IOSession)httpIOSession);
            NHttpConnection nHttpConnection = (NHttpConnection)httpIOSession.getAttribute("http.connection");
            assert (nHttpConnection != null);
            nHttpConnection.getContext().setAttribute(IO_SESSION_KEY, (Object)httpIOSession);
            abstractNBSocket.setReadObserver((ChannelReadObserver)httpChannel);
            abstractNBSocket.setWriteObserver((ChannelWriter)httpChannel);
            return nHttpConnection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public NHttpConnection acceptConnection(String string, Socket socket) {
        try {
            this.prepareSocket(socket);
            return this.connectSocket((AbstractNBSocket)socket, null, string);
        }
        catch (IOException iOException) {
            LOG.info((Object)"Closing socket due to unexpected exception", (Throwable)iOException);
            IOUtils.close((Socket)socket);
            return null;
        }
    }

    public IOReactorStatus getStatus() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void shutdown(long l) throws IOException {
        throw new UnsupportedOperationException();
    }
}

