/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.entity.ContentOutputStream;
import org.apache.http.nio.protocol.AsyncNHttpServiceHandler;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.nio.protocol.NHttpResponseTrigger;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.EncodingUtils;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.http.AsyncHttpRequestHandler;
import org.limewire.http.HttpNIOEntity;
import org.limewire.http.HttpServiceEventListener;
import org.limewire.nio.NIODispatcher;

public class HttpServiceHandler
extends AsyncNHttpServiceHandler
implements NHttpServiceHandler {
    private static final Log LOG = LogFactory.getLog(HttpServiceHandler.class);
    private ExecutorService executor = ExecutorsHelper.newProcessingQueue((String)"HttpServiceHandler");

    public HttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, ByteBufferAllocator byteBufferAllocator, HttpParams httpParams) {
        super(httpProcessor, httpResponseFactory, connectionReuseStrategy, byteBufferAllocator, httpParams);
    }

    public HttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory httpResponseFactory, ConnectionReuseStrategy connectionReuseStrategy, HttpParams httpParams) {
        this(httpProcessor, httpResponseFactory, connectionReuseStrategy, (ByteBufferAllocator)new HeapByteBufferAllocator(), httpParams);
    }

    public void setEventListener(HttpServiceEventListener httpServiceEventListener) {
        this.eventListener = httpServiceEventListener;
    }

    public void connected(NHttpServerConnection nHttpServerConnection) {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = new ServerConnState(this.allocator);
        httpContext.setAttribute("http.nio.conn-state", (Object)serverConnState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen((NHttpConnection)nHttpServerConnection);
        }
    }

    public void requestReceived(NHttpServerConnection nHttpServerConnection) {
        block12: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            HttpRequest httpRequest = nHttpServerConnection.getHttpRequest();
            httpRequest.setParams(this.params);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received request: " + httpRequest.getRequestLine()));
            }
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            serverConnState.resetInput();
            serverConnState.setRequest(httpRequest);
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            if (!protocolVersion.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                protocolVersion = HttpVersion.HTTP_1_1;
            }
            try {
                if (httpRequest instanceof HttpEntityEnclosingRequest) {
                    if (!((HttpEntityEnclosingRequest)httpRequest).expectContinue()) break block12;
                    HttpResponse httpResponse = this.responseFactory.newHttpResponse(protocolVersion, 100, httpContext);
                    httpResponse.setParams(this.params);
                    if (this.expectationVerifier != null) {
                        try {
                            this.expectationVerifier.verify(httpRequest, httpResponse, httpContext);
                        }
                        catch (HttpException httpException) {
                            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, httpContext);
                            httpResponse.setParams(this.params);
                            this.handleException(httpException, httpResponse);
                        }
                    }
                    if (httpResponse.getStatusLine().getStatusCode() < 200) {
                        nHttpServerConnection.submitResponse(httpResponse);
                    } else {
                        nHttpServerConnection.resetInput();
                        serverConnState.resetInput();
                        this.sendResponse(nHttpServerConnection, httpResponse);
                    }
                    break block12;
                }
                nHttpServerConnection.suspendInput();
                this.processRequest(nHttpServerConnection, httpRequest);
            }
            catch (IOException iOException) {
                this.shutdownConnection((NHttpConnection)nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, (NHttpConnection)nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection((NHttpConnection)nHttpServerConnection, httpException);
                if (this.eventListener == null) break block12;
                this.eventListener.fatalProtocolException(httpException, (NHttpConnection)nHttpServerConnection);
            }
        }
    }

    public void closed(NHttpServerConnection nHttpServerConnection) {
        ServerConnState serverConnState = (ServerConnState)nHttpServerConnection.getContext().getAttribute("http.nio.conn-state");
        serverConnState.resetOutput();
        this.notifyResponseSent(nHttpServerConnection);
        if (this.eventListener != null) {
            this.eventListener.connectionClosed((NHttpConnection)nHttpServerConnection);
        }
    }

    public void exception(NHttpServerConnection nHttpServerConnection, HttpException httpException) {
        block4: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            try {
                HttpResponse httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, httpContext);
                httpResponse.setParams(this.params);
                this.handleException(httpException, httpResponse);
                httpResponse.setEntity(null);
                this.sendResponse(nHttpServerConnection, httpResponse);
            }
            catch (IOException iOException) {
                this.shutdownConnection((NHttpConnection)nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, (NHttpConnection)nHttpServerConnection);
                }
            }
            catch (HttpException httpException2) {
                this.closeConnection((NHttpConnection)nHttpServerConnection, httpException2);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalProtocolException(httpException2, (NHttpConnection)nHttpServerConnection);
            }
        }
    }

    public void inputReady(NHttpServerConnection nHttpServerConnection, ContentDecoder contentDecoder) {
        block6: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            HttpRequest httpRequest = nHttpServerConnection.getHttpRequest();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            ContentInputBuffer contentInputBuffer = serverConnState.getInbuffer();
            try {
                contentInputBuffer.consumeContent(contentDecoder);
                if (contentDecoder.isCompleted()) {
                    HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest;
                    if (httpEntityEnclosingRequest.getEntity() != null) {
                        httpEntityEnclosingRequest.setEntity((HttpEntity)new ContentBufferEntity(httpEntityEnclosingRequest.getEntity(), serverConnState.getInbuffer()));
                    }
                    nHttpServerConnection.suspendInput();
                    this.processRequest(nHttpServerConnection, httpRequest);
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection((NHttpConnection)nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, (NHttpConnection)nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.closeConnection((NHttpConnection)nHttpServerConnection, httpException);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalProtocolException(httpException, (NHttpConnection)nHttpServerConnection);
            }
        }
    }

    public void responseReady(NHttpServerConnection nHttpServerConnection) {
        this.notifyResponseSent(nHttpServerConnection);
        if (nHttpServerConnection.isOpen()) {
            LOG.debug((Object)"Response sent, ready to receive next request");
            nHttpServerConnection.requestInput();
            if (((DefaultNHttpServerConnection)nHttpServerConnection).hasBufferedInput()) {
                LOG.debug((Object)"Handling buffered requests");
                ((DefaultNHttpServerConnection)nHttpServerConnection).consumeInput((NHttpServiceHandler)this);
            }
        }
    }

    public void outputReady(NHttpServerConnection nHttpServerConnection, ContentEncoder contentEncoder) {
        block6: {
            HttpContext httpContext = nHttpServerConnection.getContext();
            ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
            ContentOutputBuffer contentOutputBuffer = serverConnState.getOutbuffer();
            try {
                HttpNIOEntity httpNIOEntity = serverConnState.getEntity();
                if (httpNIOEntity != null) {
                    httpNIOEntity.produceContent(contentEncoder, (IOControl)nHttpServerConnection);
                } else {
                    contentOutputBuffer.produceContent(contentEncoder);
                }
                if (contentEncoder.isCompleted()) {
                    serverConnState.resetOutput();
                    if (!this.connStrategy.keepAlive(nHttpServerConnection.getHttpResponse(), httpContext)) {
                        nHttpServerConnection.close();
                    }
                }
            }
            catch (IOException iOException) {
                this.shutdownConnection((NHttpConnection)nHttpServerConnection, iOException);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalIOException(iOException, (NHttpConnection)nHttpServerConnection);
            }
        }
    }

    protected void closeConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        ServerConnState serverConnState = (ServerConnState)((NHttpServerConnection)nHttpConnection).getContext().getAttribute("http.nio.conn-state");
        serverConnState.resetOutput();
        super.closeConnection(nHttpConnection, throwable);
    }

    protected void shutdownConnection(NHttpConnection nHttpConnection, Throwable throwable) {
        ServerConnState serverConnState = (ServerConnState)((NHttpServerConnection)nHttpConnection).getContext().getAttribute("http.nio.conn-state");
        serverConnState.resetOutput();
        super.shutdownConnection(nHttpConnection, throwable);
    }

    private void handleException(HttpException httpException, HttpResponse httpResponse) {
        int n = 500;
        if (httpException instanceof MethodNotSupportedException) {
            n = 501;
        } else if (httpException instanceof UnsupportedHttpVersionException) {
            n = 505;
        } else if (httpException instanceof ProtocolException) {
            n = 400;
        }
        httpResponse.setStatusCode(n);
        byte[] byArray = EncodingUtils.getAsciiBytes((String)httpException.getMessage());
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(byArray);
        byteArrayEntity.setContentType("text/plain; charset=US-ASCII");
        httpResponse.setEntity((HttpEntity)byteArrayEntity);
    }

    private void processRequest(final NHttpServerConnection nHttpServerConnection, HttpRequest httpRequest) throws IOException, HttpException {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
        if (!protocolVersion.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
            protocolVersion = HttpVersion.HTTP_1_1;
        }
        HttpResponse httpResponse = this.responseFactory.newHttpResponse(protocolVersion, 200, nHttpServerConnection.getContext());
        httpResponse.setParams(this.params);
        httpContext.setAttribute("http.request", (Object)httpRequest);
        httpContext.setAttribute("http.connection", (Object)nHttpServerConnection);
        httpContext.setAttribute("http.response", (Object)httpResponse);
        try {
            Object object;
            this.httpProcessor.process(httpRequest, httpContext);
            this.notifyRequestReceived(nHttpServerConnection);
            NHttpRequestHandler nHttpRequestHandler = null;
            if (this.handlerResolver != null) {
                object = httpRequest.getRequestLine().getUri();
                nHttpRequestHandler = this.handlerResolver.lookup((String)object);
            }
            if (nHttpRequestHandler != null) {
                if (nHttpRequestHandler instanceof AsyncHttpRequestHandler) {
                    this.processAsyncRequest(nHttpServerConnection, nHttpRequestHandler, httpRequest, httpResponse, httpContext);
                    return;
                }
                object = new NHttpResponseTrigger(){

                    public void handleException(HttpException httpException) {
                    }

                    public void handleException(IOException iOException) {
                    }

                    public void submitResponse(HttpResponse httpResponse) {
                        HttpServiceHandler.this.sendAsyncResponse(nHttpServerConnection, httpResponse);
                    }
                };
                nHttpRequestHandler.handle(httpRequest, httpResponse, (NHttpResponseTrigger)object, httpContext);
            } else {
                httpResponse.setStatusCode(501);
            }
        }
        catch (HttpException httpException) {
            httpResponse = this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, httpContext);
            httpResponse.setParams(this.params);
            this.handleException(httpException, httpResponse);
        }
    }

    private void processAsyncRequest(final NHttpServerConnection nHttpServerConnection, final NHttpRequestHandler nHttpRequestHandler, final HttpRequest httpRequest, final HttpResponse httpResponse, final HttpContext httpContext) {
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    NHttpResponseTrigger nHttpResponseTrigger = new NHttpResponseTrigger(){

                        public void handleException(HttpException httpException) {
                        }

                        public void handleException(IOException iOException) {
                        }

                        public void submitResponse(HttpResponse httpResponse) {
                            HttpServiceHandler.this.sendAsyncResponse(nHttpServerConnection, httpResponse);
                        }
                    };
                    nHttpRequestHandler.handle(httpRequest, httpResponse, nHttpResponseTrigger, httpContext);
                }
                catch (HttpException httpException) {
                    NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                        public void run() {
                            HttpResponse httpResponse = HttpServiceHandler.this.responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, httpContext);
                            httpResponse.setParams(HttpServiceHandler.this.params);
                            HttpServiceHandler.this.handleException(httpException, httpResponse);
                            HttpServiceHandler.this.sendAsyncResponse(nHttpServerConnection, httpResponse);
                        }
                    });
                }
                catch (IOException iOException) {
                    NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                        public void run() {
                            HttpServiceHandler.this.shutdownConnection((NHttpConnection)nHttpServerConnection, iOException);
                            if (HttpServiceHandler.this.eventListener != null) {
                                HttpServiceHandler.this.eventListener.fatalIOException(iOException, (NHttpConnection)nHttpServerConnection);
                            }
                        }
                    });
                }
            }
        });
    }

    private void sendAsyncResponse(NHttpServerConnection nHttpServerConnection, HttpResponse httpResponse) {
        block4: {
            try {
                this.sendResponse(nHttpServerConnection, httpResponse);
            }
            catch (IOException iOException) {
                this.shutdownConnection((NHttpConnection)nHttpServerConnection, iOException);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(iOException, (NHttpConnection)nHttpServerConnection);
                }
            }
            catch (HttpException httpException) {
                this.shutdownConnection((NHttpConnection)nHttpServerConnection, httpException);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalProtocolException(httpException, (NHttpConnection)nHttpServerConnection);
            }
        }
    }

    private void sendResponse(NHttpServerConnection nHttpServerConnection, HttpResponse httpResponse) throws IOException, HttpException {
        HttpContext httpContext = nHttpServerConnection.getContext();
        ServerConnState serverConnState = (ServerConnState)httpContext.getAttribute("http.nio.conn-state");
        ContentOutputBuffer contentOutputBuffer = serverConnState.getOutbuffer();
        this.httpProcessor.process(httpResponse, httpContext);
        if (!this.canResponseHaveBody(serverConnState.getRequest(), httpResponse)) {
            httpResponse.setEntity(null);
        }
        serverConnState.setResponse(httpResponse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Sending response: " + httpResponse.getStatusLine()));
        }
        nHttpServerConnection.submitResponse(httpResponse);
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            if (httpEntity instanceof HttpNIOEntity) {
                serverConnState.setEntity((HttpNIOEntity)httpEntity);
            } else {
                ContentOutputStream contentOutputStream = new ContentOutputStream(contentOutputBuffer);
                httpEntity.writeTo((OutputStream)contentOutputStream);
                contentOutputStream.flush();
                contentOutputStream.close();
            }
        } else {
            serverConnState.resetOutput();
            if (!this.connStrategy.keepAlive(httpResponse, httpContext)) {
                nHttpServerConnection.close();
            }
        }
    }

    private void notifyRequestReceived(NHttpServerConnection nHttpServerConnection) {
        if (this.eventListener instanceof HttpServiceEventListener) {
            ((HttpServiceEventListener)this.eventListener).requestReceived((NHttpConnection)nHttpServerConnection, nHttpServerConnection.getHttpRequest());
        }
    }

    private void notifyResponseSent(NHttpServerConnection nHttpServerConnection) {
        HttpResponse httpResponse;
        ServerConnState serverConnState = (ServerConnState)nHttpServerConnection.getContext().getAttribute("http.nio.conn-state");
        if (this.eventListener instanceof HttpServiceEventListener && (httpResponse = serverConnState.getResponse()) != null) {
            ((HttpServiceEventListener)this.eventListener).responseSent((NHttpConnection)nHttpServerConnection, httpResponse);
        }
        serverConnState.setResponse(null);
    }

    static class ServerConnState {
        private ContentInputBuffer inbuffer;
        private ContentOutputBuffer outbuffer;
        private HttpRequest request;
        private final ByteBufferAllocator allocator;
        private HttpResponse response;
        private volatile HttpNIOEntity entity;

        public ServerConnState(ByteBufferAllocator byteBufferAllocator) {
            this.allocator = byteBufferAllocator;
        }

        public ContentInputBuffer getInbuffer() {
            if (this.inbuffer == null) {
                this.inbuffer = new SimpleInputBuffer(2048, this.allocator);
            }
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            if (this.outbuffer == null) {
                this.outbuffer = new SimpleOutputBuffer(2048, this.allocator);
            }
            return this.outbuffer;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest httpRequest) {
            this.request = httpRequest;
        }

        public void resetInput() {
            this.inbuffer = null;
            this.request = null;
        }

        public void resetOutput() {
            this.outbuffer = null;
            if (this.entity != null) {
                this.entity.finished();
                this.entity = null;
            }
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse httpResponse) {
            this.response = httpResponse;
        }

        public HttpNIOEntity getEntity() {
            return this.entity;
        }

        public void setEntity(HttpNIOEntity httpNIOEntity) {
            this.entity = httpNIOEntity;
        }
    }
}

