/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import com.google.inject.Provider;
import java.net.Socket;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.limewire.http.SocketWrapperProtocolSocketFactory;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReapingClientConnectionManager
extends ThreadSafeClientConnManager {
    protected final ScheduledFuture connectionCloserTask;
    protected final IdleConnectionCloser connectionCloser = new IdleConnectionCloser();

    public ReapingClientConnectionManager(Provider<SchemeRegistry> provider, Provider<ScheduledExecutorService> provider2, Provider<HttpParams> provider3) {
        super((HttpParams)provider3.get(), (SchemeRegistry)provider.get());
        this.connectionCloserTask = ((ScheduledExecutorService)provider2.get()).scheduleAtFixedRate(this.connectionCloser, 0L, 10L, TimeUnit.SECONDS);
    }

    public ClientConnectionRequest requestConnection(HttpRoute httpRoute, Object object) {
        this.connectionCloser.setManagerOnce((ClientConnectionManager)this);
        return super.requestConnection(httpRoute, object);
    }

    public void shutdown() {
        this.connectionCloserTask.cancel(true);
        super.shutdown();
    }

    void setSocket(Socket socket) {
        SchemeRegistry schemeRegistry = this.getSchemeRegistry();
        Iterator iterator = schemeRegistry.getSchemeNames().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            Scheme scheme = schemeRegistry.getScheme(string2);
            ((SocketWrapperProtocolSocketFactory)scheme.getSocketFactory()).setSocket(socket);
        }
    }

    private static class IdleConnectionCloser
    implements Runnable {
        private static final long IDLE_TIME = 30000L;
        private final AtomicReference<ClientConnectionManager> managerHolder = new AtomicReference();

        IdleConnectionCloser() {
        }

        void setManagerOnce(ClientConnectionManager clientConnectionManager) {
            this.managerHolder.compareAndSet(null, clientConnectionManager);
        }

        public void run() {
            try {
                ClientConnectionManager clientConnectionManager = this.managerHolder.get();
                if (clientConnectionManager != null) {
                    clientConnectionManager.closeIdleConnections(30000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable throwable) {
                ErrorService.error((Throwable)throwable);
            }
        }
    }
}

