/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTValueFuture;
import org.limewire.mojito.concurrent.DefaultDHTExecutorService;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueFactoryManager;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.db.DatabaseCleaner;
import org.limewire.mojito.db.EvictorManager;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModelManager;
import org.limewire.mojito.db.StorablePublisher;
import org.limewire.mojito.db.impl.DatabaseImpl;
import org.limewire.mojito.exceptions.NotBootstrappedException;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.io.MessageDispatcherFactory;
import org.limewire.mojito.io.MessageDispatcherFactoryImpl;
import org.limewire.mojito.manager.BootstrapManager;
import org.limewire.mojito.manager.FindNodeManager;
import org.limewire.mojito.manager.FindValueManager;
import org.limewire.mojito.manager.GetValueManager;
import org.limewire.mojito.manager.PingManager;
import org.limewire.mojito.manager.StoreManager;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.MessageHelper;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.BucketRefresher;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.routing.impl.RouteTableImpl;
import org.limewire.mojito.security.SecurityTokenHelper;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.statistics.DHTStats;
import org.limewire.mojito.statistics.DHTStatsManager;
import org.limewire.mojito.statistics.DatabaseStatisticContainer;
import org.limewire.mojito.statistics.GlobalLookupStatisticContainer;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.mojito.statistics.RoutingStatisticContainer;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.CryptoUtils;
import org.limewire.mojito.util.DHTSizeEstimator;
import org.limewire.mojito.util.HostFilter;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements MojitoDHT,
RouteTable.ContactPinger {
    private static final Log LOG = LogFactory.getLog(Context.class);
    private final String name;
    private final StorablePublisher valuePublisher;
    private final DatabaseCleaner databaseCleaner;
    private volatile boolean bucketRefresherDisabled = false;
    private final BucketRefresher bucketRefresher;
    private final PingManager pingManager;
    private final FindNodeManager findNodeManager;
    private final FindValueManager findValueManager;
    private final StoreManager storeManager;
    private final BootstrapManager bootstrapManager;
    private final GetValueManager getValueManager;
    private final DHTStats stats;
    private final NetworkStatisticContainer networkStats;
    private final GlobalLookupStatisticContainer globalLookupStats;
    private final DatabaseStatisticContainer databaseStats;
    private volatile KeyPair keyPair;
    private volatile Database database;
    private volatile RouteTable routeTable;
    private volatile MessageDispatcher messageDispatcher;
    private volatile MessageHelper messageHelper;
    private volatile DHTSizeEstimator estimator;
    private volatile DHTExecutorService executorService;
    private volatile SecurityToken.TokenProvider tokenProvider;
    private volatile MACCalculatorRepositoryManager MACCalculatorRepositoryManager;
    private final SecurityTokenHelper tokenHelper;
    private final DHTValueFactoryManager factoryManager = new DHTValueFactoryManager();
    private final StorableModelManager publisherManager = new StorableModelManager();
    private final EvictorManager evictorManager = new EvictorManager();
    private volatile HostFilter hostFilter = null;

    Context(String string, Vendor vendor, Version version, boolean bl) {
        this.name = string;
        PublicKey publicKey = null;
        try {
            File file = new File(ContextSettings.MASTER_KEY.getValue());
            if (file.exists() && file.isFile()) {
                publicKey = CryptoUtils.loadPublicKey(file);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            LOG.debug((Object)"InvalidKeyException", (Throwable)invalidKeyException);
        }
        catch (SignatureException signatureException) {
            LOG.debug((Object)"SignatureException", (Throwable)signatureException);
        }
        catch (IOException iOException) {
            LOG.debug((Object)"IOException", (Throwable)iOException);
        }
        this.keyPair = new KeyPair(publicKey, null);
        this.executorService = new DefaultDHTExecutorService(this.getName());
        this.MACCalculatorRepositoryManager = new MACCalculatorRepositoryManager();
        this.tokenProvider = new SecurityToken.AddressSecurityTokenProvider(this.MACCalculatorRepositoryManager);
        this.tokenHelper = new SecurityTokenHelper(this);
        this.setRouteTable(null);
        this.setDatabase(null, false);
        this.stats = DHTStatsManager.getInstance(this.getLocalNodeID());
        this.networkStats = new NetworkStatisticContainer(this.getLocalNodeID());
        this.globalLookupStats = new GlobalLookupStatisticContainer(this.getLocalNodeID());
        this.databaseStats = new DatabaseStatisticContainer(this.getLocalNodeID());
        this.setMessageDispatcher(null);
        this.messageHelper = new MessageHelper(this);
        this.valuePublisher = new StorablePublisher(this);
        this.databaseCleaner = new DatabaseCleaner(this);
        this.bucketRefresher = new BucketRefresher(this);
        this.pingManager = new PingManager(this);
        this.findNodeManager = new FindNodeManager(this);
        this.findValueManager = new FindValueManager(this);
        this.storeManager = new StoreManager(this);
        this.bootstrapManager = new BootstrapManager(this);
        this.getValueManager = new GetValueManager(this);
        this.getLocalNode().setVendor(vendor);
        this.getLocalNode().setVersion(version);
        this.getLocalNode().setFirewalled(bl);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DHTStats getDHTStats() {
        return this.stats;
    }

    @Override
    public Vendor getVendor() {
        return this.getLocalNode().getVendor();
    }

    @Override
    public Version getVersion() {
        return this.getLocalNode().getVersion();
    }

    public PublicKey getPublicKey() {
        KeyPair keyPair = this.keyPair;
        if (keyPair != null) {
            return keyPair.getPublic();
        }
        return null;
    }

    @Override
    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Override
    public void setKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    @Override
    public LocalContact getLocalNode() {
        return (LocalContact)this.getRouteTable().getLocalNode();
    }

    public void changeNodeID() {
        KUID kUID = KUID.createRandomID();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Changing local Node ID from " + this.getLocalNodeID() + " to " + kUID));
        }
        this.setLocalNodeID(kUID);
        this.purgeDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalNodeID(KUID kUID) {
        RouteTable routeTable;
        RouteTable routeTable2 = routeTable = this.getRouteTable();
        synchronized (routeTable2) {
            this.getLocalNode().setNodeID(kUID);
            routeTable.purge(RouteTable.PurgeMode.PURGE_CONTACTS, RouteTable.PurgeMode.MERGE_BUCKETS, RouteTable.PurgeMode.STATE_TO_UNKNOWN);
            assert (this.getLocalNode().equals(routeTable.get(kUID)));
        }
        this.getStorableModelManager().handleContactChange(this);
    }

    public boolean isLocalNode(Contact contact) {
        return contact.equals(this.getLocalNode());
    }

    public boolean isLocalNode(KUID kUID, SocketAddress socketAddress) {
        return this.isLocalNodeID(kUID) && this.isLocalContactAddress(socketAddress);
    }

    public boolean isLocalNodeID(KUID kUID) {
        return kUID != null && kUID.equals(this.getLocalNodeID());
    }

    public boolean isLocalContactAddress(SocketAddress socketAddress) {
        return this.getContactAddress().equals(socketAddress);
    }

    @Override
    public KUID getLocalNodeID() {
        return this.getLocalNode().getNodeID();
    }

    @Override
    public synchronized MessageDispatcher setMessageDispatcher(MessageDispatcherFactory messageDispatcherFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch MessageDispatcher while " + this.getName() + " is running");
        }
        if (messageDispatcherFactory == null) {
            messageDispatcherFactory = new MessageDispatcherFactoryImpl();
        }
        this.messageDispatcher = messageDispatcherFactory.create(this);
        this.messageDispatcher.addMessageDispatcherListener(new NetworkStatisticContainer.Listener(this.networkStats));
        return this.messageDispatcher;
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    @Override
    public synchronized void setRouteTable(RouteTable routeTable) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch RouteTable while " + this.getName() + " is running");
        }
        if (this.routeTable != null && this.routeTable == routeTable) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Cannot set the same instance multiple times");
            }
            return;
        }
        if (routeTable == null) {
            routeTable = new RouteTableImpl();
        }
        routeTable.setContactPinger(this);
        routeTable.setNotifier(this.getDHTExecutorService());
        routeTable.addRouteTableListener(new RoutingStatisticContainer.Listener());
        this.routeTable = routeTable;
        if (this.database != null) {
            this.purgeDatabase();
        }
    }

    @Override
    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    @Override
    public synchronized void setDatabase(Database database) {
        this.setDatabase(database, true);
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    private synchronized void setDatabase(Database database, boolean bl) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch Database while " + this.getName() + " is running");
        }
        if (this.database != null && this.database == database) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Cannot set the same instance multiple times");
            }
            return;
        }
        if (database == null) {
            database = new DatabaseImpl();
        }
        this.database = database;
        this.purgeDatabase();
    }

    private void purgeDatabase() {
        this.database.clear();
    }

    @Override
    public synchronized void setMessageFactory(MessageFactory messageFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch MessageFactory while " + this.getName() + " is running");
        }
        this.messageHelper.setMessageFactory(messageFactory);
    }

    public MessageFactory getMessageFactory() {
        return this.messageHelper.getMessageFactory();
    }

    public synchronized void setMessageHelper(MessageHelper messageHelper) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch MessageHelper while " + this.getName() + " is running");
        }
        this.messageHelper = messageHelper;
    }

    public MessageHelper getMessageHelper() {
        return this.messageHelper;
    }

    @Override
    public synchronized void setHostFilter(HostFilter hostFilter) {
        this.hostFilter = hostFilter;
    }

    @Override
    public HostFilter getHostFilter() {
        return this.hostFilter;
    }

    @Override
    public synchronized void setSecurityTokenProvider(SecurityToken.TokenProvider tokenProvider) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch TokenProvider while " + this.getName() + " is running");
        }
        this.tokenProvider = tokenProvider;
    }

    public SecurityToken.TokenProvider getSecurityTokenProvider() {
        return this.tokenProvider;
    }

    @Override
    public synchronized void setMACCalculatorRepositoryManager(MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot switch MACManager while " + this.getName() + " is running");
        }
        this.MACCalculatorRepositoryManager = mACCalculatorRepositoryManager;
    }

    public MACCalculatorRepositoryManager getMACCalculatorRepositoryManager() {
        return this.MACCalculatorRepositoryManager;
    }

    public SecurityTokenHelper getSecurityTokenHelper() {
        return this.tokenHelper;
    }

    @Override
    public void setExternalPort(int n) {
        this.getLocalNode().setExternalPort(n);
    }

    @Override
    public int getExternalPort() {
        return this.getLocalNode().getExternalPort();
    }

    @Override
    public SocketAddress getContactAddress() {
        return this.getLocalNode().getContactAddress();
    }

    public void setContactAddress(SocketAddress socketAddress) {
        this.getLocalNode().setContactAddress(socketAddress);
    }

    public void setExternalAddress(SocketAddress socketAddress) {
        boolean bl = this.getLocalNode().setExternalAddress(socketAddress);
        if (bl) {
            this.getStorableModelManager().handleContactChange(this);
        }
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.getLocalNode().getSourceAddress();
    }

    @Override
    public boolean isFirewalled() {
        return this.getLocalNode().isFirewalled();
    }

    @Override
    public void setDHTExecutorService(DHTExecutorService dHTExecutorService) {
        if (dHTExecutorService == null) {
            dHTExecutorService = new DefaultDHTExecutorService(this.getName());
        }
        this.executorService = dHTExecutorService;
        RouteTable routeTable = this.getRouteTable();
        if (routeTable != null) {
            routeTable.setNotifier(dHTExecutorService);
        }
    }

    @Override
    public DHTExecutorService getDHTExecutorService() {
        return this.executorService;
    }

    public synchronized void setBucketRefresherDisabled(boolean bl) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot disable BucketRefresher while " + this.getName() + " is running");
        }
        this.bucketRefresherDisabled = bl;
    }

    public boolean isBucketRefresherDisabled() {
        return this.bucketRefresherDisabled;
    }

    @Override
    public DHTValueFactoryManager getDHTValueFactoryManager() {
        return this.factoryManager;
    }

    @Override
    public StorableModelManager getStorableModelManager() {
        return this.publisherManager;
    }

    @Override
    public EvictorManager getEvictorManager() {
        return this.evictorManager;
    }

    @Override
    public boolean isRunning() {
        MessageDispatcher messageDispatcher = this.messageDispatcher;
        if (messageDispatcher != null) {
            return messageDispatcher.isRunning();
        }
        return false;
    }

    public BootstrapManager getBootstrapManager() {
        return this.bootstrapManager;
    }

    @Override
    public boolean isBootstrapping() {
        return this.isRunning() && this.bootstrapManager.isBootstrapping();
    }

    @Override
    public boolean isBootstrapped() {
        return this.isRunning() && this.bootstrapManager.isBootstrapped();
    }

    public synchronized void setBootstrapped(boolean bl) {
        this.bootstrapManager.setBootstrapped(bl);
    }

    @Override
    public boolean isBound() {
        MessageDispatcher messageDispatcher = this.messageDispatcher;
        if (messageDispatcher != null) {
            return messageDispatcher.isBound();
        }
        return false;
    }

    @Override
    public synchronized void bind(int n) throws IOException {
        this.bind(new InetSocketAddress(n));
    }

    @Override
    public synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        this.bind(new InetSocketAddress(inetAddress, n));
    }

    @Override
    public synchronized void bind(SocketAddress socketAddress) throws IOException {
        if (this.isBound()) {
            throw new IOException(this.getName() + " is already bound");
        }
        int n = ((InetSocketAddress)socketAddress).getPort();
        if (n == 0) {
            throw new IOException("Cannot bind Socket to Port " + n);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding " + this.getName() + " to address: " + socketAddress));
        }
        if (!this.isFirewalled() && this.getExternalPort() == 0) {
            this.setExternalPort(n);
        }
        this.getLocalNode().setSourceAddress(socketAddress);
        this.getLocalNode().nextInstanceID();
        this.messageDispatcher.bind(socketAddress);
    }

    @Override
    public synchronized void start() {
        if (!this.isBound()) {
            throw new IllegalStateException(this.getName() + " is not bound");
        }
        if (this.isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + " is already running!"));
            }
            return;
        }
        this.getLocalNode().shutdown(false);
        this.executorService.start();
        this.pingManager.init();
        this.findNodeManager.init();
        this.findValueManager.init();
        this.estimator = new DHTSizeEstimator();
        this.messageDispatcher.start();
        if (!this.isBucketRefresherDisabled()) {
            this.bucketRefresher.start();
        }
        this.valuePublisher.start();
        this.databaseCleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        if (!this.isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + " is not running"));
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping " + this.getName()));
        }
        this.bucketRefresher.stop();
        this.valuePublisher.stop();
        this.databaseCleaner.stop();
        LocalContact localContact = this.getLocalNode();
        localContact.shutdown(true);
        if (this.isBootstrapped() && !this.isFirewalled() && ContextSettings.SEND_SHUTDOWN_MESSAGE.getValue()) {
            int n = ContextSettings.SHUTDOWN_MESSAGES_MULTIPLIER.getValue();
            int n2 = KademliaSettings.REPLICATION_PARAMETER.getValue();
            int n3 = n * n2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sending shutdown message to " + n3 + " Nodes"));
            }
            Collection<Contact> collection = this.getRouteTable().select(localContact.getNodeID(), n3, RouteTable.SelectMode.ALIVE);
            final CountDownLatch countDownLatch = new CountDownLatch(collection.size());
            MessageDispatcher.MessageDispatcherListener messageDispatcherListener = new MessageDispatcher.MessageDispatcherListener(){

                public void handleMessageDispatcherEvent(MessageDispatcher.MessageDispatcherEvent messageDispatcherEvent) {
                    if (messageDispatcherEvent.getEventType() != MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT) {
                        return;
                    }
                    DHTMessage dHTMessage = messageDispatcherEvent.getMessage();
                    if (!(dHTMessage instanceof PingRequest)) {
                        return;
                    }
                    countDownLatch.countDown();
                }
            };
            try {
                this.messageDispatcher.addMessageDispatcherListener(messageDispatcherListener);
                for (Contact contact : collection) {
                    if (contact.equals(localContact)) continue;
                    PingRequest pingRequest = this.getMessageFactory().createPingRequest(localContact, contact.getContactAddress());
                    try {
                        this.messageDispatcher.send(contact, (RequestMessage)pingRequest, null);
                    }
                    catch (IOException iOException) {
                        LOG.error((Object)"IOException", (Throwable)iOException);
                    }
                }
                try {
                    if (!countDownLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                        LOG.info((Object)"Not all shutdown messages were sent");
                    }
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
                }
            }
            finally {
                this.messageDispatcher.removeMessageDispatcherListener(messageDispatcherListener);
            }
        }
        this.messageDispatcher.stop();
        this.executorService.stop();
    }

    @Override
    public synchronized void close() {
        this.stop();
        this.messageDispatcher.close();
        this.bootstrapManager.setBootstrapped(false);
        if (this.estimator != null) {
            this.estimator.clear();
        }
        this.setExternalPort(0);
    }

    private Set<Contact> getActiveContacts() {
        LinkedHashSet<Contact> linkedHashSet = new LinkedHashSet<Contact>();
        Collection<Contact> collection = this.getRouteTable().getActiveContacts();
        collection = ContactUtils.sort(collection);
        linkedHashSet.addAll(collection);
        linkedHashSet.remove(this.getLocalNode());
        return linkedHashSet;
    }

    @Override
    public DHTFuture<PingResult> findActiveContact() {
        return this.pingManager.ping(this.getActiveContacts());
    }

    public DHTFuture<PingResult> ping(Set<? extends SocketAddress> set) {
        return this.pingManager.pingAddresses(set);
    }

    @Override
    public DHTFuture<PingResult> ping(SocketAddress socketAddress) {
        return this.pingManager.ping(socketAddress);
    }

    public DHTFuture<PingResult> ping(Contact contact) {
        return this.pingManager.ping(contact);
    }

    @Override
    public void ping(final Contact contact, final DHTFutureAdapter<PingResult> dHTFutureAdapter) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    DHTFuture<PingResult> dHTFuture = Context.this.ping(contact);
                    if (dHTFutureAdapter != null) {
                        dHTFuture.addFutureListener(dHTFutureAdapter);
                    }
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    ErrorService.error((Throwable)rejectedExecutionException);
                }
            }
        };
        this.getDHTExecutorService().execute(runnable);
    }

    public DHTFuture<PingResult> collisionPing(Contact contact) {
        return this.pingManager.collisionPing(contact);
    }

    public DHTFuture<PingResult> collisionPing(Set<? extends Contact> set) {
        return this.pingManager.collisionPing(set);
    }

    private void throwExceptionIfNotBootstrapped(String string) throws NotBootstrappedException {
        if (!this.isBootstrapped()) {
            if (ContextSettings.THROW_EXCEPTION_IF_NOT_BOOTSTRAPPED.getValue()) {
                throw new NotBootstrappedException(this.getName(), string);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)NotBootstrappedException.getErrorMessage(this.getName(), string));
            }
        }
    }

    @Override
    public DHTFuture<FindValueResult> get(EntityKey entityKey) {
        if (entityKey.isLookupKey()) {
            this.throwExceptionIfNotBootstrapped("get()");
            return this.findValueManager.lookup(entityKey);
        }
        return this.getValueManager.get(entityKey);
    }

    public DHTFuture<FindNodeResult> lookup(KUID kUID) {
        return this.findNodeManager.lookup(kUID);
    }

    @Override
    public DHTFuture<BootstrapResult> bootstrap(Contact contact) {
        return this.bootstrapManager.bootstrap(contact);
    }

    @Override
    public DHTFuture<BootstrapResult> bootstrap(SocketAddress socketAddress) {
        return this.bootstrapManager.bootstrap(Collections.singleton(socketAddress));
    }

    @Override
    public DHTFuture<StoreResult> put(KUID kUID, DHTValue dHTValue) {
        return this.put(DHTValueEntity.createFromValue(this, kUID, dHTValue));
    }

    public DHTFuture<StoreResult> put(DHTValueEntity dHTValueEntity) {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.getName() + " is not running");
        }
        if (this.isBootstrapped()) {
            return this.store(dHTValueEntity);
        }
        String string = dHTValueEntity.getValue().size() == 0 ? "remove()" : "put()";
        NotBootstrappedException notBootstrappedException = new NotBootstrappedException(this.getName(), string);
        return new DHTValueFuture<StoreResult>(notBootstrappedException);
    }

    @Override
    public DHTFuture<StoreResult> remove(KUID kUID) {
        return this.put(kUID, DHTValue.EMPTY_VALUE);
    }

    public DHTFuture<StoreResult> store(Storable storable) {
        return this.store(DHTValueEntity.createFromStorable(this, storable));
    }

    public DHTFuture<StoreResult> store(DHTValueEntity dHTValueEntity) {
        return this.store(Collections.singleton(dHTValueEntity));
    }

    public DHTFuture<StoreResult> store(Collection<? extends DHTValueEntity> collection) {
        this.throwExceptionIfNotBootstrapped("store()");
        return this.storeManager.store(collection);
    }

    public DHTFuture<StoreResult> store(Contact contact, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
        return this.storeManager.store(contact, securityToken, collection);
    }

    @Override
    public synchronized BigInteger size() {
        if (!this.isRunning()) {
            return BigInteger.ZERO;
        }
        return this.estimator.getEstimatedSize(this.getRouteTable());
    }

    public void addEstimatedRemoteSize(BigInteger bigInteger) {
        this.estimator.addEstimatedRemoteSize(bigInteger);
    }

    public void updateEstimatedSize(Collection<? extends Contact> collection) {
        this.estimator.updateSize(collection);
    }

    public NetworkStatisticContainer getNetworkStats() {
        return this.networkStats;
    }

    public GlobalLookupStatisticContainer getGlobalLookupStats() {
        return this.globalLookupStats;
    }

    public DatabaseStatisticContainer getDatabaseStats() {
        return this.databaseStats;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Local Node: ").append(this.getLocalNode()).append("\n");
        stringBuilder.append("Is running: ").append(this.isRunning()).append("\n");
        stringBuilder.append("Is bootstrapped/ing: ").append(this.isBootstrapped()).append("/").append(this.isBootstrapping()).append("\n");
        stringBuilder.append("Database Size (Keys): ").append(this.getDatabase().getKeyCount()).append("\n");
        stringBuilder.append("Database Size (Values): ").append(this.getDatabase().getValueCount()).append("\n");
        stringBuilder.append("RouteTable Size: ").append(this.getRouteTable().size()).append("\n");
        stringBuilder.append("Estimated DHT Size: ").append(this.size()).append("\n");
        return stringBuilder.toString();
    }
}

