/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.result.StatsResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsResponseHandler
extends AbstractResponseHandler<StatsResult> {
    private static final Log LOG = LogFactory.getLog(StatsResponseHandler.class);

    public StatsResponseHandler(Context context) {
        super(context);
    }

    @Override
    protected void start() throws DHTException {
    }

    @Override
    protected void response(ResponseMessage responseMessage, long l) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Stats request to " + responseMessage.getContact() + " succeeded"));
        }
        StatsResponse statsResponse = (StatsResponse)responseMessage;
        this.setReturnValue(new StatsResult(statsResponse.getStatistics()));
    }

    @Override
    protected void timeout(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, long l) throws IOException {
        this.fireTimeoutException(kUID, socketAddress, requestMessage, l);
    }

    @Override
    protected void error(KUID kUID, SocketAddress socketAddress, RequestMessage requestMessage, IOException iOException) {
        this.setException(new DHTBackendException(kUID, socketAddress, requestMessage, iOException));
    }
}

