/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.handler.response.FindValueResponseHandler;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.result.FindValueResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindValueManager
extends AbstractManager<FindValueResult> {
    private final Map<EntityKey, FindValueFuture> futureMap = Collections.synchronizedMap(new HashMap());

    public FindValueManager(Context context) {
        super(context);
    }

    public void init() {
        this.futureMap.clear();
    }

    public DHTFuture<FindValueResult> lookup(EntityKey entityKey) {
        return this.lookup(entityKey, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFuture<FindValueResult> lookup(EntityKey entityKey, int n) {
        FindValueFuture findValueFuture = null;
        Map<EntityKey, FindValueFuture> map = this.futureMap;
        synchronized (map) {
            findValueFuture = this.futureMap.get(entityKey);
            if (findValueFuture == null) {
                FindValueResponseHandler findValueResponseHandler = new FindValueResponseHandler(this.context, entityKey);
                findValueFuture = new FindValueFuture(entityKey, findValueResponseHandler);
                this.futureMap.put(entityKey, findValueFuture);
                this.context.getDHTExecutorService().execute((Runnable)((Object)findValueFuture));
            }
        }
        return findValueFuture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindValueFuture
    extends DHTFutureTask<FindValueResult> {
        private final EntityKey entityKey;
        private final DHTTask<FindValueResult> handler;

        public FindValueFuture(EntityKey entityKey, DHTTask<FindValueResult> dHTTask) {
            super(FindValueManager.this.context, dHTTask);
            this.entityKey = entityKey;
            this.handler = dHTTask;
        }

        @Override
        protected void done0() {
            FindValueManager.this.futureMap.remove(this.entityKey);
        }

        public String toString() {
            return "FindValueFuture: " + this.entityKey + ", " + this.handler;
        }
    }
}

