/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import org.limewire.io.ByteBufferInputStream;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.messages.impl.DefaultMessageID;
import org.limewire.mojito.messages.impl.FindNodeRequestImpl;
import org.limewire.mojito.messages.impl.FindNodeResponseImpl;
import org.limewire.mojito.messages.impl.FindValueRequestImpl;
import org.limewire.mojito.messages.impl.FindValueResponseImpl;
import org.limewire.mojito.messages.impl.PingRequestImpl;
import org.limewire.mojito.messages.impl.PingResponseImpl;
import org.limewire.mojito.messages.impl.StatsRequestImpl;
import org.limewire.mojito.messages.impl.StatsResponseImpl;
import org.limewire.mojito.messages.impl.StoreRequestImpl;
import org.limewire.mojito.messages.impl.StoreResponseImpl;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageFactory
implements MessageFactory {
    protected final Context context;

    public DefaultMessageFactory(Context context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DHTMessage createMessage(SocketAddress socketAddress, ByteBuffer ... byteBufferArray) throws MessageFormatException, IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new MessageInputStream((InputStream)new ByteBufferInputStream(byteBufferArray), this.context.getMACCalculatorRepositoryManager());
            MessageID messageID = ((MessageInputStream)filterInputStream).readMessageID();
            int n = ((DataInputStream)filterInputStream).readUnsignedByte();
            if (n != 68) {
                throw new MessageFormatException("Unknown function ID: " + n);
            }
            Version version = ((MessageInputStream)filterInputStream).readVersion();
            filterInputStream.skip(4L);
            DHTMessage.OpCode opCode = ((MessageInputStream)filterInputStream).readOpCode();
            switch (opCode) {
                case PING_REQUEST: {
                    PingRequestImpl pingRequestImpl = new PingRequestImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return pingRequestImpl;
                }
                case PING_RESPONSE: {
                    PingResponseImpl pingResponseImpl = new PingResponseImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return pingResponseImpl;
                }
                case FIND_NODE_REQUEST: {
                    FindNodeRequestImpl findNodeRequestImpl = new FindNodeRequestImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return findNodeRequestImpl;
                }
                case FIND_NODE_RESPONSE: {
                    FindNodeResponseImpl findNodeResponseImpl = new FindNodeResponseImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return findNodeResponseImpl;
                }
                case FIND_VALUE_REQUEST: {
                    FindValueRequestImpl findValueRequestImpl = new FindValueRequestImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return findValueRequestImpl;
                }
                case FIND_VALUE_RESPONSE: {
                    FindValueResponseImpl findValueResponseImpl = new FindValueResponseImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return findValueResponseImpl;
                }
                case STORE_REQUEST: {
                    StoreRequestImpl storeRequestImpl = new StoreRequestImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return storeRequestImpl;
                }
                case STORE_RESPONSE: {
                    StoreResponseImpl storeResponseImpl = new StoreResponseImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return storeResponseImpl;
                }
                case STATS_REQUEST: {
                    StatsRequestImpl statsRequestImpl = new StatsRequestImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return statsRequestImpl;
                }
                case STATS_RESPONSE: {
                    StatsResponseImpl statsResponseImpl = new StatsResponseImpl(this.context, socketAddress, messageID, version, (MessageInputStream)filterInputStream);
                    return statsResponseImpl;
                }
            }
            throw new IOException("Unhandled OpCode " + (Object)((Object)opCode));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = socketAddress != null ? socketAddress.toString() : null;
            throw new MessageFormatException(string, illegalArgumentException);
        }
        catch (IOException iOException) {
            String string = socketAddress != null ? socketAddress.toString() : null;
            throw new MessageFormatException(string, iOException);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public SecurityToken createSecurityToken(Contact contact) {
        return this.context.getSecurityTokenHelper().createSecurityToken(contact);
    }

    @Override
    public MessageID createMessageID(SocketAddress socketAddress) {
        if (!NetworkUtils.isValidSocketAddress((SocketAddress)socketAddress)) {
            throw new IllegalArgumentException(socketAddress + " is an invalid SocketAddress");
        }
        return DefaultMessageID.createWithSocketAddress(socketAddress, this.context.getMACCalculatorRepositoryManager());
    }

    @Override
    public ByteBuffer writeMessage(SocketAddress socketAddress, DHTMessage dHTMessage) throws IOException {
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(640, true);
        dHTMessage.write((OutputStream)byteBufferOutputStream);
        byteBufferOutputStream.close();
        return ((ByteBuffer)byteBufferOutputStream.getBuffer().flip()).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public FindNodeRequest createFindNodeRequest(Contact contact, SocketAddress socketAddress, KUID kUID) {
        return new FindNodeRequestImpl(this.context, contact, this.createMessageID(socketAddress), kUID);
    }

    @Override
    public FindNodeResponse createFindNodeResponse(Contact contact, Contact contact2, MessageID messageID, Collection<? extends Contact> collection) {
        return new FindNodeResponseImpl(this.context, contact, messageID, this.createSecurityToken(contact2), collection);
    }

    @Override
    public FindValueRequest createFindValueRequest(Contact contact, SocketAddress socketAddress, KUID kUID, Collection<KUID> collection, DHTValueType dHTValueType) {
        return new FindValueRequestImpl(this.context, contact, this.createMessageID(socketAddress), kUID, collection, dHTValueType);
    }

    @Override
    public FindValueResponse createFindValueResponse(Contact contact, Contact contact2, MessageID messageID, float f, Collection<? extends DHTValueEntity> collection, Collection<KUID> collection2) {
        return new FindValueResponseImpl(this.context, contact, messageID, f, collection, collection2);
    }

    @Override
    public PingRequest createPingRequest(Contact contact, SocketAddress socketAddress) {
        return new PingRequestImpl(this.context, contact, this.createMessageID(socketAddress));
    }

    @Override
    public PingResponse createPingResponse(Contact contact, Contact contact2, MessageID messageID, SocketAddress socketAddress, BigInteger bigInteger) {
        return new PingResponseImpl(this.context, contact, messageID, socketAddress, bigInteger);
    }

    @Override
    public StatsRequest createStatsRequest(Contact contact, SocketAddress socketAddress, StatsRequest.StatisticType statisticType) {
        return new StatsRequestImpl(this.context, contact, this.createMessageID(socketAddress), statisticType);
    }

    @Override
    public StatsResponse createStatsResponse(Contact contact, Contact contact2, MessageID messageID, byte[] byArray) {
        return new StatsResponseImpl(this.context, contact, messageID, byArray);
    }

    @Override
    public StoreRequest createStoreRequest(Contact contact, SocketAddress socketAddress, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
        return new StoreRequestImpl(this.context, contact, this.createMessageID(socketAddress), securityToken, collection);
    }

    @Override
    public StoreResponse createStoreResponse(Contact contact, Contact contact2, MessageID messageID, Collection<StoreResponse.StoreStatusCode> collection) {
        return new StoreResponseImpl(this.context, contact, messageID, collection);
    }
}

