/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.Signature;
import java.security.SignatureException;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.impl.AbstractRequestMessage;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Version;

public class StatsRequestImpl
extends AbstractRequestMessage
implements StatsRequest {
    private final StatsRequest.StatisticType request;
    private final byte[] signature;
    private int secureStatus = 0;

    public StatsRequestImpl(Context context, Contact contact, MessageID messageID, StatsRequest.StatisticType statisticType) {
        super(context, DHTMessage.OpCode.STATS_REQUEST, contact, messageID, Version.ZERO);
        this.request = statisticType;
        this.signature = null;
    }

    public StatsRequestImpl(Context context, SocketAddress socketAddress, MessageID messageID, Version version, MessageInputStream messageInputStream) throws IOException {
        super(context, DHTMessage.OpCode.STATS_REQUEST, socketAddress, messageID, version, messageInputStream);
        this.request = messageInputStream.readStatisticType();
        this.signature = messageInputStream.readSignature();
    }

    public StatsRequest.StatisticType getType() {
        return this.request;
    }

    public void setSecureStatus(int n) {
        this.secureStatus = n;
    }

    public int getSecureStatus() {
        return this.secureStatus;
    }

    public boolean isSecure() {
        return this.secureStatus == 2;
    }

    public byte[] getSecureSignature() {
        return this.signature;
    }

    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        this.initSignature(signature);
    }

    protected void writeBody(MessageOutputStream messageOutputStream) throws IOException {
        messageOutputStream.writeStatisticType(this.request);
        messageOutputStream.writeSignature(this.signature);
    }

    public String toString() {
        return "StatsRequest: " + (Object)((Object)this.request);
    }
}

