/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.settings.NetworkSettings;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.ContactUtils;

public class RemoteContact
implements Contact {
    private static final long serialVersionUID = 833079992601013124L;
    private static final Log LOG = LogFactory.getLog(RemoteContact.class);
    private final KUID nodeId;
    private final Vendor vendor;
    private final Version version;
    private final int instanceId;
    private volatile transient SocketAddress sourceAddress;
    private volatile SocketAddress contactAddress;
    private transient long rtt = -1L;
    private volatile long timeStamp = 0L;
    private volatile long lastFailedTime = 0L;
    private volatile int failures = 0;
    private volatile transient Contact.State state = Contact.State.UNKNOWN;
    private volatile int flags = 0;

    public RemoteContact(SocketAddress socketAddress, Vendor vendor, Version version, KUID kUID, SocketAddress socketAddress2, int n, int n2, Contact.State state) {
        if (kUID == null) {
            throw new NullPointerException("Node ID is null");
        }
        if (socketAddress2 == null) {
            throw new NullPointerException("SocketAddress is null");
        }
        this.sourceAddress = socketAddress;
        this.vendor = vendor;
        this.version = version;
        this.nodeId = kUID;
        this.contactAddress = socketAddress2;
        this.instanceId = n;
        this.flags = n2;
        Contact.State state2 = this.state = state != null ? state : Contact.State.UNKNOWN;
        if (Contact.State.ALIVE.equals((Object)state) || Contact.State.UNKNOWN.equals((Object)state) && socketAddress != null) {
            this.timeStamp = System.currentTimeMillis();
            this.fixSourceAndContactAddress(socketAddress);
        }
        this.checkPortConsistent();
    }

    private void checkPortConsistent() {
        int n = ((InetSocketAddress)this.contactAddress).getPort();
        if (n == 0) {
            this.setFirewalled(true);
        }
    }

    private void init() {
        this.sourceAddress = null;
        this.rtt = -1L;
        this.state = Contact.State.UNKNOWN;
    }

    public final void fixSourceAndContactAddress(SocketAddress socketAddress) {
        if (socketAddress != null) {
            this.sourceAddress = socketAddress;
            SocketAddress socketAddress2 = this.contactAddress;
            int n = ((InetSocketAddress)this.contactAddress).getPort();
            if (n == 0) {
                if (!this.isFirewalled() && LOG.isWarnEnabled()) {
                    LOG.warn((Object)(ContactUtils.toString(this.nodeId, socketAddress) + " contact address is set to Port 0 but it is not marked as firewalled"));
                }
                this.contactAddress = socketAddress;
                this.checkPortConsistent();
            } else if (!NetworkSettings.ACCEPT_FORCED_ADDRESS.getValue() && !ContactUtils.isPrivateAddress(socketAddress)) {
                this.contactAddress = new InetSocketAddress(((InetSocketAddress)socketAddress).getAddress(), n);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Merged " + socketAddress + " and " + socketAddress2 + " to " + this.contactAddress + ", firewalled=" + this.isFirewalled()));
            }
        }
    }

    public void updateWithExistingContact(Contact contact) {
        if (!this.nodeId.equals(contact.getNodeID())) {
            throw new IllegalArgumentException("Node IDs do not match: " + this + " vs. " + contact);
        }
        if (this.rtt < 0L) {
            this.rtt = contact.getRoundTripTime();
        }
        if (!this.isAlive() || this.getTimeStamp() < contact.getTimeStamp()) {
            this.timeStamp = contact.getTimeStamp();
            this.lastFailedTime = contact.getLastFailedTime();
            this.failures = contact.getFailures();
        }
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public Version getVersion() {
        return this.version;
    }

    public KUID getNodeID() {
        return this.nodeId;
    }

    public int getInstanceID() {
        return this.instanceId;
    }

    public int getFlags() {
        return this.flags;
    }

    public SocketAddress getContactAddress() {
        return this.contactAddress;
    }

    public SocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public long getRoundTripTime() {
        return this.rtt;
    }

    public void setRoundTripTime(long l) {
        this.rtt = l;
    }

    public void setTimeStamp(long l) {
        assert (l != Long.MAX_VALUE);
        this.timeStamp = l;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getLastFailedTime() {
        return this.lastFailedTime;
    }

    public boolean isFirewalled() {
        return (this.flags & 1) != 0;
    }

    private void setFirewalled(boolean bl) {
        if (this.isFirewalled() != bl) {
            this.flags ^= 1;
        }
    }

    public long getAdaptativeTimeout() {
        long l = NetworkSettings.DEFAULT_TIMEOUT.getValue();
        if (this.rtt <= 0L || !this.isAlive()) {
            return l;
        }
        long l2 = NetworkSettings.MIN_TIMEOUT_RTT_FACTOR.getValue();
        long l3 = l2 * this.rtt + (long)this.failures * this.rtt;
        return Math.max(Math.min(l, l3), NetworkSettings.MIN_TIMEOUT_RTT.getValue());
    }

    public void alive() {
        this.state = Contact.State.ALIVE;
        this.failures = 0;
        this.timeStamp = System.currentTimeMillis();
    }

    public boolean isAlive() {
        return Contact.State.ALIVE.equals((Object)this.state);
    }

    public void unknown() {
        this.state = Contact.State.UNKNOWN;
        this.failures = 0;
        this.timeStamp = 0L;
    }

    public boolean isUnknown() {
        return Contact.State.UNKNOWN.equals((Object)this.state);
    }

    public boolean isDead() {
        return Contact.State.DEAD.equals((Object)this.state);
    }

    public boolean hasBeenRecentlyAlive() {
        return System.currentTimeMillis() - this.getTimeStamp() < RouteTableSettings.MIN_RECONNECTION_TIME.getValue();
    }

    public int getFailures() {
        return this.failures;
    }

    public void handleFailure() {
        ++this.failures;
        this.lastFailedTime = System.currentTimeMillis();
        if (!this.isShutdown()) {
            if (this.getTimeStamp() > 0L) {
                if (this.failures >= RouteTableSettings.MAX_ALIVE_NODE_FAILURES.getValue()) {
                    this.state = Contact.State.DEAD;
                }
            } else if (this.failures >= RouteTableSettings.MAX_UNKNOWN_NODE_FAILURES.getValue()) {
                this.state = Contact.State.DEAD;
            }
        }
    }

    public boolean hasFailed() {
        return this.failures > 0;
    }

    public Contact.State getState() {
        return this.state;
    }

    public void setState(Contact.State state) {
        if (state == null) {
            state = Contact.State.UNKNOWN;
        }
        this.state = state;
    }

    public boolean isShutdown() {
        return (this.flags & 2) != 0;
    }

    public void shutdown(boolean bl) {
        if (this.isShutdown() != bl) {
            this.flags ^= 2;
            this.state = Contact.State.DEAD;
        }
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Contact) || object instanceof LocalContact) {
            return false;
        }
        Contact contact = (Contact)object;
        return this.nodeId.equals(contact.getNodeID()) && this.contactAddress.equals(contact.getContactAddress());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ContactUtils.toString(this.getNodeID(), this.getContactAddress())).append(", rtt=").append(this.getRoundTripTime()).append(", failures=").append(this.getFailures()).append(", instanceId=").append(this.getInstanceID()).append(", state=").append(this.isShutdown() ? "DOWN" : this.getState()).append(", firewalled=").append(this.isFirewalled());
        return stringBuilder.toString();
    }
}

