/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.GuiFrostWireUtils;
import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.DesktopListTransferHandler;
import com.frostwire.gnutella.gui.android.LocalFile;
import com.frostwire.gnutella.gui.android.LocalFileListModel;
import com.frostwire.gnutella.gui.android.LocalFileRenderer;
import com.frostwire.gnutella.gui.android.RedispatchMouseListener;
import com.frostwire.gnutella.gui.android.UITool;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;

public class DesktopExplorer
extends JPanel {
    private static final long serialVersionUID = 7362861227107918643L;
    private JToolBar _toolBar;
    private JButton _buttonUp;
    private JButton _buttonNew;
    private JButton _buttonRefresh;
    private JButton _buttonViewThumbnail;
    private JButton _buttonViewList;
    private JLabel _labelSort;
    private JComboBox _comboBoxSort;
    private BreadcrumbFileSelector _breadcrumb;
    private JList _list;
    private JScrollPane _scrollPane;
    private JPopupMenu _popupList;
    private JPopupMenu _deletePopupMenu;
    private JMenuItem _menuOpen;
    private JMenuItem _menuRename;
    private JMenuItem _menuDelete;
    private JMenuItem _menuDeleteMultiple;
    private JMenuItem _menuRefresh;
    private JTextArea _textName;
    private JScrollPane _scrollName;
    private LocalFileListModel _model = new LocalFileListModel();
    private int _selectedIndexToRename;
    private File _savedFolder;
    private File _documentsFolder;
    private File _musicFolder;
    private File _picturesFolder;
    private File _videosFolder;

    public DesktopExplorer() {
        this._model.setOnRootListener(new LocalFileListModel.OnRootListener(){

            public void onRoot(LocalFileListModel localFileListModel, File file) {
                DesktopExplorer.this.cancelEdit();
                DesktopExplorer.this._breadcrumb.setPath(file);
            }
        });
        this._selectedIndexToRename = -1;
        File file = CommonUtils.getUserHomeDir();
        this._savedFolder = SharingSettings.DEFAULT_SAVE_DIR;
        this._documentsFolder = new File(file, "Documents");
        this._musicFolder = new File(file, "Music");
        this._picturesFolder = new File(file, "Pictures");
        this._videosFolder = new File(file, OSUtils.isMacOSX() ? "Movies" : "Videos");
        this.setupUI();
        this.setRootFolder(SharingSettings.DIRECTORY_FOR_OPEN_DESKTOP_EXPLORER.getValue());
    }

    public File getRootFolder() {
        this.cancelEdit();
        return this._model.getRoot();
    }

    public void setRootFolder(File file) {
        this.cancelEdit();
        this._model.setRoot(file);
    }

    public File getSelectedFolder() {
        this.cancelEdit();
        LocalFile localFile = (LocalFile)this._list.getSelectedValue();
        return localFile != null && localFile.getFile().isDirectory() ? localFile.getFile() : null;
    }

    public void refresh() {
        this.cancelEdit();
        this._model.refresh();
    }

    protected void setupUI() {
        this.setLayout(new GridBagLayout());
        this.setupTop();
        this.setupList();
    }

    protected void breadcrumb_pathEvent(BreadcrumbPathEvent breadcrumbPathEvent) {
        this.cancelEdit();
        List list = this._breadcrumb.getModel().getItems();
        if (list.size() > 0) {
            File file = (File)list.get(list.size() - 1).getData();
            LocalFileListModel.OnRootListener onRootListener = this._model.getOnRootListener();
            this._model.setOnRootListener(null);
            this._model.setRoot(file);
            this._model.setOnRootListener(onRootListener);
            SharingSettings.DIRECTORY_FOR_OPEN_DESKTOP_EXPLORER.setValue(file);
        }
    }

    protected void buttonUp_mousePressed(MouseEvent mouseEvent) {
        this.actionGotoParentFolder();
    }

    protected void buttonNew_mousePressed(MouseEvent mouseEvent) {
        this.cancelEdit();
        LocalFile localFile = this._model.createNewFolder();
        if (localFile != null) {
            this._list.setSelectedValue(localFile, true);
        }
    }

    protected void buttonViewThumbnail_mousePressed(MouseEvent mouseEvent) {
        this.cancelEdit();
        this._list.setLayoutOrientation(2);
        this._list.setPrototypeCellValue(new LocalFile(this._savedFolder));
    }

    protected void buttonViewList_mousePressed(MouseEvent mouseEvent) {
        this.cancelEdit();
        this._list.setLayoutOrientation(0);
        this._list.setPrototypeCellValue(new LocalFile(this._savedFolder));
    }

    protected void comboBoxSort_actionPerformed(ActionEvent actionEvent) {
        this.cancelEdit();
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        SortByItem sortByItem = (SortByItem)jComboBox.getSelectedItem();
        this._model.sortBy(sortByItem.sortBy);
    }

    protected void textName_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this._selectedIndexToRename != -1 && n == 10) {
            this.renameSelectedItem(this._selectedIndexToRename);
        } else if (n == 27) {
            this._scrollName.setVisible(false);
        }
    }

    protected void list_mouseClicked(MouseEvent mouseEvent) {
        this.cancelEdit();
        if (SwingUtilities.isRightMouseButton(mouseEvent) && !this._list.isSelectionEmpty()) {
            int n = this._list.getSelectedIndices().length;
            if (n == 1) {
                this._popupList.show(this._list, mouseEvent.getX(), mouseEvent.getY());
            } else if (n > 1) {
                this._deletePopupMenu.show(this._list, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (mouseEvent.getClickCount() >= 2 && !mouseEvent.isConsumed()) {
            this.actionOpenFile();
        }
    }

    protected void list_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.cancelEdit();
        } else if (n == 116) {
            this.refresh();
        } else if (n == 10) {
            if (OSUtils.isMacOSX()) {
                this.actionStartRename();
            } else {
                this.actionOpenFile();
            }
        } else if (n == 113) {
            if (!OSUtils.isMacOSX()) {
                this.actionStartRename();
            }
        } else if (n == 32) {
            if (OSUtils.isMacOSX() || OSUtils.isLinux()) {
                this.actionOpenFile();
            }
        } else if (!OSUtils.isMacOSX() && n == 8 || OSUtils.isMacOSX() && n == 38 && keyEvent.isMetaDown()) {
            this.actionGotoParentFolder();
        }
    }

    private void setupTop() {
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.setRollover(true);
        this._toolBar.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this._scrollName.setVisible(false);
            }
        });
        this._toolBar.addSeparator();
        Dimension dimension = new Dimension(28, 28);
        this._buttonUp = new JButton();
        this._buttonUp.setIcon(new ImageIcon(new UITool().loadImage("folder_up")));
        this._buttonUp.setPreferredSize(dimension);
        this._buttonUp.setMinimumSize(dimension);
        this._buttonUp.setMaximumSize(dimension);
        this._buttonUp.setSize(dimension);
        this._buttonUp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this.buttonUp_mousePressed(mouseEvent);
            }
        });
        this._toolBar.add(this._buttonUp);
        this._buttonNew = new JButton();
        this._buttonNew.setIcon(new ImageIcon(new UITool().loadImage("folder_new")));
        this._buttonNew.setPreferredSize(dimension);
        this._buttonNew.setMinimumSize(dimension);
        this._buttonNew.setMaximumSize(dimension);
        this._buttonNew.setSize(dimension);
        this._buttonNew.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this.buttonNew_mousePressed(mouseEvent);
            }
        });
        this._toolBar.add(this._buttonNew);
        this._buttonRefresh = new JButton();
        this._buttonRefresh.setIcon(new ImageIcon(new UITool().loadImage("refresh")));
        this._buttonRefresh.setPreferredSize(dimension);
        this._buttonRefresh.setMinimumSize(dimension);
        this._buttonRefresh.setMaximumSize(dimension);
        this._buttonRefresh.setSize(dimension);
        this._buttonRefresh.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this.refresh();
            }
        });
        this._toolBar.add(this._buttonRefresh);
        this._toolBar.addSeparator();
        this._buttonViewThumbnail = new JButton();
        this._buttonViewThumbnail.setIcon(new ImageIcon(new UITool().loadImage("view_thumbnail")));
        this._buttonViewThumbnail.setPreferredSize(dimension);
        this._buttonViewThumbnail.setMinimumSize(dimension);
        this._buttonViewThumbnail.setMaximumSize(dimension);
        this._buttonViewThumbnail.setSize(dimension);
        this._buttonViewThumbnail.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this.buttonViewThumbnail_mousePressed(mouseEvent);
            }
        });
        this._toolBar.add(this._buttonViewThumbnail);
        this._buttonViewList = new JButton();
        this._buttonViewList.setIcon(new ImageIcon(new UITool().loadImage("view_list")));
        this._buttonViewList.setPreferredSize(dimension);
        this._buttonViewList.setMinimumSize(dimension);
        this._buttonViewList.setMaximumSize(dimension);
        this._buttonViewList.setSize(dimension);
        this._buttonViewList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this.buttonViewList_mousePressed(mouseEvent);
            }
        });
        this._toolBar.add(this._buttonViewList);
        this._toolBar.addSeparator();
        this.setupButtonFavorite(this._toolBar, this._savedFolder, I18n.tr("Saved"), "folder_32");
        this.setupButtonFavorite(this._toolBar, 3, this._documentsFolder, I18n.tr("Documents"));
        this.setupButtonFavorite(this._toolBar, 0, this._musicFolder, I18n.tr("Music"));
        this.setupButtonFavorite(this._toolBar, 1, this._picturesFolder, I18n.tr("Pictures"));
        this.setupButtonFavorite(this._toolBar, 2, this._videosFolder, I18n.tr("Videos"));
        this._toolBar.addSeparator();
        this._labelSort = new JLabel();
        this._labelSort.setText(I18n.tr("Sort:"));
        this._toolBar.add(this._labelSort);
        this._comboBoxSort = new JComboBox();
        this._comboBoxSort.addItem(new SortByItem(0, I18n.tr("None")));
        this._comboBoxSort.addItem(new SortByItem(1, I18n.tr("Name Asc")));
        this._comboBoxSort.addItem(new SortByItem(2, I18n.tr("Name Desc")));
        this._comboBoxSort.addItem(new SortByItem(3, I18n.tr("Date Asc")));
        this._comboBoxSort.addItem(new SortByItem(4, I18n.tr("Date Desc")));
        this._comboBoxSort.addItem(new SortByItem(5, I18n.tr("Kind Asc")));
        this._comboBoxSort.addItem(new SortByItem(6, I18n.tr("Kind Desc")));
        this._comboBoxSort.addItem(new SortByItem(7, I18n.tr("Size Asc")));
        this._comboBoxSort.addItem(new SortByItem(8, I18n.tr("Size Desc")));
        this._comboBoxSort.setSelectedIndex(5);
        this._comboBoxSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopExplorer.this.comboBoxSort_actionPerformed(actionEvent);
            }
        });
        this._toolBar.add(this._comboBoxSort);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this._toolBar, gridBagConstraints);
        this._breadcrumb = new BreadcrumbFileSelector();
        this._breadcrumb.getModel().addPathListener(new BreadcrumbPathListener(){

            public void breadcrumbPathEvent(BreadcrumbPathEvent breadcrumbPathEvent) {
                DesktopExplorer.this.breadcrumb_pathEvent(breadcrumbPathEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this._breadcrumb, gridBagConstraints);
    }

    private void setupList() {
        this._list = new JList(this._model);
        this._list.setCellRenderer(new LocalFileRenderer());
        this._list.addMouseListener(new RedispatchMouseListener(this._list));
        this._list.setLayoutOrientation(2);
        this._list.setDragEnabled(true);
        this._list.setTransferHandler(new DesktopListTransferHandler());
        this._list.setPrototypeCellValue(new LocalFile(this._savedFolder));
        this._list.setVisibleRowCount(-1);
        this._popupList = new JPopupMenu();
        this._deletePopupMenu = new JPopupMenu();
        this._menuOpen = new JMenuItem(I18n.tr("Open"));
        this._menuOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopExplorer.this.actionOpenFile();
            }
        });
        this._popupList.add(this._menuOpen);
        this._menuRename = new JMenuItem(I18n.tr("Rename"));
        this._menuRename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopExplorer.this.actionStartRename();
            }
        });
        this._popupList.add(this._menuRename);
        this._menuDelete = new JMenuItem(I18n.tr("Delete"));
        this._menuDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopExplorer.this.actionStartDelete();
            }
        });
        this._popupList.add(this._menuDelete);
        this._menuDeleteMultiple = new JMenuItem(I18n.tr("Delete Files"));
        this._menuDeleteMultiple.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopExplorer.this.actionStartDelete();
            }
        });
        this._deletePopupMenu.add(this._menuDeleteMultiple);
        this._popupList.addSeparator();
        this._menuRefresh = new JMenuItem(I18n.tr("Refresh"));
        this._menuRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DesktopExplorer.this.refresh();
            }
        });
        this._popupList.add(this._menuRefresh);
        this._list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                DesktopExplorer.this.cancelEdit();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DesktopExplorer.this.cancelEdit();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                DesktopExplorer.this.list_mouseClicked(mouseEvent);
            }
        });
        this._list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DesktopExplorer.this.list_keyPressed(keyEvent);
            }
        });
        this._scrollPane = new JScrollPane(this._list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 8;
        this.add((Component)this._scrollPane, gridBagConstraints);
        this._textName = new JTextArea();
        this._textName.setLineWrap(true);
        this._textName.setWrapStyleWord(true);
        this._textName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DesktopExplorer.this.textName_keyPressed(keyEvent);
            }
        });
        this._scrollName = new JScrollPane(this._textName);
        this._scrollName.setVisible(false);
        this._scrollName.setHorizontalScrollBarPolicy(31);
        this._scrollName.setVerticalScrollBarPolicy(21);
        this._list.add(this._scrollName);
    }

    private JButton setupButtonFavorite(JToolBar jToolBar, int n, File file, String string) {
        return this.setupButtonFavorite(jToolBar, file, string, new UITool().getImageNameByFileType(n));
    }

    private JButton setupButtonFavorite(JToolBar jToolBar, final File file, String string, String string2) {
        if (!file.exists()) {
            return null;
        }
        Image image = new UITool().loadImage(string2).getScaledInstance(18, 18, 4);
        Dimension dimension = new Dimension(28, 28);
        JButton jButton = new JButton();
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setSize(dimension);
        jButton.setToolTipText(string);
        jButton.setIcon(new ImageIcon(image));
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                DesktopExplorer.this.cancelEdit();
                DesktopExplorer.this.setRootFolder(file);
            }
        });
        jToolBar.add(jButton);
        return jButton;
    }

    private void startEdit(int n) {
        this._selectedIndexToRename = n;
        LocalFile localFile = (LocalFile)this._model.getElementAt(n);
        String string = localFile.getName();
        if (this._list.getLayoutOrientation() == 0) {
            LocalFileRenderer localFileRenderer = (LocalFileRenderer)this._list.getCellRenderer().getListCellRendererComponent(this._list, this._list.getModel().getElementAt(n), n, false, false);
            Dimension dimension = localFileRenderer.getLabelNameSize();
            Point point = localFileRenderer.getLabelNameLocation();
            dimension.setSize(dimension.getWidth() - 3.0, dimension.getHeight() - 8.0);
            Point point2 = this._list.indexToLocation(n);
            point2.translate(point.x, point.y + 4);
            this._textName.setSize(dimension);
            this._scrollName.setSize(dimension);
            this._scrollName.setLocation(point2);
        } else {
            Point point = this._list.indexToLocation(n);
            point.translate(5, 64);
            this._textName.setSize(130, 33);
            this._scrollName.setSize(130, 33);
            this._scrollName.setLocation(point);
        }
        this._textName.setText(string);
        this._textName.setSelectionStart(0);
        this._textName.setSelectionEnd(localFile.getFile().isFile() ? string.lastIndexOf(".") : string.length());
        this._scrollName.setVisible(true);
        this._scrollName.requestFocusInWindow();
        this._scrollName.requestFocus();
        this._textName.requestFocusInWindow();
        this._textName.requestFocus();
    }

    private void actionStartRename() {
        this.cancelEdit();
        int n = this._list.getSelectedIndex();
        if (n != -1) {
            this.startEdit(n);
        }
    }

    private void actionStartDelete() {
        int[] nArray = this._list.getSelectedIndices();
        if (nArray.length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                boolean bl;
                LocalFile localFile = (LocalFile)this._model.getElementAt(nArray[i]);
                if (localFile == null) continue;
                JComponent jComponent = AndroidMediator.instance().getComponent();
                if (localFile.getFile().isDirectory() && localFile.getFile().list().length > 0) {
                    JOptionPane.showMessageDialog(jComponent, I18n.tr("Can't delete not empty folder"), I18n.tr("System"), 1);
                    break;
                }
                try {
                    bl = localFile.getFile().delete();
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) continue;
                JOptionPane.showMessageDialog(jComponent, I18n.tr("Error deleting file"), I18n.tr("System"), 1);
                break;
            }
            this._list.clearSelection();
            this.refresh();
        }
    }

    private void renameSelectedItem(int n) {
        if (!this._scrollName.isVisible()) {
            return;
        }
        String string = this._textName.getText();
        if (string != null && string.length() > 0) {
            LocalFile localFile;
            if (string.indexOf(46) == -1 && (localFile = (LocalFile)this._model.getElementAt(n)) != null && localFile.getFile().isFile() && localFile.getExt() != null) {
                string = string + "." + localFile.getExt();
            }
            this._model.rename(n, string);
        }
        this._scrollName.setVisible(false);
    }

    private void cancelEdit() {
        this._selectedIndexToRename = -1;
        this._scrollName.setVisible(false);
    }

    private void actionOpenFile() {
        LocalFile localFile;
        this.cancelEdit();
        int n = this._list.getSelectedIndex();
        if (n != -1 && (localFile = (LocalFile)this._model.getElementAt(n)) != null) {
            if (localFile.getFile().isDirectory()) {
                this.setRootFolder(localFile.getFile());
            } else {
                GuiFrostWireUtils.launchFile(localFile.getFile());
            }
        }
    }

    private void actionGotoParentFolder() {
        this.cancelEdit();
        File file = this._model.getRoot().getParentFile();
        if (file != null) {
            this.setRootFolder(file);
        }
    }

    private final class SortByItem {
        public int sortBy;
        public String text;

        public SortByItem(int n, String string) {
            this.sortBy = n;
            this.text = string;
        }

        public String toString() {
            return this.text;
        }
    }
}

