/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.CopyToDeviceTask;
import com.frostwire.gnutella.gui.android.DesktopListTransferable;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.DeviceButton;
import com.frostwire.gnutella.gui.android.DeviceListTransferable;
import com.frostwire.gnutella.gui.android.FileDescriptor;
import com.frostwire.gnutella.gui.android.LocalFile;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class DeviceListTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -2277397432089499656L;

    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        DataFlavor[] dataFlavorArray = transferSupport.getDataFlavors();
        return transferSupport.isDataFlavorSupported(DesktopListTransferable.LOCAL_FILE_ARRAY) || DNDUtils.containsFileFlavors(dataFlavorArray);
    }

    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        if (!this.canImport(transferSupport)) {
            return false;
        }
        Device device = AndroidMediator.instance().getDeviceBar().getSelectedDevice();
        if (device == null) {
            if (transferSupport.getComponent() instanceof DeviceButton) {
                device = ((DeviceButton)transferSupport.getComponent()).getDevice();
            } else {
                return false;
            }
        }
        Transferable transferable = transferSupport.getTransferable();
        int n = AndroidMediator.instance().getDeviceExplorer().getSelectedFileType();
        if (DNDUtils.contains(transferable.getTransferDataFlavors(), DesktopListTransferable.LOCAL_FILE_ARRAY)) {
            LocalFile[] localFileArray = null;
            try {
                localFileArray = (LocalFile[])transferable.getTransferData(DesktopListTransferable.LOCAL_FILE_ARRAY);
            }
            catch (Exception exception) {
                return false;
            }
            AndroidMediator.addTask(new CopyToDeviceTask(device, localFileArray, n));
        } else {
            File[] fileArray = null;
            try {
                fileArray = DNDUtils.getFiles(transferable);
            }
            catch (Exception exception) {
                return false;
            }
            AndroidMediator.addTask(new CopyToDeviceTask(device, fileArray, n));
        }
        return true;
    }

    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        JList jList = (JList)jComponent;
        Object[] objectArray = jList.getSelectedValues();
        ArrayList<FileDescriptor> arrayList = new ArrayList<FileDescriptor>();
        for (Object object : objectArray) {
            arrayList.add((FileDescriptor)object);
        }
        return new DeviceListTransferable(arrayList);
    }
}

