/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.HttpFetcher;
import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.Device;
import com.frostwire.gnutella.gui.android.Finger;
import com.frostwire.json.JsonEngine;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.limewire.io.NetworkUtils;

public class PeerDiscoveryClerk {
    private static final long STALE_DEVICE_TIMEOUT = 7000L;
    private HashMap<String, Device> _deviceCache = new HashMap();
    private JsonEngine _jsonEngine = new JsonEngine();

    public void start() {
        try {
            this.startBroadcast();
        }
        catch (Exception exception) {
            PeerDiscoveryClerk.log("Error starting broadcast");
        }
        try {
            this.startMulticast();
        }
        catch (Exception exception) {
            PeerDiscoveryClerk.log("Error starting multicast");
        }
        new Thread((Runnable)new CleanStaleDevices(), "CleanStaleDevices").start();
    }

    private void startBroadcast() throws Exception {
        final DatagramSocket datagramSocket = new DatagramSocket(null);
        datagramSocket.setReuseAddress(true);
        datagramSocket.setBroadcast(true);
        datagramSocket.setSoTimeout(60000);
        datagramSocket.bind(new InetSocketAddress(65456));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        byte[] byArray = new byte[65535];
                        while (true) {
                            try {
                                while (true) {
                                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                                    datagramSocket.receive(datagramPacket);
                                    PeerDiscoveryClerk.this.handleDatagramPacket(datagramPacket, false);
                                }
                            }
                            catch (InterruptedIOException interruptedIOException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        PeerDiscoveryClerk.log("Error receiving broadcast");
                        datagramSocket.close();
                        datagramSocket.disconnect();
                    }
                }
                catch (Throwable throwable) {
                    datagramSocket.close();
                    datagramSocket.disconnect();
                    throw throwable;
                }
            }
        }, "BroadcastClerk").start();
    }

    private void startMulticast() throws Exception {
        InetAddress inetAddress = InetAddress.getByAddress(new byte[]{-32, 0, 1, 16});
        final MulticastSocket multicastSocket = new MulticastSocket(65440);
        multicastSocket.setSoTimeout(60000);
        multicastSocket.setTimeToLive(254);
        multicastSocket.setReuseAddress(true);
        InetAddress inetAddress2 = null;
        inetAddress2 = !ConnectionSettings.CUSTOM_INETADRESS.isDefault() ? InetAddress.getByName(ConnectionSettings.CUSTOM_INETADRESS.getValue()) : NetworkUtils.getLocalAddress();
        multicastSocket.setNetworkInterface(NetworkInterface.getByInetAddress(inetAddress2));
        multicastSocket.joinGroup(inetAddress);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        byte[] byArray = new byte[65535];
                        while (true) {
                            try {
                                while (true) {
                                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                                    multicastSocket.receive(datagramPacket);
                                    PeerDiscoveryClerk.this.handleDatagramPacket(datagramPacket, true);
                                }
                            }
                            catch (InterruptedIOException interruptedIOException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        PeerDiscoveryClerk.log("Error receiving broadcast");
                        multicastSocket.close();
                        multicastSocket.disconnect();
                    }
                }
                catch (Throwable throwable) {
                    multicastSocket.close();
                    multicastSocket.disconnect();
                    throw throwable;
                }
            }
        }, "MulticastClerk").start();
    }

    private void handleDatagramPacket(DatagramPacket datagramPacket, boolean bl) {
        InetAddress inetAddress = datagramPacket.getAddress();
        byte[] byArray = datagramPacket.getData();
        int n = ((byArray[30] & 0xFF) << 8) + (byArray[31] & 0xFF);
        int n2 = (byArray[32] & 0xFF0000) + ((byArray[33] & 0xFF) << 8) + (byArray[34] & 0xFF);
        boolean bl2 = (byArray[67] & 0xFF) != 0;
        this.handleDeviceState(inetAddress, n + 1, n2, bl2);
    }

    private void handleDeviceState(InetAddress inetAddress, int n, int n2, boolean bl) {
        String string = inetAddress.getHostAddress() + ":" + n;
        if (this._deviceCache.containsKey(string)) {
            Device device = this._deviceCache.get(string);
            if (!bl) {
                if (n2 == device.getTotalShared()) {
                    this.handleDeviceAlive(string, device);
                } else {
                    this.retrieveFinger(string, inetAddress, n, bl);
                }
            } else {
                this.handleDeviceStale(string, device);
            }
            return;
        }
        this.retrieveFinger(string, inetAddress, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveFinger(String string, InetAddress inetAddress, int n, boolean bl) {
        try {
            URI uRI = new URI("http://" + string + "/finger");
            HttpFetcher httpFetcher = new HttpFetcher(uRI);
            byte[] byArray = httpFetcher.fetch();
            if (byArray == null) {
                PeerDiscoveryClerk.log("Failed to connnect to " + uRI);
                return;
            }
            String string2 = new String(byArray);
            Finger finger = this._jsonEngine.toObject(string2, Finger.class);
            HashMap<String, Device> hashMap = this._deviceCache;
            synchronized (hashMap) {
                if (this._deviceCache.containsKey(string)) {
                    Device device = this._deviceCache.get(string);
                    if (!bl) {
                        device.setFinger(finger);
                        this.handleDeviceAlive(string, device);
                    } else {
                        this.handleDeviceStale(string, device);
                    }
                } else if (!bl) {
                    Device device = new Device(inetAddress, n, finger);
                    this.handleNewDevice(string, device);
                }
            }
        }
        catch (Exception exception) {
            PeerDiscoveryClerk.log("Failed to connnect to " + string);
        }
    }

    private void handleNewDevice(String string, final Device device) {
        this._deviceCache.put(string, device);
        device.setTimeout(System.currentTimeMillis());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AndroidMediator.handleNewDevice(device);
            }
        });
    }

    private void handleDeviceAlive(String string, final Device device) {
        this._deviceCache.put(string, device);
        device.setTimeout(System.currentTimeMillis());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AndroidMediator.handleDeviceAlive(device);
            }
        });
    }

    private void handleDeviceStale(String string, final Device device) {
        this._deviceCache.remove(string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AndroidMediator.handleDeviceStale(device);
            }
        });
    }

    public static void log(String string) {
        System.out.println("[ERRR] " + new Date() + " PeerDiscoveryClerk: " + string);
    }

    private final class CleanStaleDevices
    implements Runnable {
        private CleanStaleDevices() {
        }

        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                for (Device device : PeerDiscoveryClerk.this._deviceCache.values()) {
                    if (device.getTimeout() + 7000L >= l) continue;
                    PeerDiscoveryClerk.this.handleDeviceStale(device.getKey(), device);
                }
                try {
                    Thread.sleep(7000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

