/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gnutella.gui.android;

import com.frostwire.GuiFrostWireUtils;
import com.frostwire.gnutella.gui.GraphicPanel;
import com.frostwire.gnutella.gui.android.AndroidMediator;
import com.frostwire.gnutella.gui.android.CopyToDesktopTask;
import com.frostwire.gnutella.gui.android.CopyToDeviceTask;
import com.frostwire.gnutella.gui.android.RedispatchMouseListener;
import com.frostwire.gnutella.gui.android.Task;
import com.frostwire.gnutella.gui.android.TaskListModel;
import com.frostwire.gnutella.gui.android.TaskRenderer;
import com.limegroup.gnutella.gui.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ProgressPanel
extends JPanel {
    private static final long serialVersionUID = -5916970294500660451L;
    private TaskListModel _model = new TaskListModel();
    private MyTaskListener _taskListener = new MyTaskListener();
    private JButton _buttonCancelAll;
    private JButton _buttonClearFinished;
    private JList _listTasks;
    private JScrollPane _scrollPaneTasks;
    private JLabel _labelTitle;
    private GraphicPanel _panelTitle;

    public ProgressPanel() {
        this.setupUI();
    }

    public void addTask(Task task) {
        if (!(task instanceof CopyToDesktopTask) && !(task instanceof CopyToDeviceTask)) {
            return;
        }
        task.addOnChangedListener(this._taskListener);
        this._model.addTask(task);
        int n = this._model.getSize() - 1;
        if (n >= 0) {
            this._listTasks.ensureIndexIsVisible(n);
        }
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        this._panelTitle = new GraphicPanel();
        this._panelTitle.setLayout(new BorderLayout());
        this._panelTitle.setGradient(new GradientPaint(0.0f, 0.0f, new Color(5218258), 0.0f, 25.0f, new Color(613784)));
        this.add((Component)this._panelTitle, "First");
        String string = GuiFrostWireUtils.getFontFamily("helvetica", "arial", "Dialog", "FreeSans");
        Font font = new Font(string, 0, 18);
        this._labelTitle = new JLabel(" " + I18n.tr("File Transfers"));
        this._labelTitle.setForeground(Color.white);
        this._labelTitle.setFont(font);
        this._panelTitle.add((Component)this._labelTitle, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this._buttonCancelAll = new JButton(I18n.tr("Cancel All"));
        this._buttonCancelAll.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ProgressPanel.this.buttonCancelAll_mouseClicked(mouseEvent);
            }
        });
        jPanel.add(this._buttonCancelAll);
        this._buttonClearFinished = new JButton(I18n.tr("Clear Finished"));
        this._buttonClearFinished.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ProgressPanel.this.buttonClearFinished_mouseClicked(mouseEvent);
            }
        });
        jPanel.add(this._buttonClearFinished);
        this.add((Component)jPanel, "Last");
        this._listTasks = new JList(this._model);
        this._listTasks.setCellRenderer(new TaskRenderer());
        this._listTasks.addMouseListener(new RedispatchMouseListener(this._listTasks));
        this._listTasks.setSelectionMode(0);
        this._listTasks.setLayoutOrientation(0);
        this._listTasks.setVisibleRowCount(-1);
        this._scrollPaneTasks = new JScrollPane(this._listTasks);
        this.add((Component)this._scrollPaneTasks, "Center");
        this.setPreferredSize(new Dimension(300, 100));
    }

    protected void buttonClearFinished_mouseClicked(MouseEvent mouseEvent) {
        for (int i = this._model.getSize() - 1; i >= 0; --i) {
            Task task = this._model.getElementAt(i);
            if (task.isRunning()) continue;
            this._model.delete(i);
        }
    }

    protected void buttonCancelAll_mouseClicked(MouseEvent mouseEvent) {
        JComponent jComponent = AndroidMediator.instance().getComponent();
        int n = JOptionPane.showConfirmDialog(jComponent, I18n.tr("Should I stop all transfers?"), I18n.tr("Are you sure?"), 0);
        if (n != 0) {
            return;
        }
        for (int i = this._model.getSize() - 1; i >= 0; --i) {
            Task task = this._model.getElementAt(i);
            if (!task.isRunning()) continue;
            this._model.getElementAt(i).cancel();
            this._model.refreshIndex(i);
        }
    }

    private Rectangle getRepaintBounds(int n) {
        Point point = this._listTasks.indexToLocation(n);
        JPanel jPanel = (JPanel)this._listTasks.getCellRenderer().getListCellRendererComponent(this._listTasks, this._listTasks.getModel().getElementAt(n), n, false, false);
        return new Rectangle(point.x, point.y, jPanel.getPreferredSize().width, jPanel.getPreferredSize().height);
    }

    private final class MyTaskListener
    implements Task.OnChangedListener {
        private MyTaskListener() {
        }

        public void onChanged(Task task) {
            final int n = ProgressPanel.this._model.indexOf(task);
            if (n == -1) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        ProgressPanel.this._listTasks.repaint(ProgressPanel.this.getRepaintBounds(n));
                        ProgressPanel.this._model.refreshIndex(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

