/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.overlays;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Hashtable;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

public class OverlayImageManager {
    private static final int MAX_CACHE_SIZE = 2;
    private static OverlayImageManager INSTANCE;
    private static Hashtable<String, OverlayImageData> _savedImages;

    private OverlayImageManager() {
    }

    public static OverlayImageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OverlayImageManager();
        }
        return INSTANCE;
    }

    public String getCachedImagePath(String string, String string2) throws Exception {
        if (_savedImages == null) {
            OverlayImageManager.loadCacheData();
        }
        if (_savedImages.containsKey(string)) {
            OverlayImageData overlayImageData = _savedImages.get(string);
            if (!overlayImageData.getMD5().equalsIgnoreCase(string2)) {
                overlayImageData.deleteFromDisk();
                overlayImageData.setMD5(string2);
                overlayImageData.saveToDisk();
            } else {
                System.out.println("OverlayImageManager.getCachedImagePath(): Image didn't change, using cached");
            }
            overlayImageData.updateLastTimeUsed();
            OverlayImageManager.saveCacheData();
            return "file://" + OverlayImageManager.getLocalOverlayPath() + overlayImageData.getFileName();
        }
        this.purgeCacheIfNeeded(false);
        OverlayImageData overlayImageData = new OverlayImageData(string, string2);
        overlayImageData.updateLastTimeUsed();
        _savedImages.put(overlayImageData.getImageURL(), overlayImageData);
        try {
            OverlayImageManager.saveCacheData();
            overlayImageData.saveToDisk();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "file://" + OverlayImageManager.getLocalOverlayPath() + overlayImageData.getFileName();
    }

    private static void loadCacheData() {
        File file = OverlayImageManager.getConfigFile();
        _savedImages = new Hashtable();
        if (file.length() == 0L) {
            return;
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            _savedImages = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (InvalidClassException invalidClassException) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("OverlayImageManager.loadOverlays() - Unable to reset the overlays file.");
            }
        }
        catch (Exception exception) {
            System.out.println("OverlayImageManager.loadoverlays() - Cannot deserialize - ");
            System.out.println(exception);
            System.out.println("------------");
        }
    }

    private static void saveCacheData() {
        OverlayImageManager.getLocalOverlayPath();
        if (_savedImages == null || _savedImages.size() < 1) {
            return;
        }
        File file = OverlayImageManager.getConfigFile();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(_savedImages);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void purgeCacheIfNeeded(boolean bl) {
        if (_savedImages == null || _savedImages.size() < 2) {
            return;
        }
        OverlayImageData overlayImageData = this.getOldestCachedOverlayImageData();
        if (overlayImageData == null) {
            return;
        }
        overlayImageData.deleteFromDisk();
        _savedImages.remove(overlayImageData.getImageURL());
        if (bl) {
            OverlayImageManager.saveCacheData();
        }
    }

    private OverlayImageData getOldestCachedOverlayImageData() {
        if (_savedImages == null || _savedImages.size() == 0) {
            return null;
        }
        OverlayImageData overlayImageData = null;
        for (String string : _savedImages.keySet()) {
            if (overlayImageData == null) {
                overlayImageData = _savedImages.get(string);
                continue;
            }
            OverlayImageData overlayImageData2 = _savedImages.get(string);
            if (overlayImageData2.getLastTimeUsed() >= overlayImageData.getLastTimeUsed()) continue;
            overlayImageData = overlayImageData2;
        }
        return overlayImageData;
    }

    private static String getLocalOverlayPath() {
        File file = new File(CommonUtils.getUserSettingsDir(), "overlays");
        if (!file.exists()) {
            file.mkdirs();
            FileUtils.setWriteable(file);
        }
        return file + File.separator;
    }

    private static File getConfigFile() {
        File file = new File(CommonUtils.getUserSettingsDir(), "overlays.dat");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("OverlayImageManager.getConfigFile() cannot create file to serialize seen messages");
            }
        }
        return file;
    }

    private static class OverlayImageData
    implements Serializable {
        private static final long serialVersionUID = -5341644185050835045L;
        private String imgUrl;
        private String fileName;
        private String MD5;
        private long lastTimeUsed;

        public OverlayImageData(String string, String string2) {
            if (string != null) {
                this.setImageURL(string);
                this.setFileName(this.getFileNameFromUrl(string));
            }
            this.setMD5(string2);
        }

        public void setImageURL(String string) {
            this.imgUrl = string;
        }

        public String getImageURL() {
            return this.imgUrl;
        }

        public void setMD5(String string) {
            this.MD5 = string;
        }

        public String getMD5() {
            return this.MD5;
        }

        private String getFileNameFromUrl(String string) {
            String string2 = string.substring(string.lastIndexOf("/") + 1, string.length());
            return string2;
        }

        public void setFileName(String string) {
            if (string.startsWith("http://")) {
                string = this.getFileNameFromUrl(string);
            }
            this.fileName = string;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setLastTimeUsed(long l) {
            this.lastTimeUsed = l;
        }

        public long getLastTimeUsed() {
            return this.lastTimeUsed;
        }

        public void updateLastTimeUsed() {
            this.lastTimeUsed = new Date().getTime();
        }

        private boolean saveToDisk() throws Exception {
            int n;
            URL uRL = new URL(this.getImageURL());
            URLConnection uRLConnection = uRL.openConnection();
            String string = uRLConnection.getContentType();
            int n2 = uRLConnection.getContentLength();
            if (!string.startsWith("image/") || n2 == -1) {
                throw new IOException("*****OverlayImageManager.SaveRemoteImage: Invalid image file");
            }
            InputStream inputStream = uRLConnection.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[n2];
            int n3 = 0;
            for (n = 0; n < n2 && (n3 = ((InputStream)bufferedInputStream).read(byArray, n, byArray.length - n)) != -1; n += n3) {
            }
            ((InputStream)bufferedInputStream).close();
            if (n != n2) {
                throw new IOException("ERROR WHILE READING REMOTE IMAGE. Bytes readed: " + n + " bytes; Bytes expected " + n2 + " bytes");
            }
            String string2 = OverlayImageManager.getLocalOverlayPath() + this.getFileName();
            File file = new File(string2);
            file.createNewFile();
            if (!file.exists()) {
                return false;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }

        public void deleteFromDisk() {
            String string = OverlayImageManager.getLocalOverlayPath() + this.getFileName();
            File file = new File(string);
            file.delete();
        }

        public int hashCode() {
            String string = this.getImageURL();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                n += string.charAt(i);
            }
            return n;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
        }
    }
}

