/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.controllers;

import com.frostwire.plugins.controllers.PluginManager;
import com.frostwire.plugins.models.MissingStartMethodException;
import com.frostwire.plugins.models.Plugin;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class PluginLoader {
    private static final Log LOG = LogFactory.getLog(PluginLoader.class);
    private static PluginLoader INSTANCE;
    private static String PLUGINS_FOLDER;
    private Hashtable<String, Plugin> loadedPlugins;
    private HashSet<URL> loadedJars = new HashSet();
    private Hashtable<String, URLClassLoader> classLoaders = new Hashtable();

    private PluginLoader() {
    }

    public static PluginLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginLoader();
        }
        return INSTANCE;
    }

    public void loadPlugins() {
    }

    public Thread runPlugin(Plugin plugin) throws Exception {
        File file = new File(PLUGINS_FOLDER + File.separator + plugin.getName() + ".jar");
        String string = null;
        if (!file.exists()) {
            throw new Exception("PluginLoader.runPlugin() - " + plugin.getName() + ".jar doesn't exist.");
        }
        if (!plugin.isValid()) {
            throw new Exception("PluginLoader.runPlugin() - " + plugin.getName() + " is not valid.");
        }
        if (!PluginManager.getInstance().isPluginInstalled(plugin)) {
            throw new Exception("PluginLoader.runPlugin() - " + plugin.getName() + " is not installed.");
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.out.println("PluginLoader.runPlugin() - we got a plugin Jar Path - " + string);
        JythonInterpreterThread jythonInterpreterThread = new JythonInterpreterThread(plugin, string);
        jythonInterpreterThread.start();
        plugin.setInterpreterThread(jythonInterpreterThread);
        return (Thread)Thread.class.cast(jythonInterpreterThread);
    }

    public void stopPlugin(Plugin plugin) {
        System.out.println("PluginLoader.stopPlugin() - Plugin class name? " + plugin.getClass().getName());
        if (plugin == null) {
            System.out.println("PluginLoader.stopPlugin() - nothing to stop. p==null");
            return;
        }
        PyObject pyObject = plugin.getPyObject();
        if (pyObject == null) {
            System.out.println("PluginLoader.stopPlugin() - " + plugin.getName() + " didn't have a PyObject to stop.");
            return;
        }
        PyObject pyObject2 = pyObject.__findattr__("stop");
        if (pyObject2 != null) {
            System.out.println("PluginLoader.stopPlugin() - stopMethod.__call__()!");
            pyObject2.__call__();
        } else {
            System.out.println("PluginLoader.stopPlugin() - " + plugin.getName() + " PyObject didn't define a stop() method, oh well, at least we tried.");
        }
        plugin.getPythonInterpreter().exec("print 'Before:',dir()");
        plugin.getPythonInterpreter().exec("if vars().has_key('pluginFromJavaWorld'): del pluginFromJavaWorld");
        String string = plugin.getName().substring(0, 1).toUpperCase() + plugin.getName().substring(1);
        plugin.getPythonInterpreter().exec("if vars().has_key('" + string + "'): del " + string);
        String string2 = plugin.getName() + "Instance";
        plugin.getPythonInterpreter().exec("if vars().has_key('" + string2 + "'): del " + string2);
        plugin.getPythonInterpreter().exec("print 'After:',dir()");
        plugin.getPythonInterpreter().cleanup();
    }

    public boolean loadedJar(URL uRL) {
        return this.loadedJars.contains(uRL);
    }

    public boolean loadedJar(String string) throws MalformedURLException {
        File file = new File(string);
        return this.loadedJars.contains(file.toURI().toURL());
    }

    public HashSet getLoadedJars() {
        return this.loadedJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJar2Classpath(String string) throws Exception {
        if (string == null) {
            throw new Exception("PluginLoader.addJar2Classpath() - the jar file path can't be null");
        }
        File file = new File(string);
        if (!file.exists()) {
            LOG.error("Jar doesn't exist (" + string + ")");
            throw new Exception("PluginLoader.addJar2Classpath() - The jar file doesn't exist (" + string + ")");
        }
        URL uRL = null;
        try {
            uRL = new URL("jar:file:" + string + "!/");
            LOG.info("The jar as an url " + uRL);
        }
        catch (Exception exception) {
            LOG.error("Bad URL for jar (" + string + "):\n" + exception.toString() + " (" + uRL + ")\n");
            return;
        }
        if (this.loadedJar(uRL)) {
            LOG.info("Jar was already loaded (" + uRL + ")");
            return;
        }
        Hashtable<String, URLClassLoader> hashtable = this.classLoaders;
        synchronized (hashtable) {
            System.out.println("PluginLoader.addJar2Classpath() Adding Jar to Classpath: [" + uRL.toString() + "]");
            this.getLoadedJars().add(uRL);
        }
        this.classLoaders.put(string, URLClassLoader.newInstance(new URL[]{uRL}));
        LOG.info("Jar loaded (" + uRL + ")");
    }

    public PythonInterpreter runPythonFromJar(String string, String string2) throws MalformedURLException, Exception {
        if (!this.loadedJar(string2)) {
            try {
                this.addJar2Classpath(string2);
            }
            catch (Exception exception) {
                System.out.println();
                throw exception;
            }
        }
        try {
            PySystemState pySystemState = new PySystemState();
            URLClassLoader uRLClassLoader = this.classLoaders.get(string2);
            pySystemState.setClassLoader(uRLClassLoader);
            pySystemState.path.insert(0, new PyString(string2));
            PythonInterpreter pythonInterpreter = new PythonInterpreter(null, pySystemState);
            pythonInterpreter.exec(string);
            return pythonInterpreter;
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage());
            exception.printStackTrace();
            throw exception;
        }
    }

    public URLClassLoader getClassLoader4JarClasspath(String string) {
        if (this.classLoaders.isEmpty() || !this.classLoaders.containsKey(string)) {
            return null;
        }
        return this.classLoaders.get(string);
    }

    static {
        PLUGINS_FOLDER = PluginsSettings.PLUGINS_FOLDER.getValue();
    }

    private class URLPluginClassLoader
    extends URLClassLoader {
        public URLPluginClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }

    private class JythonInterpreterThread
    extends Thread {
        private String pluginPath;
        private Plugin plugin;

        public JythonInterpreterThread(Plugin plugin, String string) {
            this.plugin = plugin;
            this.pluginPath = string;
        }

        public void run() {
            try {
                String string = this.plugin.getName() + "Instance";
                String string2 = this.plugin.getName();
                String string3 = this.plugin.getName().substring(0, 1).toUpperCase() + this.plugin.getName().substring(1).toLowerCase();
                String string4 = "from " + string2 + " import " + string3;
                PythonInterpreter pythonInterpreter = PluginLoader.this.runPythonFromJar(string4, this.pluginPath);
                this.plugin.setPythonInterpreter(pythonInterpreter);
                String string5 = string + " = " + string3 + "()";
                pythonInterpreter.exec(string5);
                this.plugin.setPyObject(pythonInterpreter.get(string));
                pythonInterpreter.set("pluginFromJavaWorld", this.plugin);
                pythonInterpreter.exec(string + ".copyAttributes(pluginFromJavaWorld)");
                if (this.plugin.getPyObject().__findattr__("start") == null) {
                    throw new MissingStartMethodException("PluginLoader.JythonInterpreterThread.run() - The Python class [" + string3 + "] does not define a start method.");
                }
                pythonInterpreter.exec(string + ".start()");
            }
            catch (MissingStartMethodException missingStartMethodException) {
                missingStartMethodException.printStackTrace();
                PluginManager.getInstance().stopPlugin(this.plugin);
            }
            catch (Exception exception) {
                System.out.println("JythonInterpreter.run() exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

