/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.controllers;

import com.frostwire.plugins.controllers.PluginLoader;
import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.InstallObserver;
import com.frostwire.plugins.models.Plugin;
import com.frostwire.plugins.models.PluginDownloader;
import com.frostwire.plugins.models.PluginInstallException;
import com.frostwire.plugins.models.PluginValidator;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.setting.StringSetting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginManager {
    private static final Log LOG = LogFactory.getLog(PluginManager.class);
    private static PluginManager INSTANCE;
    public static final File PLUGINS_FOLDER;
    private Hashtable<String, IPlugin> AVAILABLE_PLUGINS;
    private Hashtable<String, IPlugin> INSTALLED_PLUGINS;
    private Hashtable<String, IPlugin> RUNNING_PLUGINS;
    private Hashtable<String, PluginDownloader.PluginDownloaderWorker> DOWNLOADER_THREADS;

    public static PluginManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginManager();
        }
        return INSTANCE;
    }

    public Hashtable<String, IPlugin> getAvailablePlugins() {
        return this.AVAILABLE_PLUGINS;
    }

    public Hashtable<String, IPlugin> getInstalledPlugins() {
        return this.INSTALLED_PLUGINS;
    }

    public Hashtable<String, IPlugin> getRunningPlugins() {
        return this.RUNNING_PLUGINS;
    }

    private PluginManager() {
        LOG.debug("Created Plugin Manager Instance");
    }

    public void clearAvailablePlugins() {
        this.AVAILABLE_PLUGINS = null;
        File file = new File(PluginsSettings.AVAILABLE_PLUGINS_FILE.getValue());
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clearInstalledPlugins() {
        this.INSTALLED_PLUGINS = null;
        File file = new File(PluginsSettings.INSTALLED_PLUGINS_FILE.getValue());
        if (file.exists()) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final Object[] getFiles(String string, String string2) {
        File file = new File(string);
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string2)) continue;
            vector.add(stringArray[i]);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray();
    }

    private Object[] getPossiblePluginFileNames() throws IOException {
        try {
            Object[] objectArray = this.getFiles(PLUGINS_FOLDER.getCanonicalPath(), ".jar");
            Object[] objectArray2 = this.getFiles(PLUGINS_FOLDER.getCanonicalPath(), ".zip");
            Object[] objectArray3 = this.getFiles(PLUGINS_FOLDER.getCanonicalPath(), ".plugin");
            Vector<String> vector = new Vector<String>();
            if (objectArray != null) {
                for (Object object : objectArray) {
                    vector.add((String)object);
                }
            }
            if (objectArray2 != null) {
                for (Object object : objectArray2) {
                    vector.add((String)object);
                }
            }
            if (objectArray3 != null) {
                for (Object object : objectArray3) {
                    vector.add((String)object);
                }
            }
            if (vector.size() == 0) {
                return null;
            }
            return vector.toArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private Hashtable readPlugins(StringSetting stringSetting) {
        Hashtable hashtable;
        try {
            File file = new File(stringSetting.getValue());
            System.out.println("PluginManager.readPlugins() Plugins file ->" + file.getCanonicalPath());
            if (file.exists() && file.length() <= 0L) {
                LOG.error("The INSTALLED_PLUGINS File is brand new. 0 bytes.");
                Object var2_4 = null;
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(stringSetting.getValue());
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LOG.error("The INSTALLED_PLUGINS Hashset could not be loaded due to " + exception.getMessage());
            hashtable = null;
        }
        return hashtable;
    }

    private void writePlugins(Hashtable hashtable, StringSetting stringSetting) {
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        File file = new File(stringSetting.getValue());
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                LOG.error(exception);
            }
        } else {
            file.delete();
            file = new File(stringSetting.getValue());
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                LOG.error(exception);
            }
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringSetting.getValue());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(hashtable);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            LOG.error("The Hashset could not be written due to " + exception.getMessage());
        }
    }

    public boolean pluginExists(String string) {
        String[] stringArray;
        this.verifyPluginEnvironment();
        String string2 = null;
        String string3 = null;
        if (string == null || string.equals("")) {
            return false;
        }
        try {
            string2 = PLUGINS_FOLDER.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        if (string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".plugin")) {
            string3 = string2 + File.separator + string;
            File file = new File(string3);
            return file.exists();
        }
        for (String string4 : stringArray = new String[]{".jar", ".zip", ".plugin"}) {
            string3 = string2 + File.separator + string + string4;
            File file = new File(string3);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public boolean isPluginInstalled(IPlugin iPlugin) {
        if (iPlugin == null) {
            return false;
        }
        this.verifyInstalledPlugins();
        if (this.INSTALLED_PLUGINS == null || this.INSTALLED_PLUGINS.size() == 0) {
            return false;
        }
        return this.INSTALLED_PLUGINS.containsKey(iPlugin.getName());
    }

    public void readInstalledPlugins() {
        this.INSTALLED_PLUGINS = this.readPlugins(PluginsSettings.INSTALLED_PLUGINS_FILE);
    }

    public void writeInstalledPlugins() {
        this.writePlugins(this.INSTALLED_PLUGINS, PluginsSettings.INSTALLED_PLUGINS_FILE);
    }

    public void readAvailablePlugins() {
        this.AVAILABLE_PLUGINS = this.readPlugins(PluginsSettings.AVAILABLE_PLUGINS_FILE);
    }

    public void writeAvailablePlugins() {
        this.writePlugins(this.AVAILABLE_PLUGINS, PluginsSettings.AVAILABLE_PLUGINS_FILE);
    }

    public void verifyPluginEnvironment() {
        if (!PLUGINS_FOLDER.exists()) {
            PLUGINS_FOLDER.mkdir();
            this.clearInstalledPlugins();
        }
        if (this.DOWNLOADER_THREADS == null) {
            this.DOWNLOADER_THREADS = new Hashtable();
        }
    }

    public void verifyInstalledPlugins() {
        File file = new File(PluginsSettings.INSTALLED_PLUGINS_FILE.getValue());
        if (!file.exists()) {
            this.INSTALLED_PLUGINS = null;
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            file = new File(PluginsSettings.INSTALLED_PLUGINS_FILE.getValue());
            return;
        }
        this.readInstalledPlugins();
        if (this.INSTALLED_PLUGINS == null) {
            this.INSTALLED_PLUGINS = new Hashtable();
        }
        boolean bl = false;
        if (this.getInstalledPlugins() != null) {
            Set<Map.Entry<String, IPlugin>> set = this.getInstalledPlugins().entrySet();
            for (Map.Entry<String, IPlugin> entry : set) {
                if (this.pluginExists(entry.getKey())) continue;
                bl = true;
                this.getInstalledPlugins().remove(entry.getKey());
            }
        }
        if (bl) {
            this.writeInstalledPlugins();
        }
    }

    public void checkForAvailablePluginsLocally(boolean bl) throws IOException {
        Object[] objectArray;
        this.verifyPluginEnvironment();
        if (bl) {
            this.clearAvailablePlugins();
        }
        if ((objectArray = this.getPossiblePluginFileNames()) == null) {
            return;
        }
        System.out.println("PluginManager.checkForAvailablePluginsLocally() - Total possible plugin filenames -> " + objectArray.length);
        if (this.getAvailablePlugins() == null || this.getAvailablePlugins().size() == 0) {
            for (Object object : objectArray) {
                String string = PLUGINS_FOLDER.getCanonicalPath() + File.separator + object;
                Plugin plugin = Plugin.loadFromFile(string);
                if (plugin == null || !plugin.isValid()) continue;
                if (this.getAvailablePlugins() == null) {
                    this.AVAILABLE_PLUGINS = new Hashtable();
                }
                this.getAvailablePlugins().put(plugin.getName(), plugin);
            }
        }
        if (this.getAvailablePlugins() != null && this.getAvailablePlugins().size() > 0) {
            this.writeAvailablePlugins();
        }
    }

    public void checkForAvailablePluginsRemotely(boolean bl) {
        PluginValidator.getInstance().refreshRemoteAvailablePlugins();
        if (bl || this.getAvailablePlugins() == null) {
            PluginManager.getInstance().clearAvailablePlugins();
            this.AVAILABLE_PLUGINS = PluginValidator.getInstance().getAvailablePlugins();
        } else {
            Hashtable hashtable = PluginValidator.getInstance().getAvailablePlugins();
            if (hashtable != null && hashtable.size() > 0 && this.AVAILABLE_PLUGINS == null) {
                this.AVAILABLE_PLUGINS = new Hashtable();
            }
            Set<Map.Entry<String, IPlugin>> set = this.getAvailablePlugins().entrySet();
            for (Map.Entry<String, IPlugin> entry : set) {
                this.AVAILABLE_PLUGINS.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.getAvailablePlugins() != null) {
            this.writeAvailablePlugins();
        }
    }

    public void downloadPlugin(String string) {
    }

    public InstallObserver installPlugin(IPlugin iPlugin, Collection<Observer> collection) throws PluginInstallException {
        if (!iPlugin.isValid()) {
            throw new PluginInstallException("Plugin " + iPlugin.getName() + " invalid");
        }
        PluginManager.getInstance().verifyPluginEnvironment();
        if (!this.pluginExists(iPlugin.getName())) {
            InstallObserver installObserver = new InstallObserver(iPlugin);
            if (collection == null) {
                collection = new HashSet<Observer>();
            }
            collection.add(installObserver);
            this.tryCancellingPreviousPluginDownload(iPlugin);
            PluginDownloader pluginDownloader = new PluginDownloader(iPlugin, collection);
            try {
                pluginDownloader.connect();
            }
            catch (IOException iOException) {
                System.out.println("PluginManager.installPlugin() - My downloader could not connect.");
                System.out.println(iOException.getMessage());
                pluginDownloader.sendNotification(PluginDownloader.DownloadState.CANCELLED_DOWNLOADING);
                return null;
            }
            PluginDownloader.PluginDownloaderWorker pluginDownloaderWorker = pluginDownloader.startDownload();
            this.DOWNLOADER_THREADS.put(iPlugin.getName(), pluginDownloaderWorker);
            return installObserver;
        }
        System.out.println("installPlugin() - This should only appear after the download is done. Try Cancelling NEXT");
        this.tryCancellingPreviousPluginDownload(iPlugin);
        this.verifyInstalledPlugins();
        this.INSTALLED_PLUGINS.put(iPlugin.getName(), iPlugin);
        this.writeInstalledPlugins();
        System.out.println("installPlugin() - Installed Plugins should be updated");
        this.runPlugin((Plugin)iPlugin);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCancellingPreviousPluginDownload(IPlugin iPlugin) {
        System.out.println("PluginManager::tryCancellingPreviousPluginDownload(" + iPlugin.getName() + ")");
        if (this.DOWNLOADER_THREADS != null && this.DOWNLOADER_THREADS.containsKey(iPlugin.getName())) {
            PluginDownloader.PluginDownloaderWorker pluginDownloaderWorker = this.DOWNLOADER_THREADS.get(iPlugin.getName());
            Object object = pluginDownloaderWorker;
            synchronized (object) {
                pluginDownloaderWorker.cancelDownload();
                pluginDownloaderWorker.interrupt();
                System.out.println("PluginManager::tryCancellingPreviousPluginDownload(" + iPlugin.getName() + ") Cancelled. (still not removed)");
            }
            object = this.DOWNLOADER_THREADS;
            synchronized (object) {
                this.DOWNLOADER_THREADS.remove(iPlugin.getName());
            }
        }
        System.out.println("PluginManager::tryCancellingPreviousPluginDownload(" + iPlugin.getName() + ") Nothing to cancel.");
    }

    public void uninstallPlugin(IPlugin iPlugin) {
        if (iPlugin == null) {
            return;
        }
        this.readInstalledPlugins();
        if (this.INSTALLED_PLUGINS.containsKey(iPlugin.getName())) {
            this.INSTALLED_PLUGINS.remove(iPlugin.getName());
        }
        this.writeInstalledPlugins();
        this.stopPlugin((Plugin)iPlugin);
    }

    public void runPlugin(Plugin plugin) {
        if (plugin == null || !this.pluginExists(plugin.getName()) || !plugin.isValid()) {
            return;
        }
        if (this.RUNNING_PLUGINS == null) {
            this.RUNNING_PLUGINS = new Hashtable();
            System.out.println("PluginManager.runPlugin(" + plugin.getName() + ") first plugin to run.");
        }
        if (this.RUNNING_PLUGINS.containsKey(plugin.getName())) {
            this.stopPlugin(plugin);
        }
        System.out.println("PluginManager.runPlugin(p) -> p.start()!");
        this.RUNNING_PLUGINS.put(plugin.getName(), plugin);
        try {
            System.out.println("PluginLoader.getInstance.runPlugin(ME!)");
            PluginLoader.getInstance().runPlugin(plugin);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopPlugin(Plugin plugin) {
        if (this.RUNNING_PLUGINS != null && this.RUNNING_PLUGINS.containsKey(plugin.getName())) {
            this.RUNNING_PLUGINS.remove(plugin.getName());
        }
        this.tryCancellingPreviousPluginDownload(plugin);
        PluginLoader.getInstance().stopPlugin(plugin);
    }

    static {
        PLUGINS_FOLDER = new File(PluginsSettings.PLUGINS_FOLDER.getValue());
    }
}

