/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.plugins.controllers.PluginManager;
import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.PluginDownloader;
import java.util.Observable;
import java.util.Observer;

public final class InstallObserver
implements Observer {
    public IPlugin plugin;
    public boolean done;

    public InstallObserver(IPlugin iPlugin) {
        this.plugin = iPlugin;
        this.done = false;
    }

    public void update(Observable observable, Object object) {
        PluginDownloader pluginDownloader = (PluginDownloader)observable;
        PluginDownloader.DownloadState downloadState = (PluginDownloader.DownloadState)((Object)object);
        if (downloadState == PluginDownloader.DownloadState.FINISHED_DOWNLOADING) {
            try {
                PluginManager.getInstance().installPlugin(this.plugin, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.done = true;
        } else if (downloadState == PluginDownloader.DownloadState.CANCELLED_DOWNLOADING) {
            this.done = true;
        } else if (downloadState == PluginDownloader.DownloadState.DOWNLOADED_CHUNK) {
            System.out.println("Downloaded %" + 100 * (pluginDownloader.getContentLength() / pluginDownloader.getDownloadedBytes()) + " of plugin " + this.plugin.getName());
        }
    }

    public boolean isDone() {
        return this.done;
    }
}

