/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.PluginValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaPlugin
implements IPlugin,
Serializable {
    private static final Log LOG = LogFactory.getLog(MetaPlugin.class);
    protected String name;
    protected String title;
    protected String version;
    protected String minimumVersion;
    protected String lastVersion;
    protected String author;
    protected String organization;
    protected String website;
    protected String downloadURL;
    protected String md5Hash;
    protected int size;

    public String asXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<plugin name=\"%s\" ");
        stringBuilder.append("title=\"%s\" ");
        stringBuilder.append("author=\"%s\" ");
        stringBuilder.append("organization=\"%s\" ");
        stringBuilder.append("version=\"%s\" ");
        stringBuilder.append("minimumFrostWireVersion=\"%s\" ");
        stringBuilder.append("lastFrostWireVersion=\"%s\" ");
        stringBuilder.append("website=\"%s\" ");
        stringBuilder.append("downloadURL=\"%s\" ");
        stringBuilder.append("MD5=\"%s\" ");
        stringBuilder.append("size=\"%s\"/>");
        return String.format(stringBuilder.toString(), this.getName(), this.getTitle(), this.getAuthor(), this.getOrganization(), this.getVersion(), this.getMinimumFrostWireVersionSupported(), this.getLastFrostWireVersionSupported(), this.getWebsite(), this.getDownloadURL(), this.getMD5Hash(), String.valueOf(this.getSize()));
    }

    public String getMD5Hash() {
        return this.md5Hash;
    }

    public void setMD5Hash(String string) {
        this.md5Hash = string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(String string) {
        if (string == null || string.equals("")) {
            this.setSize(0);
            return;
        }
        this.setSize(Integer.parseInt(string));
    }

    public void setSize(int n) {
        this.size = Math.abs(n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getMinimumFrostWireVersionSupported() {
        return this.minimumVersion;
    }

    public void setMinimumFrostWireVersionSupported(String string) {
        this.minimumVersion = string;
    }

    public String getLastFrostWireVersionSupported() {
        return this.lastVersion;
    }

    public void setLastFrostWireVersionSupported(String string) {
        this.lastVersion = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String string) {
        this.organization = string;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String string) {
        this.website = string;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String string) {
        this.downloadURL = string;
    }

    private boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public boolean isValid() {
        if (this.isEmpty(this.getName())) {
            LOG.error("Plugin has no name");
            return false;
        }
        if (this.isEmpty(this.getTitle())) {
            LOG.error("Plugin " + this.getName() + " has no title");
            return false;
        }
        if (this.getSize() < 1) {
            LOG.error("Plugin " + this.getName() + " has no size");
            return false;
        }
        if (!PluginValidator.validateMinimumVersion(this.getMinimumFrostWireVersionSupported())) {
            LOG.error("Plugin " + this.getName() + " didn't comply with minimum version validation");
            return false;
        }
        if (!PluginValidator.validateLastVersion(this.getLastFrostWireVersionSupported())) {
            LOG.error("Plugin " + this.getName() + " didn't comply with last version validation");
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    private void readObjectNoData() throws ObjectStreamException {
    }
}

