/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.models;

import com.frostwire.plugins.models.IPlugin;
import com.frostwire.plugins.models.MetaPlugin;
import com.frostwire.updates.UpdateManager;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PluginValidator
implements ContentHandler {
    private static final Log LOG = LogFactory.getLog(PluginValidator.class);
    private static PluginValidator INSTANCE;
    private static String AVAILABLE_PLUGINS_MANIFEST_URL;
    private static Hashtable AVAILABLE_PLUGINS;
    private MetaPlugin bufferMetaPlugin;

    private PluginValidator() {
    }

    public static PluginValidator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginValidator();
        }
        return INSTANCE;
    }

    public void refreshRemoteAvailablePlugins() {
        HttpURLConnection httpURLConnection = null;
        InputSource inputSource = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(AVAILABLE_PLUGINS_MANIFEST_URL).openConnection();
            String string = "FrostWire-PluginValidator/" + OSUtils.getOS() + "/" + LimeWireUtils.getLimeWireVersion();
            httpURLConnection.setRequestProperty("User-Agent", string);
            inputSource = new InputSource(httpURLConnection.getInputStream());
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            xMLReader.parse(inputSource);
            httpURLConnection.getInputStream().close();
            httpURLConnection.disconnect();
        }
        catch (IOException iOException) {
            System.out.println("PluginValidator.refreshRemoteValidPlugins() IOException " + iOException.toString());
        }
        catch (SAXException sAXException) {
            System.out.println("PluginValidator.refreshRemoteValidPlugins() SAXException " + sAXException.toString());
        }
    }

    public Hashtable getAvailablePlugins() {
        return AVAILABLE_PLUGINS;
    }

    private boolean validateHash(IPlugin iPlugin) {
        return true;
    }

    public static boolean validateMinimumVersion(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        return !UpdateManager.isFrostWireOld(string);
    }

    public static boolean validateLastVersion(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        return UpdateManager.isFrostWireOld(string);
    }

    private String tryGettingAttribute(Attributes attributes, String string) {
        return attributes.getValue(string) != null ? attributes.getValue(string) : null;
    }

    private MetaPlugin tryLoadingMetaPluginFromAttributes(Attributes attributes) {
        this.bufferMetaPlugin = new MetaPlugin();
        this.bufferMetaPlugin.setName(this.tryGettingAttribute(attributes, "name"));
        this.bufferMetaPlugin.setTitle(this.tryGettingAttribute(attributes, "title"));
        this.bufferMetaPlugin.setAuthor(this.tryGettingAttribute(attributes, "author"));
        this.bufferMetaPlugin.setOrganization(this.tryGettingAttribute(attributes, "organization"));
        this.bufferMetaPlugin.setVersion(this.tryGettingAttribute(attributes, "version"));
        this.bufferMetaPlugin.setMinimumFrostWireVersionSupported(this.tryGettingAttribute(attributes, "minimumFrostWireVersion"));
        this.bufferMetaPlugin.setLastFrostWireVersionSupported(this.tryGettingAttribute(attributes, "lastFrostWireVersion"));
        this.bufferMetaPlugin.setWebsite(this.tryGettingAttribute(attributes, "website"));
        this.bufferMetaPlugin.setDownloadURL(this.tryGettingAttribute(attributes, "downloadURL"));
        this.bufferMetaPlugin.setMD5Hash(this.tryGettingAttribute(attributes, "MD5"));
        this.bufferMetaPlugin.setSize(this.tryGettingAttribute(attributes, "size"));
        return this.bufferMetaPlugin;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("plugin")) {
            this.tryLoadingMetaPluginFromAttributes(attributes);
            if (this.bufferMetaPlugin != null) {
                if (AVAILABLE_PLUGINS == null) {
                    AVAILABLE_PLUGINS = new Hashtable();
                }
                if (this.bufferMetaPlugin.isValid()) {
                    AVAILABLE_PLUGINS.put(this.bufferMetaPlugin.getName(), this.bufferMetaPlugin);
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    static {
        AVAILABLE_PLUGINS_MANIFEST_URL = "http://plugins.frostwire.com/list";
    }
}

