/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.tests;

import com.frostwire.plugins.controllers.PluginLoader;
import com.frostwire.plugins.controllers.PluginManager;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PluginLoaderTest
extends TestCase {
    private static Log LOG = LogFactory.getLog(PluginLoaderTest.class);
    private PluginManager PM;
    private PluginLoader PL;
    private ExecutorService executorService;

    public PluginLoaderTest(String string) {
        super(string);
    }

    public void setUp() {
        if (this.PM != null) {
            return;
        }
        this.PM = PluginManager.getInstance();
    }

    public void testItCanFetchSingletonsFromMainThread() {
        String string = null;
        try {
            PythonInterpreter pythonInterpreter = new PythonInterpreter();
            pythonInterpreter.execfile("plugins/test/test.py");
            pythonInterpreter.exec("plugin = MyPlugin()");
            PyObject pyObject = pythonInterpreter.get("plugin");
            PyObject pyObject2 = pyObject.invoke("getPluginManagerInstance");
            string = pyObject2.invoke("hashCode").toString();
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage());
        }
        PluginLoaderTest.assertEquals(string, String.valueOf(this.PM.hashCode()));
    }

    public void testItCanFetchSingletonsFromPluginOnSeparateThread() {
        PluginLoaderTest.assertNotNull(this.PM);
        try {
            this.executorService = new ThreadPoolExecutor(10, 20, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            Future<String> future = this.executorService.submit(new GetPluginManagerHashCodeCallable());
            while (!future.isDone()) {
                LOG.info("waiting for future task...");
                Thread.currentThread();
                Thread.sleep(200L);
            }
            PluginLoaderTest.assertNotNull(future);
            PluginLoaderTest.assertTrue(future.isDone());
            PluginLoaderTest.assertFalse(future.isCancelled());
            String string = future.get();
            System.out.println("Result from this thread -> [" + String.valueOf(this.PM.hashCode()) + "]");
            System.out.println("Result from the future -> [" + string + "]");
            PluginLoaderTest.assertNotNull(string);
            PluginLoaderTest.assertNotNull(this.PM.hashCode());
            PluginLoaderTest.assertTrue(string.equals(String.valueOf(this.PM.hashCode())));
        }
        catch (Exception exception) {
            LOG.error(exception);
        }
    }

    private void pressEnter() {
        System.out.println("[Press Enter]");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            bufferedReader.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRunningClassFromDinamicallyAddedJar() throws Exception {
        LOG.info("java.home  = " + System.getProperty("java.home"));
        try {
            PluginLoader pluginLoader = PluginLoader.getInstance();
            String string = PluginsSettings.PLUGINS_FOLDER.getValue();
            String string2 = string + "/brooklyn.jar";
            pluginLoader.addJar2Classpath(string2);
            URLClassLoader uRLClassLoader = pluginLoader.getClassLoader4JarClasspath(string2);
            Class<?> clazz = uRLClassLoader.loadClass("brooklyn.HelloFromJar");
            LOG.info("I GOT THE brooklyn.HelloFromJar class " + clazz);
            PluginLoaderTest.assertNotNull(clazz);
            Method method = clazz.getMethod("sayHello", null);
            PluginLoaderTest.assertNotNull(method);
            Object obj = clazz.newInstance();
            method.invoke(obj, (Object[])null);
        }
        catch (Exception exception) {
            LOG.error(exception);
            exception.printStackTrace();
            throw exception;
        }
    }

    public void testRunningPluginFromJar() throws Exception {
        PluginLoader pluginLoader = PluginLoader.getInstance();
        String string = PluginsSettings.PLUGINS_FOLDER.getValue();
        String string2 = string + "/twoScriptsTest.jar";
        try {
            pluginLoader.runPythonFromJar("from twoScriptsTest.guba import test", string2);
        }
        catch (Exception exception) {
            LOG.error(exception);
            throw exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GetPluginManagerHashCodeCallable
    implements Callable<String> {
        GetPluginManagerHashCodeCallable() {
        }

        @Override
        public String call() {
            String string = null;
            try {
                PythonInterpreter pythonInterpreter = new PythonInterpreter();
                pythonInterpreter.execfile("plugins/test/test.py");
                pythonInterpreter.exec("plugin = MyPlugin()");
                PyObject pyObject = pythonInterpreter.get("plugin");
                PyObject pyObject2 = pyObject.invoke("getPluginManagerInstance");
                string = pyObject2.invoke("hashCode").toString();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            System.out.println("CALL() -> " + string);
            return string;
        }
    }
}

