/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.plugins.tests;

import com.frostwire.plugins.controllers.PluginManager;
import com.frostwire.plugins.models.Plugin;
import com.limegroup.gnutella.settings.PluginsSettings;
import java.io.File;
import junit.framework.TestCase;

public class PluginManagerTest
extends TestCase {
    private PluginManager PLUGIN_MANAGER;
    private String PLUGIN_FOLDER = PluginsSettings.PLUGINS_FOLDER.getValue();

    public PluginManagerTest(String string) {
        super(string);
    }

    public void setUp() {
        this.PLUGIN_MANAGER = PluginManager.getInstance();
    }

    public void testInstallAndRunPlugin() {
        System.out.println("\n=========");
        System.out.println("PluginManagerTest.testInstallAndRunPlugin()");
        System.out.println("=========");
        if (!this.PLUGIN_MANAGER.pluginExists("brooklyn.jar")) {
            System.out.println("Aborting, brooklyn.jar not there");
            return;
        }
        try {
            this.PLUGIN_MANAGER.checkForAvailablePluginsLocally(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.PLUGIN_MANAGER.getAvailablePlugins().containsKey("brooklyn")) {
            System.out.println("Brooklyn is available!");
            Plugin plugin = Plugin.loadFromFile(this.PLUGIN_FOLDER + File.separator + "brooklyn.jar");
            if (this.PLUGIN_MANAGER.isPluginInstalled(plugin)) {
                System.out.println("Plugin is installed, let's PLUGIN_MANAGER.runPlugin(p)");
                this.PLUGIN_MANAGER.runPlugin(plugin);
                try {
                    boolean bl = false;
                    int n = 10;
                    while (n > 0) {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                        if (--n < 7 && !bl) {
                            this.PLUGIN_MANAGER.stopPlugin(plugin);
                            bl = true;
                        }
                        System.out.println(n + "...");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                System.out.println("Plugin is not installed. Installing. Run Test again please.");
                try {
                    this.PLUGIN_MANAGER.installPlugin(plugin, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

