/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public final class HostilesMetaData
implements Serializable {
    private static final long serialVersionUID = -3319232630233496049L;
    private Hashtable<Byte, Object> _properties;
    private transient Object _statusLock;
    public static final transient Byte DATE = 3;
    public static final transient Byte MD5 = 1;
    public static final transient Byte SEED_RATIO = 5;
    public static final transient Byte STATUS = 4;
    public static final transient Byte TORRENT_DATA_LOCATION = 7;
    public static final transient Byte TORRENT_FILE_LOCATION = 6;
    public static final transient Byte TORRENT_URL = 2;
    public static final transient Byte VERSION = 0;
    public static final transient Byte STATUS_ERRORED = 0;
    public static final transient Byte STATUS_INITIATED = 1;
    public static final transient Byte STATUS_DOWNLOADING = 2;
    public static final transient Byte STATUS_DOWNLOADED = 3;
    public static final transient Byte STATUS_PROCESSING = 4;
    public static final transient Byte STATUS_PROCESSED = 5;

    public final long get_date() {
        Long l = (Long)this.get_property(DATE);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public final String get_md5() {
        return (String)this.get_property(MD5);
    }

    private final Object get_property(Byte by) {
        try {
            if (this._properties.containsKey(by)) {
                return this._properties.get(by);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final int get_seedRatio() {
        Integer n = new Integer(-1);
        try {
            n = (Integer)this.get_property(SEED_RATIO);
        }
        catch (NullPointerException nullPointerException) {
            n = new Integer(-1);
        }
        if (n == null) {
            n = new Integer(-1);
        }
        return n;
    }

    public final Byte get_status() {
        return (Byte)this.get_property(STATUS);
    }

    public final String get_torrent_data_save_location() {
        return (String)this.get_property(TORRENT_DATA_LOCATION);
    }

    public final String get_torrent_file_save_location() {
        return (String)this.get_property(TORRENT_FILE_LOCATION);
    }

    public final String get_torrentURL() {
        return (String)this.get_property(TORRENT_URL);
    }

    public final String get_version() {
        return (String)this.get_property(VERSION);
    }

    public final boolean is_valid() {
        return this.get_date() >= 0L && this.get_seedRatio() >= 0 && this.get_md5() != null && this.get_torrentURL() != null && this.get_version() != null;
    }

    public final void set_date(long l) {
        this.set_property(DATE, new Long(l));
    }

    public final void set_md5(String string) {
        this.set_property(MD5, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void set_property(Byte by, Object object) {
        assert (by != null);
        assert (object != null);
        if (this._properties == null) {
            this._properties = new Hashtable();
        }
        if (this._statusLock == null) {
            this._statusLock = new Object();
        }
        Object object2 = this._statusLock;
        synchronized (object2) {
            this._properties.put(by, object);
        }
    }

    public final void set_seedRatio(int n) {
        this.set_property(SEED_RATIO, new Integer(n));
    }

    public final void set_status(Byte by) {
        this.set_property(STATUS, by);
    }

    public final void set_torrent_data_save_location(String string) {
        this.set_property(TORRENT_DATA_LOCATION, string);
    }

    public final void set_torrent_file_save_location(String string) {
        this.set_property(TORRENT_FILE_LOCATION, string);
    }

    public final void set_torrentURL(String string) {
        this.set_property(TORRENT_URL, string);
    }

    public final void set_version(String string) {
        this.set_property(VERSION, string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_date : " + this.get_date() + "\n");
        if (this.get_md5() != null) {
            stringBuffer.append("_md5 : " + this.get_md5() + "\n");
        }
        if (this.get_status() != null) {
            String[] stringArray = new String[]{"ERRORED", "INITIATED", "DOWNLOADING", "DOWNLOADED", "PROCESSING", "PROCESSED"};
            stringBuffer.append("_status : " + stringArray[this.get_status()] + "\n");
        }
        if (this.get_torrentURL() != null) {
            stringBuffer.append("_torrentURL : " + this.get_torrentURL() + "\n");
        }
        if (this.get_version() != null) {
            stringBuffer.append("_version : " + this.get_version() + "\n");
        }
        if (this.get_torrent_file_save_location() != null) {
            stringBuffer.append("_torrent_file_location : " + this.get_torrent_file_save_location() + "\n");
        }
        if (this.get_torrent_data_save_location() != null) {
            stringBuffer.append("_torrent_file_data_location : " + this.get_torrent_data_save_location() + "\n");
        }
        return stringBuffer.toString();
    }
}

