/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import com.aelitis.azureus.core.AzureusCoreException;
import com.frostwire.CoreFrostWireUtils;
import com.frostwire.GuiFrostWireUtils;
import com.frostwire.bittorrent.AzureusStarter;
import com.frostwire.updates.HostilesMetaData;
import com.frostwire.updates.UpdateMessage;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.library.SharingUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.limewire.io.InvalidDataException;

public final class HostilesUpdater
implements DownloadManagerListener {
    private static int TORRENT_DOWNLOAD_THREAD_MAX_MINUTES = 10;
    private static HostilesUpdater INSTANCE = null;
    private UpdateMessage _updateMessage = null;
    private HostilesMetaData _hostilesMetaData = null;
    private boolean _alreadyPostProcessed = false;
    private DownloadManager _manager = null;
    private CountDownLatch _processingLatch = new CountDownLatch(1);

    private HostilesUpdater() {
    }

    public static HostilesUpdater getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostilesUpdater();
        }
        return INSTANCE;
    }

    public void processMessage(UpdateMessage updateMessage) {
        if (this.isMessageInvalid(updateMessage)) {
            return;
        }
        this._updateMessage = updateMessage;
        if (this.alreadyHaveValidHostilesTxt()) {
            try {
                this.deleteOlderHostiles();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            return;
        }
        this.checkHostilesMetaData();
        this.startDownloadAndWait(TORRENT_DOWNLOAD_THREAD_MAX_MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void postProcessMessage(boolean bl) throws IOException {
        try {
            File file;
            File file2;
            block20: {
                file2 = new File(this.getAppSpecialShareFolder(), "hostiles.txt." + this._hostilesMetaData.get_version() + ".zip");
                if (this._hostilesMetaData == null) {
                    throw new InvalidDataException("No HostilesMedataData available");
                }
                file = new File(this.getHostilesTxtPath());
                boolean bl2 = true;
                if (file.exists() && !CoreFrostWireUtils.checkMD5(file, this._hostilesMetaData.get_md5())) {
                    file.delete();
                    bl2 = false;
                }
                try {
                    this.deleteOlderHostiles();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!bl2 || !file.exists()) {
                    try {
                        GuiFrostWireUtils.unzip(file2, GuiFrostWireUtils.getPreferencesFolder());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        file2.delete();
                        this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
                        if (!bl) break block20;
                        this._alreadyPostProcessed = true;
                        this.notifyHostileUpdaterWorkerThread();
                        if (bl) {
                            this.notifyHostileUpdaterWorkerThread();
                        }
                        return;
                    }
                }
            }
            if (!file.exists()) {
                throw new IOException("Zip file " + file.getAbsolutePath() + " doesn't exist");
            }
            if (!GuiFrostWireUtils.checkMD5(file, this._hostilesMetaData.get_md5())) {
                file2.delete();
                file.delete();
                throw new InvalidDataException("MD5 of unzipped file does not coincide with " + this._hostilesMetaData.get_md5());
            }
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_PROCESSED);
            System.out.println("IPFilter has black listed hosts? (before) " + GuiCoreMediator.getIpFilter().hasBlacklistedHosts());
            GuiCoreMediator.getIpFilter().forceRefreshHosts();
            System.out.println("IPFilter has black listed hosts? (after) " + GuiCoreMediator.getIpFilter().hasBlacklistedHosts());
            bl = true;
        }
        catch (InvalidDataException invalidDataException) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
        }
        catch (IOException iOException) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            System.out.println("Unzip FAIL! " + iOException.getMessage());
            throw iOException;
        }
        catch (Exception exception) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
        }
        finally {
            if (bl) {
                this.notifyHostileUpdaterWorkerThread();
            }
        }
    }

    private boolean alreadyHaveValidHostilesTxt() {
        try {
            File file = new File(this.getHostilesTxtPath());
            if (!file.exists()) {
                throw new Exception("HostilesUpdater.alreadyHaveValidHostilesTxt(): Had no hostiles.txt - start from scratch");
            }
            if (CoreFrostWireUtils.checkMD5(file, this._updateMessage.getRemoteMD5())) {
                System.out.println("HostilesUpdater.alreadyHaveValidHostilesTxt() - Done. We have a good hostiles.txt already");
                return true;
            }
            file.delete();
            file.deleteOnExit();
            throw new Exception("HostilesUpdater.alreadyHaveValidHostilesTxt() - hostiles.txt is old or invalid");
        }
        catch (Exception exception) {
            this._hostilesMetaData = this.initHostilesMetaData(this._updateMessage);
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_INITIATED);
            return false;
        }
    }

    private void checkHostilesMetaData() {
        try {
            if (this._hostilesMetaData == null) {
                this._hostilesMetaData = this.getLastHostilesMetaData();
                if (this._hostilesMetaData == null) {
                    throw new InvalidDataException("HostilesUpdater.checkHostilesMetaData(): We had no hostiles.dat");
                }
            }
            if (this._hostilesMetaData.get_status() == HostilesMetaData.STATUS_ERRORED) {
                throw new InvalidDataException("HostilesUpdater.checkHostilesMetaData(): Something went wrong the last time");
            }
            if (!this._hostilesMetaData.get_md5().equals(this._updateMessage.getRemoteMD5())) {
                throw new InvalidDataException("HostilesUpdater.checkHostilesMetaData(): Had a good metadata but it was out of date");
            }
        }
        catch (InvalidDataException invalidDataException) {
            System.out.println("HostilesUpdater.processMessage() " + invalidDataException.getMessage());
            this._hostilesMetaData = this.initHostilesMetaData(this._updateMessage);
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_INITIATED);
        }
    }

    private final void startDownloadAndWait(int n) {
        try {
            this.downloadHostiles(this._hostilesMetaData);
            if (this._alreadyPostProcessed) {
                return;
            }
            if (this._manager != null && this._manager.getState() == 70) {
                return;
            }
            if (this._manager.getState() == 60) {
                this.postProcessMessage(true);
                return;
            }
            if (this._manager.getState() == 0) {
                this._manager.startDownload();
            }
            this._processingLatch.await();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            this.notifyHostileUpdaterWorkerThread();
            return;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            this.notifyHostileUpdaterWorkerThread();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            this.notifyHostileUpdaterWorkerThread();
        }
    }

    private final void downloadHostiles(HostilesMetaData hostilesMetaData) throws Exception {
        File file = this.getAppSpecialShareFolder();
        File file2 = new File(this.getAppSpecialShareFolder() + File.separator + "hostiles.txt." + hostilesMetaData.get_version() + ".zip.torrent");
        if (!file.exists()) {
            file.mkdir();
            file.setWritable(true);
        }
        CoreFrostWireUtils.downloadTorrentFile(hostilesMetaData.get_torrentURL(), file2);
        assert (file2.exists());
        String string = this.getAppSpecialShareFolder().getAbsolutePath();
        this._hostilesMetaData.set_torrent_file_save_location(file2.getAbsolutePath());
        this._hostilesMetaData.set_torrent_data_save_location(string);
        this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_DOWNLOADING);
        File file3 = new File(string + File.separator + "hostiles.txt." + hostilesMetaData.get_version() + ".zip");
        if (file3.exists() && file3.isFile()) {
            boolean bl = true;
            try {
                this.postProcessMessage(false);
            }
            catch (IOException iOException) {
                bl = false;
                file3.delete();
                this._manager = GuiFrostWireUtils.startTorrentDownload(file2.getAbsolutePath(), string, this);
            }
            if (bl) {
                this.notifyHostileUpdaterWorkerThread();
            }
        } else {
            this._manager = GuiFrostWireUtils.startTorrentDownload(file2.getAbsolutePath(), string, this);
        }
    }

    private boolean isMessageInvalid(UpdateMessage updateMessage) {
        return updateMessage == null || updateMessage.getVersion() == null || updateMessage.getVersion().equals("") || updateMessage.getTorrent() == null || updateMessage.getTorrent().equals("") || updateMessage.getRemoteMD5() == null || updateMessage.getRemoteMD5().equals("");
    }

    public final String getHostilesTxtPath() {
        return CoreFrostWireUtils.getPreferencesFolder() + File.separator + "hostiles.txt";
    }

    private final String getHostilesDatPath() throws IOException {
        return CoreFrostWireUtils.getPreferencesFolder().getCanonicalPath() + File.separator + "hostiles.dat";
    }

    private final File getAppSpecialShareFolder() throws IOException {
        return SharingUtils.APPLICATION_SPECIAL_SHARE;
    }

    private final HostilesMetaData getLastHostilesMetaData() {
        HostilesMetaData hostilesMetaData = null;
        try {
            File file = new File(this.getHostilesDatPath());
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            hostilesMetaData = (HostilesMetaData)objectInputStream.readObject();
            fileInputStream.close();
            if (hostilesMetaData == null) {
                return null;
            }
            System.out.println(hostilesMetaData);
            if (!hostilesMetaData.is_valid()) {
                if (file.exists()) {
                    file.delete();
                }
                hostilesMetaData.set_status(HostilesMetaData.STATUS_ERRORED);
                return hostilesMetaData;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hostilesMetaData;
    }

    private final HostilesMetaData initHostilesMetaData(UpdateMessage updateMessage) {
        HostilesMetaData hostilesMetaData = new HostilesMetaData();
        hostilesMetaData.set_date(Calendar.getInstance().getTimeInMillis());
        hostilesMetaData.set_md5(updateMessage.getRemoteMD5());
        hostilesMetaData.set_status(HostilesMetaData.STATUS_INITIATED);
        hostilesMetaData.set_torrentURL(updateMessage.getTorrent());
        hostilesMetaData.set_version(updateMessage.getVersion());
        this._hostilesMetaData = hostilesMetaData;
        return hostilesMetaData;
    }

    private final void saveHostilesMetaData(HostilesMetaData hostilesMetaData, Byte by) {
        try {
            String string = this.getHostilesDatPath();
            hostilesMetaData.set_status(by);
            hostilesMetaData.set_date(System.currentTimeMillis());
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(hostilesMetaData);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void deleteOlderHostiles() throws InvalidDataException, IOException, AzureusCoreException, GlobalManagerDownloadRemovalVetoException {
        File[] fileArray;
        if (this._updateMessage == null) {
            throw new InvalidDataException("There no UpdateMessage to know which is the newest hostiles file.");
        }
        if (this._hostilesMetaData == null) {
            this.checkHostilesMetaData();
        }
        File file = this.getAppSpecialShareFolder();
        for (File file2 : fileArray = file.listFiles()) {
            if (!file2.getName().startsWith("hostiles.txt") || file2.getName().endsWith(this._hostilesMetaData.get_version() + ".zip.torrent") || file2.getName().equals("hostiles.txt." + this._hostilesMetaData.get_version() + ".zip")) continue;
            if (file2.isDirectory()) {
                CoreFrostWireUtils.deleteFolderRecursively(file2);
            } else {
                List list = AzureusStarter.getAzureusCore().getGlobalManager().getDownloadManagers();
                for (DownloadManager downloadManager : list) {
                    if (!downloadManager.getSaveLocation().equals(file2)) continue;
                    downloadManager.stopIt(71, true, true);
                    AzureusStarter.getAzureusCore().getGlobalManager().removeDownloadManager(downloadManager);
                }
                file2.delete();
            }
            System.out.println("HostilesUpdater.deleteOlderHostiles(): Deleted " + file2.getName());
        }
    }

    private final void notifyHostileUpdaterWorkerThread() {
        this._alreadyPostProcessed = true;
        if (this._processingLatch != null) {
            this._processingLatch.countDown();
        }
    }

    public void completionChanged(DownloadManager downloadManager, boolean bl) {
    }

    public void filePriorityChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
    }

    public void positionChanged(DownloadManager downloadManager, int n, int n2) {
    }

    public void stateChanged(DownloadManager downloadManager, int n) {
        if (this._manager == null && downloadManager != null) {
            this._manager = downloadManager;
        }
        CoreFrostWireUtils.printDiskManagerPieces(downloadManager.getDiskManager());
        CoreFrostWireUtils.printDownloadManagerStatus(downloadManager);
        if (this.torrentDataDownloadedToDisk()) {
            try {
                this.postProcessMessage(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        System.out.println("HostilesUpdater.stateChanged() - " + n + " completed: " + downloadManager.isDownloadComplete(false));
        if (n == 60) {
            System.out.println("HostilesUpdater.stateChanged() - SEEDING!");
            try {
                this.postProcessMessage(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (n == 100) {
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            System.out.println(this._manager.getErrorDetails());
            System.out.println("HostilesUpdater: ERROR - stopIt, startDownload!");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            try {
                AzureusStarter.getAzureusCore().getGlobalManager().removeDownloadManager(downloadManager, false, true);
                this.processMessage(this._updateMessage);
            }
            catch (GlobalManagerDownloadRemovalVetoException globalManagerDownloadRemovalVetoException) {
                globalManagerDownloadRemovalVetoException.printStackTrace();
            }
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_INITIATED);
        } else if (n == 50) {
            System.out.println("stateChanged(STATE_DOWNLOADING)");
        } else if (n == 40) {
            System.out.println("stateChanged(STATE_READY)");
            downloadManager.startDownload();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_DOWNLOADING);
        }
    }

    private boolean torrentDataDownloadedToDisk() {
        if (this._manager == null || this._manager.getDiskManager() == null) {
            return false;
        }
        String string = this._hostilesMetaData.get_torrent_data_save_location();
        File file = new File(string);
        System.out.println(file.length());
        DiskManager diskManager = this._manager.getDiskManager();
        boolean bl = diskManager.filesExist();
        int n = diskManager.getPercentDone();
        long l = diskManager.getTotalLength();
        int n2 = diskManager.getCompleteRecheckStatus();
        return file.exists() && file.length() == l && n == 1000 && n2 == -1;
    }

    public void downloadComplete(DownloadManager downloadManager) {
        System.out.println("HostilesUpdater.downloadComplete()!!!!");
        CoreFrostWireUtils.printDownloadManagerStatus(this._manager);
        File file = null;
        try {
            file = new File(this.getAppSpecialShareFolder(), "hostiles.txt." + this._hostilesMetaData.get_version() + ".zip");
            if (file.exists()) {
                this.postProcessMessage(true);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.saveHostilesMetaData(this._hostilesMetaData, HostilesMetaData.STATUS_ERRORED);
        }
    }
}

