/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.updates;

import com.frostwire.overlays.OverlayImageManager;
import com.frostwire.settings.UpdateManagerSettings;
import com.frostwire.updates.InstallerUpdater;
import com.frostwire.updates.UpdateMessage;
import com.frostwire.updates.UpdateMessageReader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.OverlayAd;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateManager
implements Serializable {
    private static final long serialVersionUID = -3312314587704399041L;
    private static final int OPTION_OPEN_URL = 1;
    private static final int OPTION_LATER = 0;
    private static final int OPTION_DOWNLOAD_TORRENT = 2;
    public static boolean DEBUGGING_NON_UI_MESSAGES = false;
    private static transient HashSet<UpdateMessage> _seenMessages;
    transient Timer _timer = null;
    transient UpdateMessage _updateMessage = null;
    transient HashSet<UpdateMessage> _announcements = null;
    private static UpdateManager INSTANCE;
    private Date _serverTime = null;

    public static void scheduleUpdateCheckTask(int n, final String string) {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                System.out.println("UpdateManager.scheduleUpdateCheckTask() - TimerTask.run()");
                UpdateManager updateManager = UpdateManager.getInstance();
                updateManager.checkForUpdates(string);
            }
        };
        UpdateManager.getInstance().getTimer().schedule(timerTask, n * 1000);
    }

    public static void scheduleUpdateCheckTask(int n) {
        UpdateManager.scheduleUpdateCheckTask(n, null);
    }

    public void updateOverlays(List<UpdateMessage> list, final UpdateMessageReader updateMessageReader) {
        System.out.println("UpdateManager.updateOverlays() invoked.");
        if (list == null) {
            System.out.println("UpdateManager.updateOverlays() Skipping, no overlays");
            return;
        }
        Iterator<UpdateMessage> iterator = list.iterator();
        UpdateMessage updateMessage = null;
        while (iterator.hasNext()) {
            updateMessage = iterator.next();
            final SearchResultDisplayer searchResultDisplayer = SearchMediator.RESULT_DISPLAYER;
            final OverlayAd overlayAd = searchResultDisplayer.getOverlayAd();
            String string = updateMessage.getUrl();
            boolean bl = string != null && !string.equals("");
            String string2 = updateMessage.getTorrent();
            OverlayImageManager overlayImageManager = OverlayImageManager.getInstance();
            String string3 = null;
            try {
                string3 = overlayImageManager.getCachedImagePath(updateMessage.getSrc(), updateMessage.getRemoteMD5());
                if (OSUtils.isWindows()) {
                    string3 = "file:///" + string3.substring("file://".length());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                string3 = updateMessage.getSrc();
            }
            final UISettings.ImageInfoImpl imageInfoImpl = new UISettings.ImageInfoImpl(updateMessage.isIntro(), string3, bl, string, string2);
            if (updateMessage.isIntro() && !updateMessageReader.isIntroLoaded()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        overlayAd.updateIntroInfo(imageInfoImpl);
                        updateMessageReader._introloaded = true;
                        try {
                            searchResultDisplayer.setOverlayAd(overlayAd);
                            searchResultDisplayer.refreshOverlayAd();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            updateMessageReader._introloaded = false;
                        }
                        updateMessageReader._introloaded = true;
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else if (!updateMessage.isIntro() && !updateMessageReader.isOtherLoaded()) {
                System.out.println("UpdateManager.updateOverlays() - About to update secondary overlay - " + imageInfoImpl.getImageUrl());
                overlayAd.updateAfterSearchInfo(imageInfoImpl);
                updateMessageReader._otherloaded = true;
            }
            overlayAd.updateTheme();
        }
    }

    public Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer();
        }
        return this._timer;
    }

    public void terminateUpdateCheckTask() {
        this._timer.cancel();
        this._timer.purge();
    }

    private UpdateManager() {
    }

    public void setServerTime(String string) {
        this._serverTime = null;
        try {
            this._serverTime = new Date(Long.parseLong(string));
        }
        catch (Exception exception) {
            System.out.println("Warning: UpdateManager.setServerTime(): Could not set time from server, using local time");
        }
        if (this._serverTime == null) {
            this._serverTime = Calendar.getInstance().getTime();
        }
    }

    public Date getServerTime() {
        return this._serverTime;
    }

    public void checkForUpdates() {
        this.checkForUpdates(null);
    }

    public void checkForUpdates(String string) {
        System.out.println("UpdateManager.checkForUpdates() - Invoked");
        UpdateMessageReader updateMessageReader = new UpdateMessageReader();
        updateMessageReader.setUpdateURL(string);
        updateMessageReader.readUpdateFile();
        if (DEBUGGING_NON_UI_MESSAGES) {
            System.out.println("UpdateManager.checkForUpdates: Only processing Non UI Messages [DEBUGGING_NON_UI_MESSAGES=true]");
            return;
        }
        this.handlePossibleUpdateMessage(updateMessageReader);
        if (updateMessageReader.hasAnnouncements()) {
            this.attemptShowAnnouncements(updateMessageReader.getAnnouncements());
        }
        this.handlePossibleOverlayMessages(updateMessageReader);
    }

    private void handlePossibleOverlayMessages(UpdateMessageReader updateMessageReader) {
        if (!UpdateManagerSettings.SHOW_PROMOTION_OVERLAYS.getValue()) {
            System.out.println("UpdateManager.checkForUpdates() - Overlays OFF, forcing default overlays.");
            this.updateOverlays(updateMessageReader.getDefaultOverlays(), updateMessageReader);
        } else if (updateMessageReader.hasOverlays()) {
            System.out.println("UpdateManager.checkForUpdates() - We have overlays to update.");
            this.updateOverlays(updateMessageReader.getOverlays(), updateMessageReader);
        } else {
            System.out.println("UpdateManager.checkForUpdates() - Seems like there's no overlays.");
        }
    }

    private void handlePossibleUpdateMessage(UpdateMessageReader updateMessageReader) {
        UpdateMessage updateMessage = updateMessageReader.getUpdateMessage();
        if (updateMessageReader.hasUpdateMessage() && updateMessage.getVersion() != null && !updateMessage.getVersion().trim().equals("") && UpdateManager.isFrostWireOld(updateMessage.getVersion())) {
            boolean bl;
            boolean bl2 = updateMessage.getUrl() != null;
            boolean bl3 = bl = updateMessage.getTorrent() != null;
            if (OSUtils.isWindows()) {
                if (bl2 && !bl) {
                    this.showUpdateMessage(updateMessage);
                } else if (bl) {
                    new InstallerUpdater(updateMessage).start();
                }
            } else if (OSUtils.isLinux()) {
                if (OSUtils.isUbuntu()) {
                    if (bl) {
                        new InstallerUpdater(updateMessage).start();
                    } else {
                        this.showUpdateMessage(updateMessage);
                    }
                } else if (bl2) {
                    this.showUpdateMessage(updateMessage);
                }
            } else if (OSUtils.isMacOSX() && bl2) {
                this.showUpdateMessage(updateMessage);
            }
        }
    }

    public void showUpdateMessage(UpdateMessage updateMessage) {
        String string = updateMessage.getMessageType().equals("update") ? "New FrostWire Update Available" : "FrostWire Team Announcement";
        int n = 2;
        if (updateMessage.getUrl() != null && !updateMessage.getUrl().trim().equals("")) {
            System.out.println("\t" + updateMessage.getUrl());
            n |= 0;
        }
        Object[] objectArray = new String[3];
        if (updateMessage.getTorrent() != null) {
            objectArray[2] = new String("Download Torrent");
        } else {
            objectArray = new String[]{new String("Thanks, but not now"), new String("Go to webpage")};
        }
        int n2 = JOptionPane.showOptionDialog(null, updateMessage.getMessage(), string, n, 1, null, objectArray, null);
        if (n2 == 1) {
            GUIMediator.openURL(updateMessage.getUrl());
        } else if (n2 == 2) {
            UpdateManager.openTorrent(updateMessage.getTorrent());
        }
    }

    public void attemptShowAnnouncements(HashSet<UpdateMessage> hashSet) {
        for (UpdateMessage updateMessage : hashSet) {
            if (updateMessage.isShownOnce() && this.haveShownMessageBefore(updateMessage) || updateMessage.getUrl() == null || updateMessage.getUrl().trim().equals("")) continue;
            this.showUpdateMessage(updateMessage);
        }
    }

    private void loadSeenMessages() {
        File file = new File(LimeWireUtils.getRequestedUserSettingsLocation(), "seenMessages.dat");
        _seenMessages = new HashSet();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("UpdateManager.loadSeenMessages() - Cannot create file to deserialize");
            }
            return;
        }
        if (file.length() == 0L) {
            return;
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            _seenMessages = (HashSet)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("UpdateManager.loadSeenMessages() - Cannot deserialize - ");
            System.out.println(exception);
        }
    }

    private void saveSeenMessages() {
        if (_seenMessages == null || _seenMessages.size() < 1) {
            return;
        }
        File file = new File(CommonUtils.getUserSettingsDir(), "seenMessages.dat");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                System.out.println("UpdateManager.saveSeenMessages() cannot create file to serialize seen messages");
            }
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(_seenMessages);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("UpdateManager.saveSeenMessages() - Cannot serialize.");
            exception.printStackTrace();
        }
    }

    public boolean haveShownMessageBefore(UpdateMessage updateMessage) {
        if (!updateMessage.isShownOnce()) {
            return false;
        }
        this.loadSeenMessages();
        if (_seenMessages == null || _seenMessages.size() == 0 || !_seenMessages.contains(updateMessage)) {
            if (_seenMessages == null) {
                _seenMessages = new HashSet();
            }
            _seenMessages.add(updateMessage);
            this.saveSeenMessages();
            return false;
        }
        return true;
    }

    public static boolean isFrostWireOld(String string) {
        if (string == null) {
            return false;
        }
        String string2 = LimeWireUtils.getLimeWireVersion();
        if (string2.equals(string)) {
            return false;
        }
        try {
            String[] stringArray = string2.split("\\.");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            String[] stringArray2 = string.split("\\.");
            int n4 = Integer.parseInt(stringArray2[0]);
            int n5 = Integer.parseInt(stringArray2[1]);
            int n6 = Integer.parseInt(stringArray2[2]);
            if (n < n4) {
                return true;
            }
            if (n == n4 && n2 < n5) {
                return true;
            }
            if (n == n4 && n2 == n5 && n3 < n6) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static synchronized UpdateManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    public static void openTorrent(String string) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getScheme();
            if (string2 == null || !string2.equalsIgnoreCase("http")) {
                return;
            }
            String string3 = uRI.getAuthority();
            if (string3 == null || string3.equals("") || string3.indexOf(32) != -1) {
                return;
            }
            GUIMediator.instance().openTorrentURI(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.out.println(uRISyntaxException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing UpdateManager");
        DEBUGGING_NON_UI_MESSAGES = true;
        UpdateManager.scheduleUpdateCheckTask(0, "http://update1.frostwire.com/mock.php");
    }

    static {
        INSTANCE = null;
    }
}

