/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent;

import com.frostwire.bittorrent.BTMetaInfoBTFM;
import com.limegroup.bittorrent.BTData;
import com.limegroup.bittorrent.BTDataImpl;
import com.limegroup.bittorrent.TorrentContext;
import com.limegroup.bittorrent.TorrentFileSystem;
import com.limegroup.bittorrent.ValueException;
import com.limegroup.bittorrent.bencoding.Token;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.serial.BTDiskManagerMemento;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMemento;
import com.limegroup.gnutella.downloader.serial.BTMetaInfoMementoImpl;
import com.limegroup.gnutella.http.URIUtils;
import com.limegroup.gnutella.security.SHA1;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTMetaInfo
extends BTMetaInfoBTFM {
    private static final Log LOG = LogFactory.getLog(BTMetaInfo.class);
    private static final byte[] VERIFIED_HASH = new byte[0];
    private final List<byte[]> _hashes;
    private final int _pieceLength;
    private final TorrentFileSystem fileSystem;
    private final byte[] _infoHash;
    private final URN _infoHashURN;
    private final URI[] _trackers;
    private FileDesc _desc = null;
    private final BTDiskManagerMemento diskManagerData;
    private TorrentContext context;
    private long uploadedBefore;
    private volatile long uploadedNow;
    private final float historicRatio;
    private final boolean isPrivate;
    private byte[] _rawBytes;

    public int getPieceLength() {
        return this._pieceLength;
    }

    public TorrentFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public BTDiskManagerMemento getDiskManagerData() {
        return this.diskManagerData;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setContext(TorrentContext torrentContext) {
        if (torrentContext == null) {
            this.initRatio(torrentContext);
        }
        this.context = torrentContext;
    }

    private void initRatio(TorrentContext torrentContext) {
        if (this.historicRatio == 0.0f) {
            return;
        }
        this.uploadedBefore = (long)((float)torrentContext.getDiskManager().getBlockSize() * this.historicRatio);
    }

    long getAmountUploaded() {
        return this.uploadedNow;
    }

    void countUploaded(int n) {
        this.uploadedNow += (long)n;
    }

    float getRatio() {
        long l = this.context.getDiskManager().getBlockSize();
        if (l == 0L) {
            return 0.0f;
        }
        return (float)(this.uploadedBefore + this.uploadedNow) * 1.0f / (float)l;
    }

    public boolean verify(byte[] byArray, int n) {
        byte[] byArray2 = this._hashes.get(n);
        if (byArray2 == VERIFIED_HASH) {
            return true;
        }
        boolean bl = Arrays.equals(byArray, byArray2);
        if (bl) {
            this._hashes.set(n, VERIFIED_HASH);
        }
        return bl;
    }

    public byte[] getInfoHash() {
        return this._infoHash;
    }

    public URN getURN() {
        return this._infoHashURN;
    }

    public FileDesc getFileDesc() {
        if (this._desc == null) {
            HashSet<URN> hashSet = new HashSet<URN>();
            hashSet.add(this.getURN());
            this._desc = new FakeFileDesc(this.fileSystem.getCompleteFile(), hashSet);
        }
        return this._desc;
    }

    public void resetFileDesc() {
        this._desc = null;
    }

    public int getNumBlocks() {
        return (int)((this.fileSystem.getTotalSize() + (long)this._pieceLength - 1L) / (long)this._pieceLength);
    }

    public String getName() {
        return this.fileSystem.getName();
    }

    public URI[] getTrackers() {
        return this._trackers;
    }

    public MessageDigest getMessageDigest() {
        return new SHA1();
    }

    public BTMetaInfo() {
        this._hashes = null;
        this.fileSystem = null;
        this._infoHash = null;
        this._infoHashURN = null;
        this._trackers = null;
        this._desc = null;
        this.diskManagerData = null;
        this.context = null;
        this.isPrivate = false;
        this.historicRatio = 0.0f;
        this._pieceLength = 0;
    }

    public static BTMetaInfo readFromBytes(byte[] byArray) throws IOException {
        try {
            Object object = Token.parse(byArray);
            if (!(object instanceof Map)) {
                throw new ValueException("metaInfo not a Map!");
            }
            BTMetaInfo bTMetaInfo = new BTMetaInfo(new BTDataImpl((Map)object));
            bTMetaInfo._rawBytes = Arrays.copyOf(byArray, byArray.length);
            return bTMetaInfo;
        }
        catch (IOException iOException) {
            LOG.error("read failed", iOException);
            throw iOException;
        }
    }

    public BTMetaInfo(BTMetaInfoMemento bTMetaInfoMemento) throws InvalidDataException {
        Object object;
        this._rawBytes = null;
        this._hashes = bTMetaInfoMemento.getHashes();
        Object object2 = this._hashes.listIterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((byte[])object).length != 0) continue;
            object2.set(VERIFIED_HASH);
        }
        object2 = bTMetaInfoMemento.getPieceLength();
        this.fileSystem = new TorrentFileSystem(bTMetaInfoMemento.getFileSystem());
        this._infoHash = bTMetaInfoMemento.getInfoHash();
        try {
            this._infoHashURN = URN.createSHA1UrnFromBytes(this._infoHash);
        }
        catch (IOException iOException) {
            throw new InvalidDataException(iOException);
        }
        this._trackers = bTMetaInfoMemento.getTrackers();
        object = Float.valueOf(bTMetaInfoMemento.getRatio());
        this.diskManagerData = bTMetaInfoMemento.getFolderData();
        if (this._hashes == null || object2 == null || this.fileSystem == null || this._infoHash == null || this._trackers == null || this.diskManagerData == null || object == null) {
            throw new InvalidDataException("cannot read BTMetaInfo");
        }
        if (this._trackers.length == 0) {
            throw new InvalidDataException("no trackers");
        }
        for (URI uRI : this._trackers) {
            try {
                BTMetaInfo.validateURI(uRI);
            }
            catch (ValueException valueException) {
                throw new InvalidDataException(valueException);
            }
        }
        this.historicRatio = object.floatValue();
        this._pieceLength = (Integer)object2;
        this.isPrivate = bTMetaInfoMemento.isPrivate();
    }

    public BTMetaInfo(BTData bTData) throws IOException {
        this._rawBytes = null;
        try {
            URI uRI = URIUtils.toURI(bTData.getAnnounce());
            BTMetaInfo.validateURI(uRI);
            this._trackers = new URI[]{uRI};
        }
        catch (URISyntaxException uRISyntaxException) {
            URIUtils.error(uRISyntaxException);
            throw new ValueException("bad tracker: " + bTData.getAnnounce());
        }
        this.isPrivate = bTData.isPrivate();
        this._infoHash = bTData.getInfoHash();
        try {
            this._infoHashURN = URN.createSHA1UrnFromBytes(this._infoHash);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this._hashes = BTMetaInfo.parsePieces(bTData.getPieces());
        bTData.clearPieces();
        this._pieceLength = (int)bTData.getPieceLength().longValue();
        if (this._pieceLength <= 0) {
            throw new ValueException("bad metainfo - illegal piece length: " + bTData.getPieceLength());
        }
        this.diskManagerData = null;
        this.historicRatio = 0.0f;
        this.fileSystem = new TorrentFileSystem(bTData, this._hashes.size(), this._pieceLength, this._infoHash);
    }

    private static void validateURI(URI uRI) throws ValueException {
        if (uRI == null) {
            throw new ValueException("null URI");
        }
        boolean bl = false;
        boolean bl2 = bl = uRI.getHost() != null;
        if (!bl) {
            throw new ValueException("invalid host");
        }
    }

    public synchronized BTMetaInfoMemento toMemento() {
        BTMetaInfoMementoImpl bTMetaInfoMementoImpl = new BTMetaInfoMementoImpl();
        bTMetaInfoMementoImpl.setFileSystem(this.fileSystem.toMemento());
        bTMetaInfoMementoImpl.setFolderData(this.context.getDiskManager().toMemento());
        bTMetaInfoMementoImpl.setHashes(this._hashes);
        bTMetaInfoMementoImpl.setInfoHash(this._infoHash);
        bTMetaInfoMementoImpl.setPieceLength(this._pieceLength);
        bTMetaInfoMementoImpl.setPrivate(this.isPrivate);
        bTMetaInfoMementoImpl.setRatio(this.getRatio());
        bTMetaInfoMementoImpl.setTrackers(this._trackers);
        return bTMetaInfoMementoImpl;
    }

    private static List<byte[]> parsePieces(byte[] byArray) throws ValueException {
        if (byArray.length % 20 != 0) {
            throw new ValueException("bad metainfo - bad pieces key");
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(byArray.length / 20);
        for (int i = 0; i < byArray.length; i += 20) {
            byte[] byArray2 = new byte[20];
            System.arraycopy(byArray, i, byArray2, 0, 20);
            arrayList.add(byArray2);
        }
        return arrayList;
    }

    public boolean hasRawBytes() {
        return this._rawBytes != null;
    }

    public byte[] getRawBytes() {
        return this._rawBytes;
    }

    public File createFileFromRawBytes(String string) {
        if (!this.hasRawBytes()) {
            return null;
        }
        File file = new File(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.getRawBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeFileDesc
    extends FileDesc {
        public FakeFileDesc(File file, Set<? extends URN> set) {
            super(file, set, Integer.MAX_VALUE);
        }
    }
}

