/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.messages;

import com.limegroup.bittorrent.BTInterval;
import com.limegroup.bittorrent.messages.BTMessage;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BTRequest
extends BTMessage {
    private static final int MAX_REQUEST_SIZE = 65536;
    private BTInterval in;
    private ByteBuffer _payload;

    public BTRequest(BTInterval bTInterval) {
        super((byte)6);
        this.in = bTInterval;
    }

    public static BTRequest readMessage(ByteBuffer byteBuffer) throws BadBTMessageException {
        if (byteBuffer.remaining() != 12) {
            throw new BadBTMessageException("unexpected payload in request message: " + new String(byteBuffer.array()));
        }
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new BadBTMessageException("invalid piece number in request message: " + n);
        }
        long l = byteBuffer.getInt();
        if (l < 0L) {
            throw new BadBTMessageException("negative offset in mesage");
        }
        long l2 = byteBuffer.getInt();
        if (l2 <= 0L || l2 > 65536L) {
            throw new BadBTMessageException("invalid requested length in request message: " + l2);
        }
        return new BTRequest(new BTInterval(l, l + l2 - 1L, n));
    }

    public BTInterval getInterval() {
        return this.in;
    }

    public ByteBuffer getPayload() {
        if (this._payload == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(12);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putInt(this.in.getId());
            byteBuffer.putInt(this.in.get32BitLow());
            byteBuffer.putInt(this.in.get32BitLength());
            this._payload = byteBuffer.asReadOnlyBuffer();
        }
        this._payload.clear();
        return this._payload;
    }

    public boolean isUrgent() {
        return true;
    }

    public String toString() {
        return "BTRequest (" + this.in + ")";
    }
}

