/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.BTMessageHandler;
import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.CBCDataSource;
import com.limegroup.bittorrent.reader.LengthState;
import com.limegroup.bittorrent.reader.PieceParseListener;
import com.limegroup.bittorrent.reader.ReaderData;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.CircularByteBuffer;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.observer.IOErrorObserver;

public class BTMessageReader
implements ChannelReadObserver,
PieceParseListener {
    private static final int BUFFER_SIZE = 2048;
    private InterestReadableByteChannel _channel;
    private final IOErrorObserver ioxObserver;
    private final CircularByteBuffer _in;
    private volatile boolean shutdown;
    private boolean choked;
    private BTReadMessageState currentState;
    private final ScheduledExecutorService networkInvoker;
    private Runnable drainer;
    private final ReaderData readerState;

    public BTMessageReader(IOErrorObserver iOErrorObserver, BTMessageHandler bTMessageHandler, ScheduledExecutorService scheduledExecutorService, ByteBufferCache byteBufferCache) {
        this._in = new CircularByteBuffer(2048, byteBufferCache);
        this.networkInvoker = scheduledExecutorService;
        this.ioxObserver = iOErrorObserver;
        this.readerState = new ReaderData(bTMessageHandler, new CBCDataSource(this._in), this);
        this.currentState = new LengthState(this.readerState);
        this.readerState.setEntryState(this.currentState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRead() throws IOException {
        ReaderData readerData = this.readerState;
        synchronized (readerData) {
            if (this.shutdown) {
                return;
            }
            while (true) {
                int n = 0;
                if (!this.bufferFull()) {
                    n = this._in.read(this._channel);
                }
                if (n <= 0) break;
                this.processState();
                if (!this.bufferFull()) continue;
                this.choke(true);
            }
        }
    }

    private void choke(boolean bl) {
        if (this.choked != bl) {
            this._channel.interestRead(!bl);
            this.choked = bl;
        }
    }

    private boolean bufferFull() {
        return this._in.size() == this._in.capacity();
    }

    private void processState() throws BadBTMessageException {
        BTReadMessageState bTReadMessageState;
        while ((bTReadMessageState = this.currentState.addData()) != null) {
            this.currentState = bTReadMessageState;
        }
    }

    public void handleIOException(IOException iOException) {
        this.ioxObserver.handleIOException(iOException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BTMessageReader bTMessageReader = this;
        synchronized (bTMessageReader) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        this.ioxObserver.shutdown();
    }

    public void setReadChannel(InterestReadableByteChannel interestReadableByteChannel) {
        this._channel = interestReadableByteChannel;
    }

    public InterestReadableByteChannel getReadChannel() {
        return this._channel;
    }

    public void dataConsumed(boolean bl) {
        this.choke(false);
        if (bl) {
            this.currentState = this.readerState.getEntryState();
            if (this._in.size() > 0 && !this.shutdown) {
                this.networkInvoker.execute(this.getDrainer());
            }
        }
    }

    private Runnable getDrainer() {
        if (this.drainer == null) {
            this.drainer = new Drainer();
        }
        return this.drainer;
    }

    private class Drainer
    implements Runnable {
        private Drainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReaderData readerData = BTMessageReader.this.readerState;
            synchronized (readerData) {
                if (BTMessageReader.this._in.size() == 0 || BTMessageReader.this.shutdown) {
                    return;
                }
                try {
                    BTMessageReader.this.processState();
                }
                catch (BadBTMessageException badBTMessageException) {
                    BTMessageReader.this.shutdown();
                }
            }
        }
    }
}

