/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.bittorrent.reader;

import com.limegroup.bittorrent.messages.BadBTMessageException;
import com.limegroup.bittorrent.reader.BTDataSource;
import com.limegroup.bittorrent.reader.BTReadMessageState;
import com.limegroup.bittorrent.reader.ReaderData;
import com.limegroup.bittorrent.reader.TypeState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class LengthState
extends BTReadMessageState {
    private static final Log LOG = LogFactory.getLog(LengthState.class);
    private static final int MAX_PIECE_SIZE = 32777;
    private final TypeState TYPE_STATE;

    LengthState(ReaderData readerData) {
        super(readerData);
        this.TYPE_STATE = new TypeState(readerData);
    }

    public BTReadMessageState addData() throws BadBTMessageException {
        BTDataSource bTDataSource = this.readerState.getDataSource();
        if (bTDataSource.size() < 4) {
            return null;
        }
        long l = bTDataSource.getInt();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " parsed length " + l);
        }
        if (l < 0L || l > 32777L) {
            throw new BadBTMessageException("bad message size " + l);
        }
        if (l == 0L) {
            this.readerState.dataRead();
            return this;
        }
        this.readerState.setLength((int)(--l));
        return this.TYPE_STATE;
    }

    public String toString() {
        return "length state of " + this.readerState;
    }
}

