/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.LimeWireCore;
import com.limegroup.gnutella.LimeWireCoreModule;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.version.UpdateInformation;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Set;
import java.util.Vector;
import org.limewire.io.IpPort;
import org.limewire.net.SocketsManager;

public class Main {
    public static void main(String[] stringArray) {
        Injector injector = Guice.createInjector(new LimeWireCoreModule(MainCallback.class));
        LimeWireCore limeWireCore = injector.getInstance(LimeWireCore.class);
        limeWireCore.getLifecycleManager().start();
        NetworkManager networkManager = limeWireCore.getNetworkManager();
        System.out.println("For a command list type help.");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("LimeRouter> ");
            try {
                String string = bufferedReader.readLine();
                if (string == null) break;
                if (string.equals("help")) {
                    System.out.println("catcher                  Print host catcher.");
                    System.out.println("connect <host> [<port>]  Connect to a host[:port].");
                    System.out.println("help                     Print this message.");
                    System.out.println("listen <port>            Set the port you are listening on.");
                    System.out.println("query <string>           Send a query to the network.");
                    System.out.println("quit                     Quit the application.");
                    System.out.println("update                   Send pings to update the statistics.");
                } else if (string.equals("quit")) break;
                String[] stringArray2 = Main.split(string);
                if (stringArray2.length >= 2 && stringArray2[0].equals("connect")) {
                    try {
                        int n = 6346;
                        if (stringArray2.length >= 3) {
                            n = Integer.parseInt(stringArray2[2]);
                        }
                        System.out.println("Connecting...");
                        limeWireCore.getConnectionServices().connectToHostAsynchronously(stringArray2[1], n, SocketsManager.ConnectType.PLAIN);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Please specify a valid port.");
                    }
                    continue;
                }
                if (stringArray2.length >= 2 && stringArray2[0].equals("query")) {
                    int n = string.indexOf(32);
                    assert (n != -1 && n < string.length());
                    String string2 = string.substring(n + 1);
                    SearchServices searchServices = limeWireCore.getSearchServices();
                    searchServices.query(searchServices.newQueryGUID(), string2);
                    continue;
                }
                if (stringArray2.length != 2 || !stringArray2[0].equals("listen")) continue;
                try {
                    int n = Integer.parseInt(stringArray2[1]);
                    networkManager.setListeningPort(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Please specify a valid port.");
                }
                catch (IOException iOException) {
                    System.out.println("Couldn't change port.  Try another value.");
                }
            }
            catch (IOException iOException) {
                System.exit(1);
            }
        }
        System.out.println("Good bye.");
        limeWireCore.getLifecycleManager().shutdown();
    }

    public static String[] split(String string) {
        int n;
        int n2 = (string = string.trim()).length();
        if (n2 == 0) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < n2) {
            assert (string.charAt(n3) != ' ');
            n = string.indexOf(32, n3 + 1);
            if (n == -1) {
                n = n2;
            }
            vector.add(string.substring(n3, n));
            n3 = n + 1;
            while (n < n2 && string.charAt(n3) == ' ') {
                ++n3;
            }
        }
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.get(n);
        }
        return stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    private static class MainCallback
    implements ActivityCallback {
        private MainCallback() {
        }

        public void connectionInitializing(RoutedConnection routedConnection) {
        }

        public void connectionInitialized(RoutedConnection routedConnection) {
        }

        public void connectionClosed(RoutedConnection routedConnection) {
        }

        public void knownHost(Endpoint endpoint) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleQueryResult(RemoteFileDesc remoteFileDesc, HostData hostData, Set<? extends IpPort> set) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println("Query hit from " + remoteFileDesc.getHost() + ":" + remoteFileDesc.getPort() + ":");
                System.out.println("   " + remoteFileDesc.getFileName());
            }
        }

        @Override
        public void handleQueryString(String string) {
        }

        public void error(int n) {
            this.error(n, null);
        }

        public void error(Throwable throwable, String string) {
            throwable.printStackTrace();
            System.out.println(string);
        }

        public void error(Throwable throwable) {
            throwable.printStackTrace();
        }

        public void error(int n, Throwable throwable) {
            System.out.println("Error: " + n);
            throwable.printStackTrace();
        }

        @Override
        public void addDownload(Downloader downloader) {
        }

        @Override
        public void removeDownload(Downloader downloader) {
        }

        @Override
        public void addUpload(Uploader uploader) {
        }

        @Override
        public void removeUpload(Uploader uploader) {
        }

        @Override
        public boolean warnAboutSharingSensitiveDirectory(File file) {
            return false;
        }

        @Override
        public void handleFileEvent(FileManagerEvent fileManagerEvent) {
        }

        @Override
        public void handleSharedFileUpdate(File file) {
        }

        @Override
        public void fileManagerLoading() {
        }

        @Override
        public void acceptChat(InstantMessenger instantMessenger) {
        }

        @Override
        public void receiveMessage(InstantMessenger instantMessenger, String string) {
        }

        @Override
        public void chatUnavailable(InstantMessenger instantMessenger) {
        }

        @Override
        public void chatErrorMessage(InstantMessenger instantMessenger, String string) {
        }

        @Override
        public void downloadsComplete() {
        }

        @Override
        public void fileManagerLoaded() {
        }

        @Override
        public void uploadsComplete() {
        }

        @Override
        public void promptAboutCorruptDownload(Downloader downloader) {
            downloader.discardCorruptDownload(false);
        }

        @Override
        public void restoreApplication() {
        }

        @Override
        public void showDownloads() {
        }

        @Override
        public String getHostValue(String string) {
            return null;
        }

        @Override
        public void browseHostFailed(GUID gUID) {
        }

        @Override
        public void setAnnotateEnabled(boolean bl) {
        }

        @Override
        public void updateAvailable(UpdateInformation updateInformation) {
            if (updateInformation.getUpdateCommand() != null) {
                System.out.println("there's a new version out " + updateInformation.getUpdateVersion() + ", to get it shutdown limewire and run " + updateInformation.getUpdateCommand());
            } else {
                System.out.println("You're running an older version.  Get " + updateInformation.getUpdateVersion() + ", from " + updateInformation.getUpdateURL());
            }
        }

        @Override
        public boolean isQueryAlive(GUID gUID) {
            return false;
        }

        @Override
        public void componentLoading(String string) {
            System.out.println("Loading component: " + string);
        }

        @Override
        public boolean handleMagnets(MagnetOptions[] magnetOptionsArray) {
            return false;
        }

        @Override
        public void handleTorrent(File file) {
        }

        @Override
        public void acceptedIncomingChanged(boolean bl) {
        }

        @Override
        public void handleAddressStateChanged() {
        }

        @Override
        public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        }

        @Override
        public void installationCorrupted() {
        }

        @Override
        public void handleTorrentMagnet(String string) {
        }
    }
}

