/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.SelfEndpoint;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.messages.BadPacketException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IPPortCombo;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PushEndpointFactoryImpl
implements PushEndpointFactory {
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final Provider<SelfEndpoint> selfProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public PushEndpointFactoryImpl(Provider<PushEndpointCache> provider, Provider<SelfEndpoint> provider2, NetworkInstanceUtils networkInstanceUtils) {
        this.pushEndpointCache = provider;
        this.selfProvider = provider2;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] byArray) {
        return this.createPushEndpoint(byArray, IpPort.EMPTY_SET);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] byArray, Set<? extends IpPort> set) {
        return this.createPushEndpoint(byArray, set, (byte)0, 0);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] byArray, Set<? extends IpPort> set, byte by, int n) {
        return this.createPushEndpoint(byArray, set, by, n, null);
    }

    @Override
    public PushEndpoint createPushEndpoint(byte[] byArray, Set<? extends IpPort> set, byte by, int n, IpPort ipPort) {
        return new PushEndpoint(byArray, set, by, n, ipPort, this.pushEndpointCache.get(), this.networkInstanceUtils);
    }

    @Override
    public PushEndpoint createPushEndpoint(String string) throws IOException {
        byte[] byArray;
        if (string.length() < 32 || string.indexOf(";") > 32) {
            throw new IOException("http string does not contain valid guid");
        }
        String string2 = string.substring(0, 32);
        string = string.substring(32);
        try {
            byArray = GUID.fromHexString(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        IpPortSet ipPortSet = new IpPortSet();
        int n = 0;
        IpPort ipPort = null;
        BitNumbers bitNumbers = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith("fwt")) {
                n = (int)HTTPUtils.parseFeatureToken(string3);
                continue;
            }
            if (ipPortSet.size() == 0 && string3.startsWith("pptls")) {
                String string4 = HTTPUtils.parseValue(string3);
                if (string4 == null) continue;
                try {
                    bitNumbers = new BitNumbers(string4);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw (IOException)new IOException().initCause(illegalArgumentException);
                }
            }
            if (ipPortSet.size() < 4) {
                boolean bl = bitNumbers != null && bitNumbers.isSet(ipPortSet.size());
                try {
                    Connectable connectable = NetworkUtils.parseIpPort(string3, bl);
                    if (this.networkInstanceUtils.isPrivateAddress(connectable.getInetAddress())) continue;
                    ipPortSet.add(connectable);
                    continue;
                }
                catch (IOException iOException) {
                    bitNumbers = null;
                }
            }
            if (ipPort != null) continue;
            try {
                IpPort ipPort2 = NetworkUtils.parsePortIp(string3);
                if (this.networkInstanceUtils.isPrivateAddress(ipPort2.getInetAddress())) continue;
                ipPort = ipPort2;
            }
            catch (IOException iOException) {}
        }
        if (ipPort == null || !this.networkInstanceUtils.isValidExternalIpPort(ipPort)) {
            n = 0;
            ipPort = null;
        }
        return this.createPushEndpoint(byArray, ipPortSet, (byte)(ipPortSet.size() | n << 3), n, ipPort);
    }

    @Override
    public PushEndpoint createFromBytes(DataInputStream dataInputStream) throws BadPacketException, IOException {
        byte[] byArray;
        Object object;
        byte[] byArray2 = new byte[16];
        IpPortSet ipPortSet = new IpPortSet();
        IPPortCombo iPPortCombo = null;
        byte by = (byte)(dataInputStream.read() & 0xFF);
        int n = by & 7;
        byte by2 = (byte)(by & 0xFFFFFFE0);
        byte by3 = (byte)((by & 0x18) >> 3);
        dataInputStream.readFully(byArray2);
        if (by3 > 0) {
            object = new byte[6];
            dataInputStream.readFully((byte[])object);
            try {
                iPPortCombo = IPPortCombo.getCombo((byte[])object);
            }
            catch (InvalidDataException invalidDataException) {
                throw new BadPacketException(invalidDataException);
            }
            if (iPPortCombo.getAddress().equals("1.1.1.1")) {
                iPPortCombo = null;
                by3 = 0;
            }
        }
        object = null;
        if ((by2 & 0xFFFFFF80) != 0) {
            byArray = new byte[1];
            dataInputStream.readFully(byArray);
            object = new BitNumbers(byArray);
        }
        byArray = new byte[6];
        for (int i = 0; i < n; ++i) {
            dataInputStream.readFully(byArray);
            try {
                IpPort ipPort = IPPortCombo.getCombo(byArray);
                if (object != null && ((BitNumbers)object).isSet(i)) {
                    ipPort = new ConnectableImpl(ipPort, true);
                }
                ipPortSet.add(ipPort);
                continue;
            }
            catch (InvalidDataException invalidDataException) {
                throw new BadPacketException(invalidDataException);
            }
        }
        PushEndpoint pushEndpoint = this.createPushEndpoint(byArray2, ipPortSet, by2, by3, iPPortCombo);
        pushEndpoint.updateProxies(true);
        return pushEndpoint;
    }

    @Override
    public PushEndpoint createForSelf() {
        return this.selfProvider.get();
    }
}

