/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.chat;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.chat.InstantMessenger;
import com.limegroup.gnutella.chat.InstantMessengerFactory;
import com.limegroup.gnutella.settings.ChatSettings;
import java.net.Socket;
import org.limewire.io.IOUtils;
import org.limewire.net.ConnectionAcceptor;

@Singleton
public final class ChatManager
implements ConnectionAcceptor {
    private final SpamServices spamServices;
    private final InstantMessengerFactory instantMessengerFactory;

    @Inject
    public ChatManager(SpamServices spamServices, InstantMessengerFactory instantMessengerFactory) {
        this.spamServices = spamServices;
        this.instantMessengerFactory = instantMessengerFactory;
    }

    public boolean isBlocking() {
        return false;
    }

    public void acceptConnection(String string, Socket socket) {
        boolean bl = ChatSettings.CHAT_ENABLED.getValue();
        if (!bl) {
            IOUtils.close(socket);
            return;
        }
        if (!this.spamServices.isAllowed(socket.getInetAddress())) {
            IOUtils.close(socket);
            return;
        }
        InstantMessenger instantMessenger = this.instantMessengerFactory.createIncomingInstantMessenger(socket);
        instantMessenger.start();
    }

    public InstantMessenger createConnection(String string, int n) {
        InstantMessenger instantMessenger = this.instantMessengerFactory.createOutgoingInstantMessenger(string, n);
        return instantMessenger;
    }
}

