/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTNodeFetcher;
import com.limegroup.gnutella.dht.DHTNodeFetcherFactory;
import com.limegroup.gnutella.settings.DHTSettings;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.FixedSizeLIFOSet;
import org.limewire.concurrent.FutureEvent;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.util.ExceptionUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DHTBootstrapperImpl
implements DHTBootstrapper {
    private static final Log LOG = LogFactory.getLog(DHTBootstrapperImpl.class);
    private final Set<SocketAddress> hosts = new FixedSizeLIFOSet<SocketAddress>(50, FixedSizeLIFOSet.EjectionPolicy.FIFO);
    private boolean triedRouteTable = false;
    private DHTFuture<PingResult> pingFuture;
    private boolean fromRouteTable = false;
    private DHTFuture<BootstrapResult> bootstrapFuture;
    private final DHTController controller;
    private DHTNodeFetcher nodeFetcher;
    private final Object lock = new Object();
    private final DHTNodeFetcherFactory dhtNodeFetcherFactory;

    public DHTBootstrapperImpl(DHTController dHTController, DHTNodeFetcherFactory dHTNodeFetcherFactory) {
        this.controller = dHTController;
        this.dhtNodeFetcherFactory = dHTNodeFetcherFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootstrap() {
        Object object = this.lock;
        synchronized (object) {
            if (this.getMojitoDHT().isBootstrapped()) {
                return;
            }
            if (this.hosts.isEmpty()) {
                this.tryBootstrapFromRouteTable();
            } else {
                this.tryBootstrapFromHostsSet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBootstrapHost(SocketAddress socketAddress) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.getMojitoDHT().isRunning() || this.getMojitoDHT().isBootstrapped()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding host: " + socketAddress);
            }
            this.hosts.add(socketAddress);
            this.tryBootstrapFromHostsSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPassiveNode(SocketAddress socketAddress) {
        Object object = this.lock;
        synchronized (object) {
            if (this.nodeFetcher == null || !this.isWaitingForNodes()) {
                return;
            }
            this.nodeFetcher.requestDHTHosts(socketAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pingFuture != null) {
                this.pingFuture.cancel(true);
                this.pingFuture = null;
            }
            if (this.bootstrapFuture != null) {
                this.bootstrapFuture.cancel(true);
                this.bootstrapFuture = null;
            }
            this.stopNodeFetcher();
            this.triedRouteTable = false;
            this.fromRouteTable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWaitingForNodes() {
        Object object = this.lock;
        synchronized (object) {
            return !this.getMojitoDHT().isBootstrapped() && this.bootstrapFuture == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBootstrapFromRouteTable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.triedRouteTable) {
                return;
            }
            if (this.pingFuture != null || this.bootstrapFuture != null) {
                return;
            }
            this.pingFuture = this.getMojitoDHT().findActiveContact();
            this.pingFuture.addFutureListener(new PongListener(this.pingFuture));
            this.triedRouteTable = true;
            this.fromRouteTable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryBootstrapFromHostsSet() {
        Object object = this.lock;
        synchronized (object) {
            if (this.bootstrapFuture != null) {
                return;
            }
            if (this.fromRouteTable) {
                this.fromRouteTable = false;
                if (this.pingFuture != null) {
                    this.pingFuture.cancel(true);
                    this.pingFuture = null;
                }
            }
            if (this.pingFuture != null) {
                return;
            }
            Iterator<SocketAddress> iterator = this.hosts.iterator();
            assert (iterator.hasNext());
            SocketAddress socketAddress = iterator.next();
            iterator.remove();
            this.pingFuture = this.getMojitoDHT().ping(socketAddress);
            this.pingFuture.addFutureListener(new PongListener(this.pingFuture));
        }
    }

    private void finish() {
        this.controller.sendUpdatedCapabilities();
    }

    private MojitoDHT getMojitoDHT() {
        return this.controller.getMojitoDHT();
    }

    private void stopNodeFetcher() {
        if (this.nodeFetcher != null) {
            this.nodeFetcher.stop();
            this.nodeFetcher = null;
        }
    }

    public void simppUpdated(int n) {
        SocketAddress socketAddress = null;
        socketAddress = this.getSimppHost();
        if (socketAddress != null) {
            this.addBootstrapHost(socketAddress);
        }
    }

    SocketAddress getSimppHost() {
        String[] stringArray = DHTSettings.DHT_BOOTSTRAP_HOSTS.getValue();
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(stringArray.length);
        for (String string : stringArray) {
            int n = string.indexOf(":");
            if (n < 0 || n == string.length() - 1) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error(new UnknownHostException("invalid SIMPP host: " + string));
                continue;
            }
            try {
                String string2 = string.substring(0, n);
                int n2 = Integer.parseInt(string.substring(n + 1).trim());
                arrayList.add(new InetSocketAddress(string2, n2));
            }
            catch (NumberFormatException numberFormatException) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error(new UnknownHostException("invalid host: " + string));
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        KUID kUID = this.getMojitoDHT().getLocalNodeID();
        int n = (kUID.getBytes()[0] & 0xF0) >> 4;
        int n3 = (int)((float)arrayList.size() / 16.0f * (float)n);
        return (SocketAddress)arrayList.get(n3);
    }

    boolean isBootstrappingFromRouteTable() {
        return this.fromRouteTable;
    }

    DHTFuture<PingResult> getPingFuture() {
        return this.pingFuture;
    }

    DHTFuture<BootstrapResult> getBootstrapFuture() {
        return this.bootstrapFuture;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BootstrapListener
    extends DHTFutureAdapter<BootstrapResult> {
        private BootstrapListener() {
        }

        @Override
        protected void operationComplete(FutureEvent<BootstrapResult> futureEvent) {
            switch (futureEvent.getType()) {
                case SUCCESS: {
                    this.handleFutureSuccess(futureEvent.getResult());
                    break;
                }
                case CANCELLED: {
                    this.handleCancellationException();
                    break;
                }
                case EXCEPTION: {
                    this.handleExecutionException(futureEvent.getException());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFutureSuccess(BootstrapResult bootstrapResult) {
            boolean bl = false;
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                DHTBootstrapperImpl.this.bootstrapFuture = null;
                BootstrapResult.ResultType resultType = bootstrapResult.getResultType();
                LOG.debug("Future success type: " + (Object)((Object)resultType));
                switch (resultType) {
                    case BOOTSTRAP_SUCCEEDED: {
                        bl = true;
                        break;
                    }
                    case BOOTSTRAP_FAILED: {
                        DHTBootstrapperImpl.this.bootstrap();
                        break;
                    }
                }
            }
            if (bl) {
                DHTBootstrapperImpl.this.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleExecutionException(ExecutionException executionException) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.error("ExecutionException", executionException);
                if (!(executionException.getCause() instanceof DHTException)) {
                    ErrorService.error(executionException);
                }
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCancellationException(CancellationException cancellationException) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Canceled", cancellationException);
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleInterruptedException(InterruptedException interruptedException) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Interrupted", interruptedException);
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCancellationException() {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Canceled");
                DHTBootstrapperImpl.this.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PongListener
    extends DHTFutureAdapter<PingResult> {
        private final DHTFuture<PingResult> myFuture;

        public PongListener(DHTFuture<PingResult> dHTFuture) {
            this.myFuture = dHTFuture;
        }

        @Override
        protected void operationComplete(FutureEvent<PingResult> futureEvent) {
            switch (futureEvent.getType()) {
                case SUCCESS: {
                    this.handleFutureSuccess(futureEvent.getResult());
                    break;
                }
                case CANCELLED: {
                    this.handleCancellationException();
                    break;
                }
                case EXCEPTION: {
                    this.handleExecutionException(futureEvent.getException());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleFutureSuccess(PingResult pingResult) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.pingFuture = null;
                DHTBootstrapperImpl.this.stopNodeFetcher();
                DHTBootstrapperImpl.this.bootstrapFuture = DHTBootstrapperImpl.this.getMojitoDHT().bootstrap(pingResult.getContact());
                DHTBootstrapperImpl.this.bootstrapFuture.addFutureListener(new BootstrapListener());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleExecutionException(ExecutionException executionException) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.pingFuture = null;
                if (ExceptionUtils.isCausedBy(executionException, DHTException.class)) {
                    SocketAddress socketAddress = null;
                    if (DHTBootstrapperImpl.this.fromRouteTable && (socketAddress = DHTBootstrapperImpl.this.getSimppHost()) != null) {
                        DHTBootstrapperImpl.this.addBootstrapHost(socketAddress);
                    } else {
                        this.retry();
                    }
                } else if (!ExceptionUtils.isCausedBy(executionException, IllegalArgumentException.class)) {
                    LOG.error("ExecutionException", executionException);
                    ErrorService.error(executionException);
                    DHTBootstrapperImpl.this.stop();
                }
            }
        }

        private void retry() {
            if (DHTBootstrapperImpl.this.nodeFetcher == null) {
                DHTBootstrapperImpl.this.nodeFetcher = DHTBootstrapperImpl.this.dhtNodeFetcherFactory.createNodeFetcher(DHTBootstrapperImpl.this);
                DHTBootstrapperImpl.this.nodeFetcher.start();
            } else {
                DHTBootstrapperImpl.this.bootstrap();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCancellationException(CancellationException cancellationException) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Ping Cancelled", cancellationException);
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleInterruptedException(InterruptedException interruptedException) {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Ping Interrupted", interruptedException);
                if (DHTBootstrapperImpl.this.pingFuture != this.myFuture) {
                    return;
                }
                DHTBootstrapperImpl.this.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCancellationException() {
            Object object = DHTBootstrapperImpl.this.lock;
            synchronized (object) {
                LOG.debug("Bootstrap Canceled");
                DHTBootstrapperImpl.this.stop();
            }
        }
    }
}

