/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.limewire.collection.Comparators;
import org.limewire.collection.Range;
import org.limewire.io.InvalidDataException;
import org.limewire.util.Base32;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class IncompleteFileManager {
    static final String SEPARATOR = "-";
    public static final String PREVIEW_PREFIX = "Preview-";
    private final Map<File, VerifyingFile> blocks = new TreeMap<File, VerifyingFile>(Comparators.fileComparator());
    private final Map<URN, File> hashes = new HashMap<URN, File>();
    private final Provider<FileManager> fileManager;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final VerifyingFileFactory verifyingFileFactory;

    @Inject
    public IncompleteFileManager(Provider<FileManager> provider, Provider<HashTreeCache> provider2, VerifyingFileFactory verifyingFileFactory) {
        this.fileManager = provider;
        this.tigerTreeCache = provider2;
        this.verifyingFileFactory = verifyingFileFactory;
    }

    public synchronized boolean purge() {
        boolean bl = false;
        Iterator<File> iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (file.exists()) continue;
            bl = true;
            this.fileManager.get().removeFileIfShared(file);
            file.delete();
            iterator.remove();
        }
        return bl;
    }

    public synchronized boolean initialPurge(Collection<File> collection) {
        File file;
        boolean bl = false;
        Iterator<File> iterator = this.blocks.keySet().iterator();
        while (iterator.hasNext()) {
            file = iterator.next();
            try {
                file = FileUtils.getCanonicalFile(file);
            }
            catch (IOException iOException) {
                file = file.getAbsoluteFile();
            }
            if (file.exists() && (!IncompleteFileManager.isOld(file) || collection.contains(file))) continue;
            bl = true;
            this.fileManager.get().removeFileIfShared(file);
            file.delete();
            iterator.remove();
        }
        iterator = this.hashes.values().iterator();
        while (iterator.hasNext()) {
            file = iterator.next();
            if (file.exists()) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    private static final boolean isOld(File file) {
        long l = SharingSettings.INCOMPLETE_PURGE_TIME.getValue();
        long l2 = System.currentTimeMillis() - l * 24L * 60L * 60L * 1000L;
        return file.lastModified() < l2;
    }

    static boolean same(RemoteFileDesc remoteFileDesc, RemoteFileDesc remoteFileDesc2) {
        return IncompleteFileManager.same(remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getSHA1Urn(), remoteFileDesc2.getFileName(), remoteFileDesc2.getSize(), remoteFileDesc2.getSHA1Urn());
    }

    static boolean same(String string, long l, URN uRN, String string2, long l2, URN uRN2) {
        if (uRN != null && uRN2 != null) {
            return uRN.equals(uRN2);
        }
        return l == l2 && string.equals(string2);
    }

    private static File canonicalize(File file) throws IOException {
        file = file.getAbsoluteFile();
        if (OSUtils.isWindows()) {
            return file;
        }
        return file.getCanonicalFile();
    }

    public synchronized File getFile(RemoteFileDesc remoteFileDesc) throws IOException {
        return this.getFile(remoteFileDesc.getFileName(), remoteFileDesc.getSHA1Urn(), remoteFileDesc.getSize());
    }

    public synchronized File getFile(String string, URN uRN, long l) throws IOException {
        return this.getFile(string, uRN, l, SharingSettings.INCOMPLETE_DIRECTORY.getValue());
    }

    public synchronized File getFile(String string, URN uRN, long l, File file) throws IOException {
        boolean bl = false;
        File file2 = null;
        File file3 = null;
        bl = file.mkdirs();
        String string2 = CommonUtils.convertFileName(string);
        try {
            File file4;
            if (uRN != null) {
                File file5 = this.hashes.get(uRN);
                if (file5 != null) {
                    return file5;
                }
                int n = 1;
                while (true) {
                    file2 = file5 = new File(file, IncompleteFileManager.tempName(string2, l, n));
                    file3 = file5 = IncompleteFileManager.canonicalize(file5);
                    if (!this.hashes.values().contains(file5)) break;
                    ++n;
                }
                this.hashes.put(uRN, file5);
                FileUtils.touch(file5);
                return file5;
            }
            file2 = file4 = new File(file, IncompleteFileManager.tempName(string2, l, 0));
            file3 = file4 = IncompleteFileManager.canonicalize(file4);
            return file4;
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("dirsMade: " + bl + "\ndirExist: " + file.exists() + "\nbaseFile: " + file2 + "\ncannFile: " + file3);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public synchronized File getFileForUrn(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null urn");
        }
        return this.hashes.get(uRN);
    }

    private static String tempName(String string, long l, int n) {
        if (n <= 1) {
            return "T-" + l + SEPARATOR + string;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return "T-" + l + SEPARATOR + string + " (" + n + ")";
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2);
        return "T-" + l + SEPARATOR + string2 + " (" + n + ")" + string3;
    }

    public synchronized void removeEntry(File file) {
        this.blocks.remove(file);
        Iterator<Map.Entry<URN, File>> iterator = this.hashes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<URN, File> entry = iterator.next();
            if (!file.equals(entry.getValue())) continue;
            iterator.remove();
        }
        this.fileManager.get().removeFileIfShared(file);
    }

    public synchronized void initEntry(File file, List<Range> list, URN uRN, boolean bl) throws InvalidDataException {
        VerifyingFile verifyingFile;
        try {
            file = IncompleteFileManager.canonicalize(file);
        }
        catch (IOException iOException) {
            throw new InvalidDataException(iOException);
        }
        try {
            verifyingFile = this.verifyingFileFactory.createVerifyingFile(IncompleteFileManager.getCompletedSize(file));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidDataException(illegalArgumentException);
        }
        if (list != null) {
            for (Range range : list) {
                verifyingFile.addInterval(range);
            }
        }
        if (list == null || list.isEmpty()) {
            try {
                verifyingFile.setScanForExistingBlocks(true, file.length());
            }
            catch (IOException iOException) {
                throw new InvalidDataException(iOException);
            }
        }
        this.blocks.put(file, verifyingFile);
        if (uRN != null) {
            this.hashes.put(uRN, file);
        }
        if (bl) {
            this.registerIncompleteFile(file);
        }
    }

    public synchronized void addEntry(File file, VerifyingFile verifyingFile, boolean bl) {
        try {
            file = IncompleteFileManager.canonicalize(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.blocks.put(file, verifyingFile);
        if (bl) {
            this.registerIncompleteFile(file);
        }
    }

    public synchronized void addTorrentEntry(URN uRN) {
        String string = SharingSettings.INCOMPLETE_DIRECTORY.getValue().getAbsolutePath() + File.separator + Base32.encode(uRN.getBytes());
        File file = new File(string);
        this.hashes.put(uRN, file);
    }

    public synchronized void removeTorrentEntry(URN uRN) {
        this.hashes.remove(uRN);
    }

    public synchronized VerifyingFile getEntry(File file) {
        return this.blocks.get(file);
    }

    public synchronized long getBlockSize(File file) {
        VerifyingFile verifyingFile = this.blocks.get(file);
        if (verifyingFile == null) {
            return 0L;
        }
        return verifyingFile.getBlockSize();
    }

    public synchronized void registerAllIncompleteFiles() {
        for (File file : this.blocks.keySet()) {
            if (!file.exists() || IncompleteFileManager.isOld(file)) continue;
            this.registerIncompleteFile(file);
        }
    }

    private synchronized void registerIncompleteFile(File file) {
        Set<URN> set = this.getAllCompletedHashes(file);
        if (set.size() == 0) {
            return;
        }
        this.fileManager.get().addIncompleteFile(file, set, IncompleteFileManager.getCompletedName(file), IncompleteFileManager.getCompletedSize(file), this.getEntry(file));
    }

    public static String getCompletedName(File file) throws IllegalArgumentException {
        String string = IncompleteFileManager.getCompletedTorrentName(file);
        if (string != null) {
            return string;
        }
        String string2 = file.getName();
        int n = string2.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string2);
        }
        int n2 = string2.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string2);
        }
        if (n2 == string2.length() - 1) {
            throw new IllegalArgumentException("No name after last separator");
        }
        return string2.substring(n2 + 1);
    }

    private static String getCompletedTorrentName(File file) {
        if (!IncompleteFileManager.isTorrentFolder(file)) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray[0].getName().startsWith(".dat")) {
            return fileArray[1].getName();
        }
        return fileArray[0].getName();
    }

    public static boolean isTorrentFolder(File file) {
        if (!file.isDirectory() || file.getName().length() != 32) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray.length != 2) {
            return false;
        }
        File file2 = fileArray[0];
        File file3 = fileArray[1];
        if (!file2.getName().startsWith(".dat")) {
            file2 = fileArray[1];
            file3 = fileArray[0];
        }
        if (!file2.getName().startsWith(".dat")) {
            return false;
        }
        return file2.getName().equals(".dat" + file3.getName());
    }

    public static long getCompletedSize(File file) throws IllegalArgumentException {
        String string = file.getName();
        int n = string.indexOf(SEPARATOR);
        if (n < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        int n2 = string.indexOf(SEPARATOR, n + 1);
        if (n2 < 0) {
            throw new IllegalArgumentException("Missing separator: " + string);
        }
        try {
            return Long.parseLong(string.substring(n + 1, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad number format: " + string);
        }
    }

    public synchronized URN getCompletedHash(File file) {
        for (Map.Entry<URN, File> entry : this.hashes.entrySet()) {
            if (!file.equals(entry.getValue()) || !entry.getKey().isSHA1()) continue;
            return entry.getKey();
        }
        return null;
    }

    public synchronized Set<URN> getAllCompletedHashes(File file) {
        UrnSet urnSet = new UrnSet();
        for (Map.Entry<URN, File> entry : this.hashes.entrySet()) {
            if (!file.equals(entry.getValue())) continue;
            urnSet.add(entry.getKey());
            URN uRN = this.tigerTreeCache.get().getHashTreeRootForSha1(entry.getKey());
            if (uRN == null) continue;
            urnSet.add(uRN);
        }
        return urnSet;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl = true;
        for (File file : this.blocks.keySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            List<Range> list = this.blocks.get(file).getVerifiedBlocksAsList();
            stringBuilder.append(file);
            stringBuilder.append(":");
            stringBuilder.append(list.toString());
            bl = false;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public synchronized String dumpHashes() {
        return this.hashes.toString();
    }
}

