/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.io.IP;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

public class IPList {
    private static final IP NULL_IP = new IP("*.*.*.*");
    private Trie<IP, IP> ips = new PatriciaTrie<IP, IP>(new IPKeyAnalyzer());

    public synchronized boolean isEmpty() {
        return this.ips.isEmpty();
    }

    public synchronized int size() {
        return this.ips.size();
    }

    public void add(String string) {
        IP iP;
        try {
            iP = new IP(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.add(iP);
    }

    public synchronized void add(IP iP) {
        if (iP.equals(NULL_IP)) {
            this.ips.clear();
            this.ips.put(iP, iP);
            return;
        }
        if (!NetworkUtils.isValidAddress(iP)) {
            return;
        }
        AddFilter addFilter = new AddFilter(iP);
        Map.Entry<IP, IP> entry = this.ips.select(iP, addFilter);
        if (entry != null) {
            if (!entry.getKey().contains(iP)) {
                for (IP iP2 : addFilter.getContained()) {
                    this.ips.remove(iP2);
                }
                this.ips.put(iP, iP);
            }
        } else {
            this.ips.put(iP, iP);
        }
    }

    public synchronized boolean contains(IP iP) {
        IP iP2 = this.ips.select(iP);
        return iP2 != null && iP2.contains(iP);
    }

    public synchronized boolean isValidFilter(boolean bl, NetworkInstanceUtils networkInstanceUtils) {
        ValidFilter validFilter = new ValidFilter(bl, networkInstanceUtils);
        this.ips.traverse(validFilter);
        return validFilter.isValid();
    }

    public int logMinDistanceTo(IP iP) {
        int n = this.minDistanceTo(iP);
        int n2 = 0;
        int n3 = -1;
        while ((n & n3) != 0) {
            n3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public synchronized int minDistanceTo(IP iP) {
        if (iP.mask != -1) {
            throw new IllegalArgumentException("Expected single IP, not an IP range.");
        }
        IP iP2 = this.ips.select(iP);
        if (iP2 == null) {
            return Integer.MAX_VALUE;
        }
        return iP2.getDistanceTo(iP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IPKeyAnalyzer
    implements PatriciaTrie.KeyAnalyzer<IP> {
        private static final int[] BITS = IPKeyAnalyzer.createIntBitMask(32);

        private IPKeyAnalyzer() {
        }

        private static final int[] createIntBitMask(int n) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 1 << n - i - 1;
            }
            return nArray;
        }

        @Override
        public int length(IP iP) {
            return 32;
        }

        @Override
        public boolean isBitSet(IP iP, int n, int n2) {
            int n3 = iP.addr & iP.mask;
            return (n3 & BITS[n2]) != 0;
        }

        @Override
        public int bitIndex(IP iP, int n, int n2, IP iP2, int n3, int n4) {
            int n5;
            int n6 = iP.addr & iP.mask;
            int n7 = n5 = iP2 != null ? iP2.addr & iP2.mask : 0;
            if (n != 0 || n3 != 0) {
                throw new IllegalArgumentException("offsets must be 0 for fixed-size keys");
            }
            int n8 = Math.max(n2, n4);
            boolean bl = true;
            for (int i = 0; i < n8; ++i) {
                int n9 = n6 & BITS[i];
                int n10 = n5 & BITS[i];
                if (bl && n9 != 0) {
                    bl = false;
                }
                if (n9 == n10) continue;
                return i;
            }
            if (bl) {
                return -1;
            }
            return -2;
        }

        @Override
        public int compare(IP iP, IP iP2) {
            int n = iP.addr & iP.mask;
            int n2 = iP2.addr & iP2.mask;
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }

        @Override
        public int bitsPerElement() {
            return 1;
        }

        @Override
        public boolean isPrefix(IP iP, int n, int n2, IP iP2) {
            int n3 = iP.addr & iP.mask;
            int n4 = iP2.addr & iP2.mask;
            n3 <<= n;
            int n5 = 0;
            for (int i = 0; i < n2; ++i) {
                n5 |= 1 << i;
            }
            return (n3 &= n5) == (n4 &= n5);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddFilter
    implements Trie.Cursor<IP, IP> {
        private final IP lookup;
        private List<IP> contained;

        AddFilter(IP iP) {
            this.lookup = iP;
        }

        public List<IP> getContained() {
            if (this.contained == null) {
                return Collections.emptyList();
            }
            return this.contained;
        }

        @Override
        public Trie.Cursor.SelectStatus select(Map.Entry<? extends IP, ? extends IP> entry) {
            IP iP = entry.getKey();
            if (iP.contains(this.lookup)) {
                return Trie.Cursor.SelectStatus.EXIT;
            }
            if (this.lookup.contains(iP)) {
                if (this.contained == null) {
                    this.contained = new ArrayList<IP>();
                }
                this.contained.add(iP);
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
            return Trie.Cursor.SelectStatus.EXIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValidFilter
    implements Trie.Cursor<IP, IP> {
        private static final int INVALID_SPACE = 60882944;
        private static final long TOTAL_SPACE = (long)Math.pow(2.0, 32.0) - 60882944L;
        private static final float MAX_LIST_SPACE = 0.025f;
        private boolean isInvalid;
        private long counter;
        private final boolean allowPrivateIPs;
        private final NetworkInstanceUtils networkInstanceUtils;

        public boolean isValid() {
            return !this.isInvalid && (float)this.counter / (float)TOTAL_SPACE < 0.025f;
        }

        public ValidFilter(boolean bl, NetworkInstanceUtils networkInstanceUtils) {
            this.allowPrivateIPs = bl;
            this.networkInstanceUtils = networkInstanceUtils;
        }

        @Override
        public Trie.Cursor.SelectStatus select(Map.Entry<? extends IP, ? extends IP> entry) {
            IP iP = entry.getKey();
            byte[] byArray = new byte[4];
            ByteOrder.int2beb(iP.addr, byArray, 0);
            if (!this.allowPrivateIPs && this.networkInstanceUtils.isPrivateAddress(byArray)) {
                this.isInvalid = true;
                return Trie.Cursor.SelectStatus.EXIT;
            }
            this.counter = (long)((double)this.counter + Math.pow(2.0, this.countBits(~iP.mask)));
            return Trie.Cursor.SelectStatus.CONTINUE;
        }

        private int countBits(int n) {
            n = (n >>> 1 & 0x55555555) + (n & 0x55555555);
            n = (n >>> 2 & 0x33333333) + (n & 0x33333333);
            n = (n >>> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
            n = (n >>> 8 & 0xFF00FF) + (n & 0xFF00FF);
            return (n >>> 16) + (n & 0xFFFF);
        }
    }
}

